/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.client.event;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class Toast
implements net.minecraft.client.gui.components.toasts.Toast {
    private Component title;
    private Component subtitle;
    private int titleColour;
    private int subtitleColour;
    private long lastChanged;
    private boolean changed;
    private int texture;
    private Toast.Visibility wantedVisibility;
    private static final ResourceLocation TEX_ADVANCEMENT = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final ResourceLocation TEX_RECIPE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final ResourceLocation TEX_SYSTEM = ResourceLocation.withDefaultNamespace((String)"toast/system");
    private static final ResourceLocation TEX_TUTORIAL = ResourceLocation.withDefaultNamespace((String)"toast/tutorial");

    public Toast(Component titleComponent, int clr, @Nullable Component subtitleComponent, int subClr, int texture) {
        this.title = titleComponent;
        this.titleColour = clr;
        this.subtitle = subtitleComponent;
        this.subtitleColour = subClr;
        this.texture = texture;
    }

    public int height() {
        ImmutableList subtitles = this.subtitle == null ? ImmutableList.of() : Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)this.subtitle, 130, Style.EMPTY);
        return 32 + Math.max(0, subtitles.size() - 1) * 12;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long visibilityTime) {
        double d;
        long l;
        if (this.changed) {
            this.lastChanged = visibilityTime;
            this.changed = false;
        }
        this.wantedVisibility = (double)(l = visibilityTime - this.lastChanged) < (d = 5000.0 * toastManager.getNotificationDisplayTimeMultiplier()) ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public void render(GuiGraphics graphics, Font font, long delta) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.width();
        int j = 12;
        ImmutableList subtitles = this.subtitle == null ? ImmutableList.of() : font.split((FormattedText)this.subtitle, 130);
        ResourceLocation tex = this.getTexture(this.texture);
        if (i == 160 && subtitles.size() <= 1) {
            graphics.blitSprite(RenderType::guiTextured, tex, 0, 0, i, this.height());
        } else {
            int k = this.height();
            int l = 28;
            int i1 = Math.min(4, k - 28);
            this.renderBackgroundRow(tex, graphics, i, 0, 0, 28);
            for (int j1 = 28; j1 < k - i1; j1 += 10) {
                this.renderBackgroundRow(tex, graphics, i, 16, j1, Math.min(10, k - j1 - i1));
            }
            this.renderBackgroundRow(tex, graphics, i, 32 - i1, k - i1, i1);
        }
        if (this.subtitle == null) {
            graphics.drawString(font, this.title, 18, 12, this.titleColour, false);
        } else {
            graphics.drawString(font, this.title, 18, 7, this.titleColour, false);
            for (int k1 = 0; k1 < subtitles.size(); ++k1) {
                graphics.drawString(font, (FormattedCharSequence)subtitles.get(k1), 18, 18 + k1 * 12, this.subtitleColour, false);
            }
        }
    }

    private void renderBackgroundRow(ResourceLocation tex, GuiGraphics guiGraphics, int width, int i, int j, int k) {
        int l = i == 0 ? 20 : 5;
        int m = Math.min(60, width - l);
        guiGraphics.blitSprite(RenderType::guiTextured, tex, 160, 32, 0, i, 0, j, l, k);
        for (int n = l; n < width - m; n += 64) {
            guiGraphics.blitSprite(RenderType::guiTextured, tex, 160, 32, 32, i, n, j, Math.min(64, width - n - m), k);
        }
        guiGraphics.blitSprite(RenderType::guiTextured, tex, 160, 32, 160 - m, i, width - m, j, m, k);
    }

    private ResourceLocation getTexture(int i) {
        return switch (i) {
            case 0 -> TEX_ADVANCEMENT;
            case 1 -> TEX_RECIPE;
            default -> TEX_SYSTEM;
            case 3 -> TEX_TUTORIAL;
        };
    }
}

