/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.client.gui.cci.window.popup;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.impl.DummyEvents;
import me.ichun.mods.cci.client.gui.cci.WorkspaceConfigs;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggle;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleRotatable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewPopup;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class WindowEventsViewer
extends Window<WorkspaceConfigs, ViewEventsViewer> {
    public WindowEventsViewer(WorkspaceConfigs parent) {
        super((Workspace)parent);
        this.setView(new ViewEventsViewer(this));
        this.disableDockingEntirely();
    }

    public static class ViewEventsViewer
    extends View<WindowEventsViewer> {
        public ElementList<?, String> list;
        public ElementButton buttonCount;
        public IEvent selected;
        public boolean hasInit;

        public ViewEventsViewer(@NotNull WindowEventsViewer parent) {
            super((Window)parent, "cci.gui.toolbar.eventViewer");
            String[] customSet;
            int padding = 3;
            this.buttonCount = new ElementButton((Fragment)this, "1", (btn, mouseX, mouseY) -> {});
            this.buttonCount.setSize(20, 20);
            this.buttonCount.setConstraint(new Constraint((Constrainable)this.buttonCount).left((Rectangle)this, Constraint.Property.Type.LEFT, padding).top((Rectangle)this, Constraint.Property.Type.TOP, padding));
            this.elements.add(this.buttonCount);
            ElementToggle buttonX = (ElementToggle)new ElementToggle((Fragment)this, "X", (btn, mouseX, mouseY) -> this.populate()).setSize(20, 20);
            ((ElementToggle)buttonX.setToggled(Screen.hasShiftDown())).setTooltip(I18n.get((String)"cci.gui.eventViewer.hideVar", (Object[])new Object[0])).setId("valueToggle");
            buttonX.setConstraint(new Constraint((Constrainable)buttonX).left((Rectangle)this, Constraint.Property.Type.LEFT, padding).top((Rectangle)this.buttonCount, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(buttonX);
            String[] lastRotatable = null;
            int i = 0;
            ArrayList<String> types = new ArrayList<String>(((WorkspaceConfigs)parent.parent).eventConfigurations.keySet());
            types.remove("constants");
            if (types.remove("minecraft")) {
                types.add("minecraft");
            }
            for (String s : types) {
                String[] rotatable = new ElementToggleRotatable((Fragment)this, s, -1, (b, mouseX, mouseY) -> {
                    if (b.toggleState) {
                        this.elements.stream().filter(element -> "configType".equals(element.id)).forEach(e -> {
                            ((ElementToggleRotatable)e).toggleState = false;
                        });
                        b.toggleState = true;
                        this.buttonCount.text = "1";
                        this.populate();
                    } else {
                        b.toggleState = true;
                    }
                });
                rotatable.setSize(90, 20).setId("configType");
                rotatable.setConstraint(new Constraint((Constrainable)rotatable).left((Rectangle)this, Constraint.Property.Type.LEFT, padding).top((Rectangle)(lastRotatable == null ? buttonX : lastRotatable), Constraint.Property.Type.BOTTOM, lastRotatable == null ? padding : 0));
                if (i == 0) {
                    rotatable.setToggled(true);
                }
                this.elements.add(rotatable);
                lastRotatable = rotatable;
                ++i;
            }
            ElementToggleRotatable refElement = null;
            for (String s : customSet = new String[]{"global", "notes"}) {
                ElementToggleRotatable rotatable = new ElementToggleRotatable((Fragment)this, s, 1, (b, mouseX, mouseY) -> {
                    if (b.toggleState) {
                        this.elements.stream().filter(element -> "configType".equals(element.id)).forEach(e -> {
                            ((ElementToggleRotatable)e).toggleState = false;
                        });
                        b.toggleState = true;
                        this.buttonCount.text = "1";
                        this.populate();
                    } else {
                        b.toggleState = true;
                    }
                });
                rotatable.setSize(90, 20).setId("configType");
                if (refElement == null) {
                    rotatable.setConstraint(new Constraint((Constrainable)rotatable).right((Rectangle)this, Constraint.Property.Type.RIGHT, padding).top((Rectangle)this, Constraint.Property.Type.TOP, padding));
                } else {
                    rotatable.setConstraint(new Constraint((Constrainable)rotatable).right(refElement, Constraint.Property.Type.RIGHT, 0).top(refElement, Constraint.Property.Type.BOTTOM, 0));
                }
                if (i == 0) {
                    rotatable.setToggled(true);
                }
                this.elements.add(rotatable);
                refElement = rotatable;
            }
            ElementScrollBar sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint((Constrainable)sv).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 60 + padding).right(refElement, Constraint.Property.Type.LEFT, padding));
            this.elements.add(sv);
            this.list = new ElementList((Fragment)this);
            this.list.setScrollVertical(sv).setConstraint(new Constraint(this.list).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 60 + padding).left((Rectangle)buttonX, Constraint.Property.Type.RIGHT, padding).right((Rectangle)sv, Constraint.Property.Type.LEFT, 0).top((Rectangle)this, Constraint.Property.Type.TOP, padding));
            this.elements.add(this.list);
            ElementButton buttonL = new ElementButton((Fragment)this, "<", (btn, mouseX, mouseY) -> {
                this.move(false);
                this.populate();
            });
            buttonL.setSize(20, 20);
            buttonL.setConstraint(new Constraint((Constrainable)buttonL).left((Rectangle)this.buttonCount, Constraint.Property.Type.RIGHT, padding).top(this.list, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(buttonL);
            ElementButton buttonR = new ElementButton((Fragment)this, ">", (btn, mouseX, mouseY) -> {
                this.move(true);
                this.populate();
            });
            buttonR.setSize(20, 20);
            buttonR.setConstraint(new Constraint((Constrainable)buttonR).right((Rectangle)sv, Constraint.Property.Type.RIGHT, 0).top(this.list, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(buttonR);
            ElementButton buttonRepeat = new ElementButton((Fragment)this, "cci.gui.eventViewer.replay", (btn, mouseX, mouseY) -> {
                ArrayList<IEvent> events;
                String type = null;
                for (Element element : this.elements) {
                    if (!"configType".equals(element.id) || !((ElementToggleRotatable)element).toggleState) continue;
                    type = ((ElementToggleRotatable)element).text;
                    break;
                }
                if (!(type == null || type.equals("global") || type.equals("notes") || this.selected == null || (events = EventHandler.EVENT_CACHE.get(type)).isEmpty())) {
                    events.remove(this.selected);
                    EventHandler.removeEventFromCache(this.selected.getId());
                    EventHandler.triggerOrQueueEvent(new DummyEvents(type, this.selected));
                }
            });
            buttonRepeat.setSize(80, 20);
            buttonRepeat.setConstraint(new Constraint((Constrainable)buttonRepeat).right((Rectangle)buttonR, Constraint.Property.Type.LEFT, padding).left((Rectangle)buttonL, Constraint.Property.Type.RIGHT, padding).top(this.list, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(buttonRepeat);
            ElementButton buttonDump = (ElementButton)new ElementButton((Fragment)this, "cci.gui.eventViewer.dump", (btn, mouseX, mouseY) -> {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String json = gson.toJson(EventHandler.EVENT_CACHE);
                try {
                    FileUtils.writeStringToFile((File)new File(ContentCreatorIntegration.cciProfileDir.toFile(), "dump.json"), (String)json, (Charset)StandardCharsets.UTF_8);
                    ContentCreatorIntegration.logger.info(LogType.CCI, "Dumped cached events to dump.json");
                    ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)100.0, w -> {}, (String[])new String[]{I18n.get((String)"cci.command.dump.success", (Object[])new Object[0])});
                }
                catch (IOException e) {
                    ContentCreatorIntegration.logger.warn(LogType.CCI, "Unable to write dump.json");
                    e.printStackTrace();
                    ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)100.0, w -> {}, (String[])new String[]{I18n.get((String)"cci.command.dump.fail", (Object[])new Object[0])});
                }
            }).setSize(90, 20);
            buttonDump.setTooltip(I18n.get((String)"cci.gui.eventViewer.dumpTip", (Object[])new Object[0]));
            buttonDump.setConstraint(new Constraint((Constrainable)buttonDump).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 10).left((Rectangle)buttonL, Constraint.Property.Type.LEFT, 0));
            this.elements.add(buttonDump);
            ElementButton buttonClear = (ElementButton)new ElementButton((Fragment)this, "cci.gui.eventViewer.clearQueues", (btn, mouseX, mouseY) -> {
                int count = 0;
                for (Map.Entry<String, ArrayList<Event.Queue>> stringArrayListEntry : EventHandler.QUEUES.entrySet()) {
                    count += stringArrayListEntry.getValue().size();
                }
                EventHandler.QUEUES.clear();
                ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.4, (double)100.0, w -> {}, (String[])new String[]{I18n.get((String)"cci.gui.eventViewer.queuesCleared", (Object[])new Object[]{count})});
            }).setSize(90, 20);
            buttonClear.setTooltip(I18n.get((String)"cci.gui.eventViewer.clearQueuesTip", (Object[])new Object[0]));
            buttonClear.setConstraint(new Constraint((Constrainable)buttonClear).left((Rectangle)buttonDump, Constraint.Property.Type.RIGHT, 8).top((Rectangle)buttonDump, Constraint.Property.Type.TOP, 0));
            this.elements.add(buttonClear);
            ElementButton button = new ElementButton((Fragment)this, I18n.get((String)"gui.ok", (Object[])new Object[0]), (btn, mouseX, mouseY) -> this.getWorkspace().removeWindow((Window)parent));
            button.setSize(60, 20);
            button.setConstraint(new Constraint((Constrainable)button).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, 10).right((Rectangle)buttonR, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(button);
        }

        public void init() {
            super.init();
            if (!this.hasInit) {
                this.hasInit = true;
                this.populate();
            }
        }

        public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
            if (((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).getFocused() == this.parent && Screen.hasControlDown() && keyCode == 67) {
                for (ElementList.Item item : this.list.items) {
                    if (!item.selected) continue;
                    if (Screen.hasShiftDown()) {
                        if (item.elements.size() > 1) {
                            ElementTextWrapper wrapper = (ElementTextWrapper)item.elements.get(1);
                            StringBuilder list = new StringBuilder();
                            for (int i = 0; i < wrapper.getText().size(); ++i) {
                                list.append((String)wrapper.getText().get(i));
                                if (i == wrapper.getText().size() - 1) continue;
                                list.append(", ");
                            }
                            ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).clipboard = list.toString();
                            ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).clipboardString = list.toString();
                            ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).getMinecraft().keyboardHandler.setClipboard(list.toString());
                            ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).setToolbarClipboardMessage(false);
                        }
                    } else {
                        ElementTextWrapper wrapper = (ElementTextWrapper)item.elements.get(0);
                        ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).clipboard = wrapper.getText().get(0);
                        ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).clipboardString = (String)wrapper.getText().get(0);
                        ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).getMinecraft().keyboardHandler.setClipboard((String)wrapper.getText().get(0));
                        ((WorkspaceConfigs)((WindowEventsViewer)this.parent).parent).setToolbarClipboardMessage(false);
                    }
                    return true;
                }
            }
            return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        }

        public void populate() {
            this.selected = null;
            this.list.setFocused(null);
            this.list.items.clear();
            String type = null;
            for (Element element : this.elements) {
                if (!"configType".equals(element.id) || !((ElementToggleRotatable)element).toggleState) continue;
                type = ((ElementToggleRotatable)element).text;
                break;
            }
            if (type != null) {
                if (type.equals("global")) {
                    this.buttonCount.text = "0";
                    boolean showValue = !((ElementToggle)this.getById((String)"valueToggle")).toggleState;
                    EventHandler.GLOBAL_VARIABLES.forEach((k, v) -> {
                        ElementList.Item item = this.list.addItem(k);
                        ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(k);
                        wrapper.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper).left((Rectangle)item, Constraint.Property.Type.LEFT, item.getBorderSize() + 2).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                        item.addElement((Element)wrapper);
                        if (showValue && v != null) {
                            wrapper = new ElementTextWrapper((Fragment)item).setText(this.getTextFor(v));
                            wrapper.setConstraint(new Constraint((Constrainable)wrapper).right((Rectangle)item, Constraint.Property.Type.RIGHT, item.getBorderSize() + 4).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                            item.addElement((Element)wrapper);
                            wrapper.init();
                            wrapper.setWidth(Math.min(wrapper.longestLine + 5, item.width - (this.getFontRenderer().width(k) + 10)));
                            wrapper.init();
                        }
                    });
                } else if (type.equals("notes")) {
                    this.buttonCount.text = "0";
                    boolean showValue = !((ElementToggle)this.getById((String)"valueToggle")).toggleState;
                    EventHandler.notes.forEach(note -> {
                        ElementList.Item item = this.list.addItem((Object)note.name);
                        ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(note.name);
                        wrapper.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper).left((Rectangle)item, Constraint.Property.Type.LEFT, item.getBorderSize() + 2).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                        item.addElement((Element)wrapper);
                        if (showValue) {
                            wrapper = new ElementTextWrapper((Fragment)item);
                            ArrayList<String> lines = new ArrayList<String>();
                            if (note.note != null) {
                                lines.add(note.note);
                            }
                            if (note.notes != null) {
                                lines.add(this.getTextFor(note.notes));
                            }
                            wrapper.setText(lines);
                            wrapper.setConstraint(new Constraint((Constrainable)wrapper).right((Rectangle)item, Constraint.Property.Type.RIGHT, item.getBorderSize() + 4).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                            item.addElement((Element)wrapper);
                            wrapper.init();
                            wrapper.setWidth(Math.min(wrapper.longestLine + 5, item.width - (this.getFontRenderer().width(note.name) + 10)));
                            wrapper.init();
                        }
                    });
                } else {
                    int index = Integer.parseInt(this.buttonCount.text) - 1;
                    ArrayList<IEvent> events = EventHandler.EVENT_CACHE.get(type);
                    if (events != null && !events.isEmpty() && index >= 0 && index < events.size()) {
                        boolean showValue = !((ElementToggle)this.getById((String)"valueToggle")).toggleState;
                        IEvent event = events.get(index);
                        TreeMap<String, Object> args = new TreeMap<String, Object>((Comparator<String>)Ordering.natural());
                        args.putAll(event.getArgs());
                        this.selected = event;
                        ElementList.Item item1 = this.list.addItem((Object)event.getId());
                        item1.setTooltip(I18n.get((String)"cci.gui.eventViewer.notAVar", (Object[])new Object[0]));
                        ElementTextWrapper wrapper1 = new ElementTextWrapper((Fragment)item1).setText("ID");
                        wrapper1.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper1).left((Rectangle)item1, Constraint.Property.Type.LEFT, item1.getBorderSize() + 2).top((Rectangle)item1, Constraint.Property.Type.TOP, item1.getBorderSize()));
                        item1.addElement((Element)wrapper1);
                        wrapper1 = new ElementTextWrapper((Fragment)item1).setText(event.getId());
                        wrapper1.setConstraint(new Constraint((Constrainable)wrapper1).right((Rectangle)item1, Constraint.Property.Type.RIGHT, item1.getBorderSize() + 4).top((Rectangle)item1, Constraint.Property.Type.TOP, item1.getBorderSize()));
                        item1.addElement((Element)wrapper1);
                        wrapper1.init();
                        wrapper1.setWidth(Math.min(wrapper1.longestLine + 5, item1.width - (this.getFontRenderer().width("ID") + 40)));
                        wrapper1.init();
                        args.forEach((k, v) -> {
                            ElementList.Item item = this.list.addItem(k);
                            ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(k);
                            wrapper.setNoWrap().setConstraint(new Constraint((Constrainable)wrapper).left((Rectangle)item, Constraint.Property.Type.LEFT, item.getBorderSize() + 2).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                            item.addElement((Element)wrapper);
                            if (showValue && v != null) {
                                wrapper = new ElementTextWrapper((Fragment)item).setText(this.getTextFor(v));
                                wrapper.setConstraint(new Constraint((Constrainable)wrapper).right((Rectangle)item, Constraint.Property.Type.RIGHT, item.getBorderSize() + 4).top((Rectangle)item, Constraint.Property.Type.TOP, item.getBorderSize()));
                                item.addElement((Element)wrapper);
                                wrapper.init();
                                wrapper.setWidth(Math.min(wrapper.longestLine + 5, item.width - (this.getFontRenderer().width(k) + 40)));
                                wrapper.init();
                            }
                        });
                    }
                }
                this.list.init();
                this.list.init();
            }
        }

        public String getTextFor(Object o) {
            if (o instanceof Object[]) {
                StringBuilder sb = new StringBuilder();
                Object[] objects = (Object[])o;
                for (int i = 0; i < objects.length; ++i) {
                    Object object = objects[i];
                    sb.append(object.toString());
                    if (i >= objects.length - 1) continue;
                    sb.append(", ");
                }
                return sb.toString();
            }
            return o.toString();
        }

        public void move(boolean up) {
            String type = null;
            for (Element element : this.elements) {
                if (!"configType".equals(element.id) || !((ElementToggleRotatable)element).toggleState) continue;
                type = ((ElementToggleRotatable)element).text;
                break;
            }
            if (type != null) {
                int index = Integer.parseInt(this.buttonCount.text) - 1;
                ArrayList<IEvent> events = EventHandler.EVENT_CACHE.get(type);
                if (events != null && !events.isEmpty()) {
                    if (up && index < events.size() - 1) {
                        this.buttonCount.text = Integer.toString(index + 2);
                    } else if (!up && index >= 1) {
                        this.buttonCount.text = Integer.toString(index);
                    }
                }
            }
        }
    }
}

