/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.DefaultEventConfiguration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.config.condition.ConstantCondition;
import me.ichun.mods.cci.common.config.outcome.ConstantOutcome;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.thread.ThreadGetOnlineConfigs;
import org.apache.commons.io.FileUtils;

public class EventConfiguration {
    public Configuration[] configs = new Configuration[0];
    public Event[] init = new Event[0];
    public String type;
    public String from;
    public transient boolean online = false;
    public static TreeMap<String, EventConfiguration> eventConfigurations = new TreeMap(Ordering.natural());
    public static final Gson SIMPLE_GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Condition.class, (Object)new Condition.Deserializer()).registerTypeAdapter(Outcome.class, (Object)new Outcome.Deserializer()).registerTypeAdapter(Condition[].class, (Object)new Condition.ArrayDeserializer()).registerTypeAdapter(Outcome[].class, (Object)new Outcome.ArrayDeserializer()).disableHtmlEscaping().setPrettyPrinting().create();
    public static final Gson SERIALIZER_GSON = new GsonBuilder().registerTypeAdapter(ConstantCondition.class, (Object)new Condition.ConstantConditionSerializer()).registerTypeAdapter(ConstantOutcome.class, (Object)new Outcome.ConstantOutcomeSerializer()).create();

    public static void readConfigurationFile(String name) {
        File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), name + ".json");
        if (file.exists()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                EventConfiguration config = (EventConfiguration)GSON.fromJson(json, EventConfiguration.class);
                config.type = name;
                eventConfigurations.put(name, config);
                config.init(name);
            }
            catch (IOException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading configuration file: " + file.getName());
                e.printStackTrace();
            }
        } else {
            ContentCreatorIntegration.logger.info(LogType.CCI, "Configuration file for " + name + " does not exist. Creating defaults");
            try {
                EventConfiguration config = DefaultEventConfiguration.getDefaults(name);
                FileUtils.writeStringToFile((File)file, (String)GSON.toJson((Object)config), (String)"UTF-8");
                eventConfigurations.put(name, config);
            }
            catch (IOException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing configuration file: " + file.getName());
                e.printStackTrace();
            }
        }
    }

    public static void reloadAllConfigurations() {
        TreeMap<String, EventConfiguration> clone = eventConfigurations;
        eventConfigurations = new TreeMap();
        ArrayList<String> online = new ArrayList<String>();
        for (Map.Entry<String, EventConfiguration> e : clone.entrySet()) {
            if (e.getKey().equals("constants") || e.getKey().equals("minecraft")) continue;
            if (e.getValue().online) {
                if (e.getValue().from == null || e.getValue().from.isEmpty()) continue;
                online.add(e.getValue().from);
                continue;
            }
            EventConfiguration.readConfigurationFile(e.getKey());
        }
        new ThreadGetOnlineConfigs(online).start();
        EventHandler.readConstants();
        EventHandler.readLibraries();
        EventHandler.combineConstants();
        EventHandler.readGameEventConfig();
        ContentCreatorIntegration.logger.info(LogType.CCI, "Reloaded all local configuration files");
    }

    public static TreeMap<String, EventConfiguration> getCopyOfConfigurations() {
        TreeMap eventConfigurations = (TreeMap)GSON.fromJson(new Gson().toJson(EventConfiguration.eventConfigurations), new TypeToken<TreeMap<String, EventConfiguration>>(){}.getType());
        for (Map.Entry<String, EventConfiguration> e : EventConfiguration.eventConfigurations.entrySet()) {
            if (!e.getValue().online) continue;
            ((EventConfiguration)eventConfigurations.get((Object)e.getKey())).online = true;
        }
        return eventConfigurations;
    }

    public void init(String configurationType) {
        if (this.init != null && this.init.length > 0) {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.putAll(EventHandler.GLOBAL_VARIABLES);
            args.put("configType", configurationType);
            args.put("eventType", "init");
            for (Event event : this.init) {
                EventHandler.tryEvents(new Event[]{event}, args);
            }
        }
    }

    public static class Configuration {
        public LinkedHashMap<String, Event[]> types = new LinkedHashMap();
        public String[] queue = null;
        public String[] ignoredTypes = null;
        @SerializedName(value="for")
        public String _for = null;
    }
}

