/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.condition.ConditionalCondition;
import me.ichun.mods.cci.common.config.condition.ConstantCondition;
import me.ichun.mods.cci.common.config.condition.GameSettingsCondition;
import me.ichun.mods.cci.common.config.condition.InventoryCondition;
import me.ichun.mods.cci.common.config.condition.JsonSafeCondition;
import me.ichun.mods.cci.common.config.condition.MessageCondition;
import me.ichun.mods.cci.common.config.condition.ModExistsCondition;
import me.ichun.mods.cci.common.config.condition.MultipleConditionCondition;
import me.ichun.mods.cci.common.config.condition.NoteCondition;
import me.ichun.mods.cci.common.config.condition.NotesListCondition;
import me.ichun.mods.cci.common.config.condition.PlayerStateCondition;
import me.ichun.mods.cci.common.config.condition.RandomCondition;
import me.ichun.mods.cci.common.config.condition.RangedAmountCondition;
import me.ichun.mods.cci.common.config.condition.ReadFileCondition;
import me.ichun.mods.cci.common.config.condition.ServerCondition;
import me.ichun.mods.cci.common.config.condition.SpecificAmountCondition;
import me.ichun.mods.cci.common.config.condition.SpecificUserCondition;
import me.ichun.mods.cci.common.config.condition.StatisticsCondition;
import me.ichun.mods.cci.common.config.condition.TargetCondition;
import me.ichun.mods.cci.common.config.condition.TargetExistsCondition;
import me.ichun.mods.cci.common.config.condition.TwoHighSpaceCondition;
import me.ichun.mods.cci.common.config.condition.UUIDToNBTCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayAppendCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayCombineCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayDeleteCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayExplodeCondition;
import me.ichun.mods.cci.common.config.condition.array.ArrayLengthCondition;
import me.ichun.mods.cci.common.config.condition.string.StringContainsCondition;
import me.ichun.mods.cci.common.config.condition.string.StringEndsWithCondition;
import me.ichun.mods.cci.common.config.condition.string.StringEqualsCondition;
import me.ichun.mods.cci.common.config.condition.string.StringStartsWithCondition;
import me.ichun.mods.cci.common.config.condition.string.StringSubStringCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.Base64DecodeCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.Base64EncodeCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.BaseConversionCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringCompareToCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringConcatCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringFormatCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringIndexOfCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringLengthCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringLowerCaseCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringReplaceCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringSplitCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringTrimCondition;
import me.ichun.mods.cci.common.config.condition.string.unconditional.StringUpperCaseCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.ArithmeticCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.LocalisedStringCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.LogArgsCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.NullCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.RandomNumberCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.RandomStringCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.RepeatCondition;
import me.ichun.mods.cci.common.config.condition.unconditional.RequestStatisticsCondition;
import me.ichun.mods.cci.common.config.condition.variable.VariableCondition;
import me.ichun.mods.cci.common.config.condition.variable.VariableExistsCondition;
import me.ichun.mods.cci.common.config.condition.variable.VariableIsArrayCondition;
import me.ichun.mods.cci.common.config.condition.variable.VariableIsNumberCondition;
import me.ichun.mods.cci.common.config.condition.variable.unconditional.VariableInsertCondition;
import me.ichun.mods.cci.common.config.condition.variable.unconditional.VariableRemoveCondition;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;

public abstract class Condition {
    public static HashMap<String, Class<? extends Condition>> CONDITION_TYPES = new HashMap<String, Class<? extends Condition>>(){
        {
            this.put("array", ArrayCondition.class);
            this.put("arrayLength", ArrayLengthCondition.class);
            this.put("arrayCombine", ArrayCombineCondition.class);
            this.put("arrayDelete", ArrayDeleteCondition.class);
            this.put("arrayAppend", ArrayAppendCondition.class);
            this.put("arrayExplode", ArrayExplodeCondition.class);
            this.put("baseConversion", BaseConversionCondition.class);
            this.put("base64Decode", Base64DecodeCondition.class);
            this.put("base64Encode", Base64EncodeCondition.class);
            this.put("localisedString", LocalisedStringCondition.class);
            this.put("stringConcat", StringConcatCondition.class);
            this.put("stringCompare", StringCompareToCondition.class);
            this.put("stringContains", StringContainsCondition.class);
            this.put("stringEnds", StringEndsWithCondition.class);
            this.put("stringEquals", StringEqualsCondition.class);
            this.put("stringFormat", StringFormatCondition.class);
            this.put("stringIndex", StringIndexOfCondition.class);
            this.put("stringLower", StringLowerCaseCondition.class);
            this.put("stringReplace", StringReplaceCondition.class);
            this.put("stringSplit", StringSplitCondition.class);
            this.put("stringStarts", StringStartsWithCondition.class);
            this.put("stringSubstr", StringSubStringCondition.class);
            this.put("stringTrim", StringTrimCondition.class);
            this.put("stringUpper", StringUpperCaseCondition.class);
            this.put("stringLength", StringLengthCondition.class);
            this.put("variableInsert", VariableInsertCondition.class);
            this.put("variableRemove", VariableRemoveCondition.class);
            this.put("variableIsArray", VariableIsArrayCondition.class);
            this.put("variableExists", VariableExistsCondition.class);
            this.put("variableCheck", VariableCondition.class);
            this.put("variableIsNumber", VariableIsNumberCondition.class);
            this.put("server", ServerCondition.class);
            this.put("multiple", MultipleConditionCondition.class);
            this.put("constant", ConstantCondition.class);
            this.put("modExists", ModExistsCondition.class);
            this.put("conditional", ConditionalCondition.class);
            this.put("repeat", RepeatCondition.class);
            this.put("readFile", ReadFileCondition.class);
            this.put("logArgs", LogArgsCondition.class);
            this.put("user", SpecificUserCondition.class);
            this.put("amount", SpecificAmountCondition.class);
            this.put("range", RangedAmountCondition.class);
            this.put("message", MessageCondition.class);
            this.put("random", RandomCondition.class);
            this.put("math", ArithmeticCondition.class);
            this.put("randomNumber", RandomNumberCondition.class);
            this.put("randomString", RandomStringCondition.class);
            this.put("null", NullCondition.class);
            this.put("note", NoteCondition.class);
            this.put("notesList", NotesListCondition.class);
            this.put("targetExists", TargetExistsCondition.class);
            this.put("target", TargetCondition.class);
            this.put("statsRequest", RequestStatisticsCondition.class);
            this.put("stats", StatisticsCondition.class);
            this.put("jsonSafe", JsonSafeCondition.class);
            this.put("gameSettings", GameSettingsCondition.class);
            this.put("inventory", InventoryCondition.class);
            this.put("playerState", PlayerStateCondition.class);
            this.put("freeSpace", TwoHighSpaceCondition.class);
            this.put("uuidToNBT", UUIDToNBTCondition.class);
        }
    };
    public static final Random RAND = new Random();
    protected String type = "unknown";
    public String displayName = null;
    public Boolean inverseMatch = null;

    public abstract boolean meetsCondition(HashMap<String, Object> var1);

    public abstract boolean isValid();

    public static class Deserializer
    implements JsonDeserializer<Condition>,
    JsonSerializer<Condition> {
        public Condition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Deserializer._deserialize(json, typeOfT, context);
        }

        public static Condition _deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonObject = (JsonObject)json;
            String type = jsonObject.get("type").getAsString();
            if (CONDITION_TYPES.containsKey(type)) {
                Condition condition = (Condition)EventConfiguration.GSON.fromJson(jsonObject.toString(), CONDITION_TYPES.get(type));
                if (condition.isValid()) {
                    return condition;
                }
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Invalid condition: " + jsonObject.toString());
            } else {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Unknown condition type: " + type);
            }
            return null;
        }

        public JsonElement serialize(Condition src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }
    }

    public static class ConstantConditionSerializer
    implements JsonSerializer<Condition> {
        public JsonElement serialize(Condition src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof ConstantCondition) {
                if (EventHandler.constants.conditions.containsKey(((ConstantCondition)src).name)) {
                    return context.serialize((Object)EventHandler.constants.conditions.get(((ConstantCondition)src).name));
                }
                return context.serialize((Object)new NullCondition());
            }
            return context.serialize((Object)src);
        }
    }

    public static class ArrayDeserializer
    implements JsonDeserializer<Condition[]> {
        public Condition[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array = (JsonArray)json;
            LinkedHashSet<Condition> conditions = new LinkedHashSet<Condition>();
            for (int i = 0; i < array.size(); ++i) {
                Condition condition = Deserializer._deserialize(array.get(i), typeOfT, context);
                if (condition == null) continue;
                conditions.add(condition);
            }
            return conditions.toArray(new Condition[conditions.size()]);
        }
    }
}

