/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import java.util.HashMap;
import java.util.Locale;
import me.ichun.mods.cci.common.config.condition.Condition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PlayerStateCondition
extends Condition {
    public String state;

    public PlayerStateCondition() {
        this.type = "playerState";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        return this.clientCheck();
    }

    @Override
    public boolean isValid() {
        return this.state != null && !this.state.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean clientCheck() {
        if (Minecraft.getInstance().player != null) {
            LocalPlayer player = Minecraft.getInstance().player;
            switch (this.state.toLowerCase(Locale.ROOT)) {
                case "alive": {
                    return player.isAlive();
                }
                case "invisible": {
                    return player.isInvisible();
                }
                case "onfire": {
                    return player.isOnFire();
                }
                case "onground": {
                    return player.onGround();
                }
                case "poisoned": {
                    return player.hasEffect(MobEffects.POISON);
                }
                case "sleeping": {
                    return player.isSleeping();
                }
                case "sneaking": {
                    return player.isShiftKeyDown();
                }
                case "swimming": {
                    return player.isSwimming();
                }
                case "isinwater": {
                    return player.isInWater();
                }
                case "isinwaterorrain": {
                    return player.isInWaterOrRain();
                }
                case "isinwaterorbubble": {
                    return player.isInWaterOrBubble();
                }
                case "isinwaterrainorbubble": {
                    return player.isInWaterRainOrBubble();
                }
                case "usingitem": {
                    return !player.getUseItem().isEmpty();
                }
                case "withering": {
                    return player.hasEffect(MobEffects.WITHER);
                }
            }
        }
        if (this.state.equalsIgnoreCase("exists")) {
            return Minecraft.getInstance().player != null;
        }
        return false;
    }
}

