/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class TargetCondition
extends Condition {
    public String target;
    public String argument;
    public String variableName;

    public TargetCondition() {
        this.type = "target";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        List<? extends Entity> targets = Event.getTarget(null, Event.replaceStringWithVariables(this.target, args));
        String targArg = Event.replaceStringWithVariables(this.argument, args);
        if (!targets.isEmpty()) {
            Entity target = targets.get(0);
            Object result = null;
            if (targArg.equalsIgnoreCase("name")) {
                result = target.getName().getString();
            } else if (targArg.equalsIgnoreCase("uuid")) {
                result = target.getUUID().toString();
            } else if (targArg.equalsIgnoreCase("health")) {
                result = target instanceof LivingEntity ? String.format("%.2f", Float.valueOf(((LivingEntity)target).getHealth())) : "-1";
            } else if (targArg.equalsIgnoreCase("maxhealth")) {
                result = target instanceof LivingEntity ? String.format("%.2f", Float.valueOf(((LivingEntity)target).getMaxHealth())) : "-1";
            } else if (targArg.equalsIgnoreCase("armor")) {
                result = target instanceof LivingEntity ? Integer.toString(((LivingEntity)target).getArmorValue()) : "-1";
            } else if (targArg.equalsIgnoreCase("location")) {
                result = String.format("%.2f", target.getX()) + " " + String.format("%.2f", target.getY()) + " " + String.format("%.2f", target.getZ());
            } else if (targArg.equalsIgnoreCase("locationx")) {
                result = String.format("%.2f", target.getX());
            } else if (targArg.equalsIgnoreCase("locationy")) {
                result = String.format("%.2f", target.getY());
            } else if (targArg.equalsIgnoreCase("locationz")) {
                result = String.format("%.2f", target.getZ());
            } else if (targArg.equalsIgnoreCase("rotationyaw")) {
                result = String.format("%.2f", Float.valueOf(target.getYRot()));
            } else if (targArg.equalsIgnoreCase("rotationpitch")) {
                result = String.format("%.2f", Float.valueOf(target.getXRot()));
            } else if (targArg.startsWith("lookx")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.getLookAngle();
                result = String.format("%.2f", look.x * d);
            } else if (targArg.startsWith("looky")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.getLookAngle();
                result = String.format("%.2f", look.y * d);
            } else if (targArg.startsWith("lookz")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(5));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.getLookAngle();
                result = String.format("%.2f", look.z * d);
            } else if (targArg.startsWith("look")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(4));
                }
                catch (NumberFormatException e) {
                    d = 1.0;
                }
                Vec3 look = target.getLookAngle();
                result = String.format("%.2f", look.x * d) + " " + String.format("%.2f", look.y * d) + " " + String.format("%.2f", look.z * d);
            } else if (targArg.startsWith("radiusx")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.getX() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiusy")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.getY() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiusz")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.getZ() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radiush")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(7));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.getX() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.getY()) + " " + String.format("%.2f", target.getZ() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.startsWith("radius")) {
                double d;
                try {
                    d = Double.parseDouble(targArg.substring(6));
                }
                catch (NumberFormatException e) {
                    d = 5.0;
                }
                result = String.format("%.2f", target.getX() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.getY() + (-d + RAND.nextDouble() * (2.0 * d))) + " " + String.format("%.2f", target.getZ() + (-d + RAND.nextDouble() * (2.0 * d)));
            } else if (targArg.equalsIgnoreCase("biome")) {
                BlockPos blockpos = target.blockPosition();
                LevelChunk chunk = target.getCommandSenderWorld().getChunkAt(blockpos);
                if (target.getCommandSenderWorld().hasChunkAt(blockpos) && blockpos.getY() >= 0 && blockpos.getY() < 256 && !chunk.isEmpty()) {
                    result = (String)target.getCommandSenderWorld().getBiome(blockpos).unwrap().map(resourceKey -> resourceKey.location().toString(), biome -> biome.toString());
                }
            } else if (targArg.equalsIgnoreCase("dim") || targArg.equalsIgnoreCase("dimension")) {
                result = target.level().dimension().location().toString();
            } else if (targArg.equalsIgnoreCase("lightblock")) {
                BlockPos blockpos = target.blockPosition();
                LevelChunk chunk = target.getCommandSenderWorld().getChunkAt(blockpos);
                if (target.getCommandSenderWorld().hasChunkAt(blockpos) && blockpos.getY() >= 0 && blockpos.getY() < 256 && !chunk.isEmpty()) {
                    result = Integer.toString(target.getCommandSenderWorld().getBrightness(LightLayer.BLOCK, blockpos));
                }
            } else if (targArg.equalsIgnoreCase("light")) {
                BlockPos blockpos = target.blockPosition();
                LevelChunk chunk = target.getCommandSenderWorld().getChunkAt(blockpos);
                if (target.getCommandSenderWorld().hasChunkAt(blockpos) && blockpos.getY() >= 0 && blockpos.getY() < 256 && !chunk.isEmpty()) {
                    result = Integer.toString(target.getCommandSenderWorld().getChunkSource().getLightEngine().getRawBrightness(blockpos, 0));
                }
            } else if (targArg.equalsIgnoreCase("diff") || targArg.equalsIgnoreCase("difficulty")) {
                BlockPos blockpos = target.blockPosition();
                LevelChunk chunk = target.getCommandSenderWorld().getChunkAt(blockpos);
                if (target.getCommandSenderWorld().hasChunkAt(blockpos) && blockpos.getY() >= 0 && blockpos.getY() < 256 && !chunk.isEmpty()) {
                    DifficultyInstance difficultyinstance = target.getCommandSenderWorld().getCurrentDifficultyAt(blockpos);
                    result = Integer.toString(difficultyinstance.getDifficulty().getId());
                }
            } else if (targArg.equalsIgnoreCase("time")) {
                result = Long.toString(target.getCommandSenderWorld().getDayTime());
            } else if (targArg.equalsIgnoreCase("day")) {
                result = Long.toString(target.getCommandSenderWorld().getDayTime() / 24000L);
            }
            if (result != null) {
                args.put(Event.replaceStringWithVariables(this.variableName, args), result);
                return true;
            }
            ContentCreatorIntegration.logger.error(LogType.EVENT, "No such target argument found: " + targArg);
            return false;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.target != null && !this.target.isEmpty() && this.argument != null && !this.argument.isEmpty() && this.variableName != null && !this.variableName.isEmpty();
    }
}

