/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TwoHighSpaceCondition
extends Condition {
    public String target;
    public String horiRadius;
    public String vertRadius;
    public String tries;
    public String variableName;
    public String customHeight;
    public String customWidth;
    public String minHoriDistance;
    public Boolean requireSolidBlock;

    public TwoHighSpaceCondition() {
        this.type = "freeSpace";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        List<? extends Entity> targets = Event.getTarget(null, Event.replaceStringWithVariables(this.target, args));
        if (!targets.isEmpty()) {
            double width;
            double horiRad = Event.getAsDouble(Event.replaceStringWithVariables(this.horiRadius, args));
            double vertRad = Event.getAsDouble(Event.replaceStringWithVariables(this.vertRadius, args));
            int triesParsed = Event.getAsInt(Event.replaceStringWithVariables(this.tries, args));
            double height = this.customHeight == null ? 2.0 : Event.getAsDouble(Event.replaceStringWithVariables(this.customHeight, args));
            double d = width = this.customWidth == null ? 1.0 : Event.getAsDouble(Event.replaceStringWithVariables(this.customWidth, args));
            if (height == 0.0 || width == 0.0) {
                return false;
            }
            Entity target = targets.get(0);
            double minHoriDist = this.minHoriDistance != null ? Event.getAsDouble(Event.replaceStringWithVariables(this.minHoriDistance, args)) : -1.0;
            double minX = target.getX() - horiRad;
            double maxX = target.getX() + horiRad;
            double minZ = target.getZ() - horiRad;
            double maxZ = target.getZ() + horiRad;
            double halfWidth = width / 2.0;
            AABB box = new AABB(-halfWidth, 0.0, -halfWidth, halfWidth, height, halfWidth);
            for (int i = 0; i < triesParsed; ++i) {
                double dX = minX + (maxX - minX) * RAND.nextDouble();
                double dZ = minZ + (maxZ - minZ) * RAND.nextDouble();
                if (Math.sqrt(target.distanceToSqr(dX, target.getY(), dZ)) < minHoriDist) continue;
                for (double j = -vertRad; j <= vertRad * 2.0 + 1.0; j += 1.0) {
                    BlockPos blockpos = new BlockPos(Mth.floor((double)dX), Mth.floor((double)(target.getY() - j)), Mth.floor((double)dZ));
                    if (this.requireSolidBlock != null && this.requireSolidBlock.booleanValue() && target.getCommandSenderWorld().getBlockState(blockpos.below()).isAir()) continue;
                    AABB displacedBox = box.move(blockpos).move(0.5, 0.0, 0.5).deflate(1.0E-5);
                    boolean hasCollision = false;
                    Iterable blockCollisions = target.getCommandSenderWorld().getBlockCollisions(null, displacedBox);
                    for (VoxelShape voxelshape : blockCollisions) {
                        if (voxelshape.isEmpty()) continue;
                        hasCollision = true;
                        break;
                    }
                    if (hasCollision) continue;
                    String result = String.format("%.2f", (double)Mth.floor((double)dX) + 0.5) + " " + String.format("%.2f", blockpos.getY()) + " " + String.format("%.2f", (double)Mth.floor((double)dZ) + 0.5);
                    args.put(Event.replaceStringWithVariables(this.variableName, args), result);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.target != null && !this.target.isEmpty() && this.horiRadius != null && this.vertRadius != null && this.tries != null && this.variableName != null;
    }
}

