/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CommandOutcome
extends Outcome {
    public String command;
    public Boolean executeAsSelf;
    public String handleFeedback;
    public String[] feedbackKeys;
    public Boolean disableChatCommandFallback;

    public CommandOutcome() {
        this.type = "command";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return iChunUtil.d().getEffectiveSide().isClient() && !Outcome.canDoServerOutcomes() && this.executeAsSelf != null && this.executeAsSelf != false && (this.disableChatCommandFallback == null || this.disableChatCommandFallback == false);
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        if (player == null) {
            return false;
        }
        String command = Event.replaceStringWithVariables(this.command, args);
        if (command.startsWith("/cci") || command.startsWith("cci")) {
            return false;
        }
        for (String cmd : ContentCreatorIntegration.configServer.disallowedCommands) {
            if (!command.startsWith("/" + cmd) && !command.startsWith(cmd)) continue;
            return false;
        }
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (this.isClientSide(args)) {
            this.sendCommandToServer(player, command);
        } else {
            CommandSourceStack commandSourceStack;
            MinecraftServer server = iChunUtil.d().getServer();
            boolean commandsAllowedForAll = server.getPlayerList().allowCommandsForAllPlayers;
            server.getPlayerList().allowCommandsForAllPlayers = true;
            if (this.executeAsSelf != null && this.executeAsSelf.booleanValue() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                commandSourceStack = new CommandSourceStack(serverPlayer.commandSource(), player.position(), player.getRotationVector(), serverPlayer.serverLevel(), 4, player.getName().getString(), player.getDisplayName(), serverPlayer.server, (Entity)player);
            } else {
                commandSourceStack = server.createCommandSourceStack();
            }
            CommandSourceStack source = commandSourceStack;
            boolean oriGameRule = false;
            boolean disableFeedback = false;
            if (this.handleFeedback == null) {
                oriGameRule = source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK);
                ((GameRules.BooleanValue)source.getLevel().getGameRules().getRule(GameRules.RULE_SENDCOMMANDFEEDBACK)).set(false, server);
                disableFeedback = true;
            }
            if (disableFeedback) {
                source.silent = true;
            }
            server.getCommands().performPrefixedCommand(source, command);
            server.getPlayerList().allowCommandsForAllPlayers = commandsAllowedForAll;
            if (this.handleFeedback == null) {
                ((GameRules.BooleanValue)source.getLevel().getGameRules().getRule(GameRules.RULE_SENDCOMMANDFEEDBACK)).set(oriGameRule, server);
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.command != null;
    }

    @Override
    public boolean doTrigger(Player player, HashMap<String, Object> args) {
        boolean flag = super.doTrigger(player, args);
        if (flag && this.requiresFeedbackListener()) {
            EventHandler.addCommandFeedbackListener(Event.replaceStringWithVariables(this.handleFeedback, args), this.feedbackKeys);
        }
        return flag;
    }

    public boolean requiresFeedbackListener() {
        return this.executeAsSelf != null && this.executeAsSelf != false && this.handleFeedback != null && !this.handleFeedback.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendCommandToServer(Player player, String command) {
        if (player instanceof LocalPlayer) {
            boolean flag = false;
            if (Minecraft.getInstance().player != null) {
                if (command.length() > 256) {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"cci.component.CommandOutcome.chat.fallbackWarning"), false);
                }
                for (int i = 0; i < command.length(); ++i) {
                    if (StringUtil.isAllowedChatCharacter((char)command.charAt(i))) continue;
                    flag = true;
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"cci.component.CommandOutcome.chat.illegalChar"), false);
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"cci.component.CommandOutcome.chat.illegalCharString", (Object[])new Object[]{Character.valueOf(command.charAt(i)), command}), false);
                    break;
                }
            }
            if (!flag) {
                ((LocalPlayer)player).connection.sendCommand(command);
            }
        }
    }
}

