/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.FocusableTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FakeCrashOutcome
extends Outcome {
    public String crashType;
    public String crashDuration;

    public FakeCrashOutcome() {
        this.type = "fakeCrash";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        ContentCreatorIntegration.logger.info(LogType.EVENT, "We are intentionally (fake) crashing the game!");
        int crashType = Event.getAsInt(Event.replaceStringWithVariables(this.crashType, args));
        int crashDuration = 100;
        if (this.crashDuration != null) {
            crashDuration = Event.getAsInt(Event.replaceStringWithVariables(this.crashDuration, args));
        }
        switch (crashType) {
            case 1: {
                try {
                    Thread.sleep((long)(crashDuration / 20) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            case 2: {
                this.openOOMScreen(crashDuration);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.crashType != null && !this.crashType.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openOOMScreen(int duration) {
        Minecraft.getInstance().setScreen((Screen)new MemoryErrorScreen(Minecraft.getInstance().screen, duration));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MemoryErrorScreen
    extends Screen {
        public Screen lastScreen;
        public int duration;
        public int currentDuration;
        private static final Component TITLE = Component.translatable((String)"outOfMemory.title");
        private static final Component MESSAGE = Component.translatable((String)"outOfMemory.message");
        private static final int MESSAGE_WIDTH = 300;
        private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);

        public MemoryErrorScreen(Screen lastScreen, int duration) {
            super(TITLE);
            this.lastScreen = lastScreen;
            this.duration = duration;
        }

        protected void init() {
            this.layout.addTitleHeader(TITLE, this.font);
            this.layout.addToContents((LayoutElement)new FocusableTextWidget(300, MESSAGE, this.font));
            LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
            linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_TO_TITLE, button -> {}).build());
            linearLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"menu.quit"), button -> {}).build());
            this.layout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.repositionElements();
        }

        public void tick() {
            super.tick();
            ++this.currentDuration;
            if (this.currentDuration > this.duration) {
                this.minecraft.setScreen(this.lastScreen);
            }
        }

        protected void repositionElements() {
            this.layout.arrangeElements();
        }

        public boolean shouldCloseOnEsc() {
            return false;
        }
    }
}

