/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GameSettingsOutcome
extends Outcome {
    public String key = null;
    public String value = null;

    public GameSettingsOutcome() {
        this.type = "gameSettings";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        return this.handleClient(player, args);
    }

    @Override
    public boolean isValid() {
        return this.key != null && !this.key.isEmpty() && this.value != null && !this.value.isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean handleClient(Player player, HashMap<String, Object> args) {
        boolean flag = false;
        try {
            String line;
            String keyVar = Event.replaceStringWithVariables(this.key, args);
            Options gs = Minecraft.getInstance().options;
            BufferedReader file = new BufferedReader(new FileReader(gs.optionsFile));
            StringBuilder inputBuffer = new StringBuilder();
            while ((line = file.readLine()) != null) {
                List split = Splitter.on((String)":").limit(2).splitToList((CharSequence)line);
                if (!split.isEmpty() && ((String)split.get(0)).equals(keyVar)) {
                    inputBuffer.append((String)split.get(0)).append(":").append(Event.replaceStringWithVariables(this.value, args)).append("\n");
                    flag = true;
                    continue;
                }
                inputBuffer.append(line).append("\n");
            }
            if (flag) {
                FileOutputStream opts = new FileOutputStream(gs.optionsFile);
                opts.write(inputBuffer.toString().getBytes());
                gs.load();
                gs.save();
            }
        }
        catch (IOException e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Error writing game settings key: " + this.key);
        }
        return flag;
    }
}

