/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryOutcome
extends Outcome {
    public String target;
    public String funcType;
    public String index;
    public String additionalArgs;

    public InventoryOutcome() {
        this.type = "inventory";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        List<? extends Entity> targets = Event.getTarget(player, Event.replaceStringWithVariables(this.target, args));
        if (!targets.isEmpty()) {
            String func;
            switch (func = Event.replaceStringWithVariables(this.funcType, args)) {
                case "drop": 
                case "delete": {
                    boolean bl;
                    int index = -2;
                    int count = -1;
                    try {
                        index = (int)Double.parseDouble(Event.replaceStringWithVariables(this.index, args));
                        count = (int)Double.parseDouble(Event.replaceStringWithVariables(this.additionalArgs, args));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (index < -1 || count <= 0) break;
                    boolean bl2 = false;
                    for (Entity entity : targets) {
                        if (!(entity instanceof LivingEntity)) continue;
                        if (entity instanceof Player) {
                            Inventory inventoryPlayer = ((Player)entity).getInventory();
                            if (func.equals("drop")) {
                                ContentCreatorIntegration.eventHandlerServer.playerDropItem((Player)entity, inventoryPlayer.removeItem(index == -1 ? inventoryPlayer.selected : index, count), true);
                            } else {
                                inventoryPlayer.removeItem(index == -1 ? inventoryPlayer.selected : index, count);
                            }
                            inventoryPlayer.setChanged();
                            bl = true;
                            continue;
                        }
                        if (index < 0) continue;
                        LivingEntity living = (LivingEntity)entity;
                        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                            ItemStack is;
                            if (equipmentSlot.getFilterBit(0) != index || (is = living.getItemBySlot(equipmentSlot)).isEmpty()) continue;
                            if (func.equals("drop")) {
                                living.spawnAtLocation((ServerLevel)living.level(), is.split(count), 0.0f);
                                living.setItemSlot(equipmentSlot, is);
                            } else {
                                is.split(count);
                                living.setItemSlot(equipmentSlot, is);
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
                case "add": {
                    void var9_23;
                    int index = -2;
                    int count = -1;
                    try {
                        index = (int)Double.parseDouble(Event.replaceStringWithVariables(this.index, args));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String string = Event.replaceStringWithVariables(this.additionalArgs, args).trim();
                    try {
                        int lastSpace = string.lastIndexOf(" ");
                        if (lastSpace != -1 && !string.endsWith("}")) {
                            count = (int)Double.parseDouble(string.substring(lastSpace + 1));
                            String string2 = string.substring(0, lastSpace);
                        } else {
                            count = 1;
                        }
                    }
                    catch (NumberFormatException e) {
                        ContentCreatorIntegration.logger.warn(LogType.EVENT, "Error parsing add item: " + string);
                        break;
                    }
                    if (index < -1) break;
                    try {
                        ItemParser.ItemResult itemResult = new ItemParser((HolderLookup.Provider)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup())).parse(new StringReader((String)var9_23));
                        ItemInput itemInput = new ItemInput(itemResult.item(), itemResult.components());
                        int j = Math.min(itemInput.getItem().getDefaultMaxStackSize(), count);
                        ItemStack stackToGive = itemInput.createItemStack(j, false);
                        boolean flag = false;
                        for (Entity entity : targets) {
                            if (!(entity instanceof LivingEntity)) continue;
                            if (entity instanceof Player) {
                                Inventory inventoryPlayer = ((Player)entity).getInventory();
                                inventoryPlayer.setItem(index == -1 ? inventoryPlayer.selected : index, stackToGive.copy());
                                inventoryPlayer.setChanged();
                                flag = true;
                                continue;
                            }
                            if (index < 0) continue;
                            LivingEntity living = (LivingEntity)entity;
                            for (EquipmentSlot e : EquipmentSlot.values()) {
                                if (e.getFilterBit(0) != index) continue;
                                living.setItemSlot(e, stackToGive.copy());
                                flag = true;
                            }
                        }
                        return flag;
                    }
                    catch (CommandSyntaxException e) {
                        ContentCreatorIntegration.logger.warn(LogType.EVENT, "Error parsing add item: " + (String)var9_23);
                        e.printStackTrace();
                        break;
                    }
                }
                case "swap": {
                    boolean bl;
                    int index = -2;
                    int otherIndex = -2;
                    try {
                        index = (int)Double.parseDouble(Event.replaceStringWithVariables(this.index, args));
                        otherIndex = (int)Double.parseDouble(Event.replaceStringWithVariables(this.additionalArgs, args));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (index < -1 || otherIndex < -1) break;
                    boolean bl3 = false;
                    for (Entity entity : targets) {
                        if (!(entity instanceof LivingEntity)) continue;
                        if (entity instanceof Player) {
                            Inventory inventoryPlayer = ((Player)entity).getInventory();
                            ItemStack firstStack = inventoryPlayer.getItem(index == -1 ? inventoryPlayer.selected : index);
                            inventoryPlayer.setItem(index == -1 ? inventoryPlayer.selected : index, inventoryPlayer.getItem(otherIndex));
                            inventoryPlayer.setItem(otherIndex == -1 ? inventoryPlayer.selected : otherIndex, firstStack);
                            inventoryPlayer.setChanged();
                            bl = true;
                            continue;
                        }
                        if (index < 0 || otherIndex < 0) continue;
                        LivingEntity living = (LivingEntity)entity;
                        block32: for (ItemStack itemStack : EquipmentSlot.values()) {
                            if (itemStack.getFilterBit(0) != index) continue;
                            ItemStack firstStack = living.getItemBySlot((EquipmentSlot)itemStack);
                            for (EquipmentSlot e1 : EquipmentSlot.values()) {
                                if (e1.getFilterBit(0) != otherIndex) continue;
                                living.setItemSlot((EquipmentSlot)itemStack, living.getItemBySlot(e1));
                                living.setItemSlot(e1, firstStack);
                                bl = true;
                                continue block32;
                            }
                        }
                    }
                    return bl;
                }
                case "amount": {
                    boolean bl;
                    int index = -2;
                    int count = -1;
                    try {
                        index = (int)Double.parseDouble(Event.replaceStringWithVariables(this.index, args));
                        count = (int)Double.parseDouble(Event.replaceStringWithVariables(this.additionalArgs, args));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (index < -1) break;
                    boolean bl4 = false;
                    for (Entity entity : targets) {
                        if (!(entity instanceof LivingEntity)) continue;
                        if (entity instanceof Player) {
                            Inventory inventoryPlayer = ((Player)entity).getInventory();
                            ItemStack is = inventoryPlayer.getItem(index == -1 ? inventoryPlayer.selected : index);
                            if (is.isEmpty()) continue;
                            is.grow(count);
                            is.setPopTime(5);
                            inventoryPlayer.setChanged();
                            bl = true;
                            continue;
                        }
                        if (index < 0) continue;
                        LivingEntity living = (LivingEntity)entity;
                        for (ItemStack itemStack : EquipmentSlot.values()) {
                            ItemStack is;
                            if (itemStack.getFilterBit(0) != index || (is = living.getItemBySlot((EquipmentSlot)itemStack)).isEmpty()) continue;
                            is.grow(count);
                            is.setPopTime(5);
                            bl = true;
                        }
                    }
                    return bl;
                }
                case "playerSwap": {
                    List<? extends Entity> otherTargets = Event.getTarget(player, Event.replaceStringWithVariables(this.additionalArgs, args));
                    if (otherTargets.isEmpty()) break;
                    for (Entity entity : targets) {
                        if (!(entity instanceof Player)) continue;
                        for (Entity entity2 : otherTargets) {
                            if (entity2 == entity || !(entity2 instanceof Player)) continue;
                            Inventory inventoryPlayer = ((Player)entity).getInventory();
                            Inventory otherInventoryPlayer = ((Player)entity2).getInventory();
                            ListTag firstInv = inventoryPlayer.save(new ListTag());
                            inventoryPlayer.replaceWith(otherInventoryPlayer);
                            otherInventoryPlayer.load(firstInv);
                            inventoryPlayer.setChanged();
                            otherInventoryPlayer.setChanged();
                            return true;
                        }
                    }
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.target != null && this.funcType != null && this.index != null && this.additionalArgs != null;
    }
}

