/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.mojang.text2speech.Narrator;
import java.util.HashMap;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class NarratorOutcome
extends Outcome {
    public String message;
    public Boolean interrupts;

    public NarratorOutcome() {
        this.type = "narrator";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        String chatMsg = Event.replaceStringWithVariables(this.message, args);
        this.triggerClientSide(chatMsg);
        return true;
    }

    @Override
    public boolean isValid() {
        return this.message != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void triggerClientSide(String s) {
        Narrator narrator = Minecraft.getInstance().getNarrator().narrator;
        if (narrator != null && narrator.active()) {
            narrator.say(s, this.interrupts != null && this.interrupts != false);
        }
    }
}

