/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.util.UndashedUuid;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.ChatMessageOutcome;
import me.ichun.mods.cci.common.config.outcome.CommandOutcome;
import me.ichun.mods.cci.common.config.outcome.ConditionalOutcome;
import me.ichun.mods.cci.common.config.outcome.ConstantOutcome;
import me.ichun.mods.cci.common.config.outcome.EventOutcome;
import me.ichun.mods.cci.common.config.outcome.FakeCrashOutcome;
import me.ichun.mods.cci.common.config.outcome.FoodOutcome;
import me.ichun.mods.cci.common.config.outcome.GameCrashOutcome;
import me.ichun.mods.cci.common.config.outcome.GameSettingsOutcome;
import me.ichun.mods.cci.common.config.outcome.HealthOutcome;
import me.ichun.mods.cci.common.config.outcome.IMCOutcome;
import me.ichun.mods.cci.common.config.outcome.InputOutcome;
import me.ichun.mods.cci.common.config.outcome.InventoryOutcome;
import me.ichun.mods.cci.common.config.outcome.KeyPressOutcome;
import me.ichun.mods.cci.common.config.outcome.MotionOutcome;
import me.ichun.mods.cci.common.config.outcome.MountOutcome;
import me.ichun.mods.cci.common.config.outcome.MultipleOutcomeOutcome;
import me.ichun.mods.cci.common.config.outcome.NarratorOutcome;
import me.ichun.mods.cci.common.config.outcome.NoteDeletionOutcome;
import me.ichun.mods.cci.common.config.outcome.NoteOutcome;
import me.ichun.mods.cci.common.config.outcome.NullOutcome;
import me.ichun.mods.cci.common.config.outcome.ObjectAccessorOutcome;
import me.ichun.mods.cci.common.config.outcome.PopupOutcome;
import me.ichun.mods.cci.common.config.outcome.PromptOutcome;
import me.ichun.mods.cci.common.config.outcome.ReadFromUrlOutcome;
import me.ichun.mods.cci.common.config.outcome.RepeatOutcome;
import me.ichun.mods.cci.common.config.outcome.SoundOutcome;
import me.ichun.mods.cci.common.config.outcome.ToastOutcome;
import me.ichun.mods.cci.common.config.outcome.WriteToFileOutcome;
import me.ichun.mods.cci.common.config.outcome.cci.CCIChangeProfileOutcome;
import me.ichun.mods.cci.common.config.outcome.cci.CCIClearQueueOutcome;
import me.ichun.mods.cci.common.config.outcome.cci.CCIFromJsonOutcome;
import me.ichun.mods.cci.common.config.outcome.cci.CCISendEventToSocketOutcome;
import me.ichun.mods.cci.common.config.outcome.cci.CCISendToPlayerOutcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.network.packet.PacketOutcome;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class Outcome {
    public static HashMap<String, Class<? extends Outcome>> OUTCOME_TYPES = new HashMap<String, Class<? extends Outcome>>(){
        {
            this.put("cciChangeProfile", CCIChangeProfileOutcome.class);
            this.put("cciClearQueue", CCIClearQueueOutcome.class);
            this.put("cciFromJson", CCIFromJsonOutcome.class);
            this.put("cciSendToPlayer", CCISendToPlayerOutcome.class);
            this.put("cciSendEventToSocket", CCISendEventToSocketOutcome.class);
            this.put("note", NoteOutcome.class);
            this.put("noteDeletion", NoteDeletionOutcome.class);
            this.put("popup", PopupOutcome.class);
            this.put("prompt", PromptOutcome.class);
            this.put("input", InputOutcome.class);
            this.put("writeToFile", WriteToFileOutcome.class);
            this.put("readFromUrl", ReadFromUrlOutcome.class);
            this.put("crash", GameCrashOutcome.class);
            this.put("fakeCrash", FakeCrashOutcome.class);
            this.put("event", EventOutcome.class);
            this.put("multiple", MultipleOutcomeOutcome.class);
            this.put("constant", ConstantOutcome.class);
            this.put("conditional", ConditionalOutcome.class);
            this.put("repeat", RepeatOutcome.class);
            this.put("null", NullOutcome.class);
            this.put("imc", IMCOutcome.class);
            this.put("objectAccessor", ObjectAccessorOutcome.class);
            this.put("chat", ChatMessageOutcome.class);
            this.put("toast", ToastOutcome.class);
            this.put("narrator", NarratorOutcome.class);
            this.put("gameSettings", GameSettingsOutcome.class);
            this.put("keyPress", KeyPressOutcome.class);
            this.put("command", CommandOutcome.class);
            this.put("sound", SoundOutcome.class);
            this.put("mount", MountOutcome.class);
            this.put("health", HealthOutcome.class);
            this.put("motion", MotionOutcome.class);
            this.put("food", FoodOutcome.class);
            this.put("inventory", InventoryOutcome.class);
        }
    };
    protected String type = "unknown";
    public String displayName = null;
    public Integer weight = null;
    public Boolean disabled = null;

    public boolean isClientSide(HashMap<String, Object> args) {
        return false;
    }

    public boolean sendToServer(HashMap<String, Object> args) {
        if (iChunUtil.d().getEffectiveSide().isClient() && ContentCreatorIntegration.eventHandlerClient.canDoServerOutcomes && this.isInClientWorld()) {
            ArrayList<PacketOutcome> packets = PacketOutcome.createOutcomePackets(EventConfiguration.SERIALIZER_GSON.toJson((Object)this), args);
            for (PacketOutcome packet : packets) {
                ContentCreatorIntegration.channel.sendToServer((AbstractPacket)packet);
            }
            return true;
        }
        return iChunUtil.d().getEffectiveSide().isServer();
    }

    public boolean isDisabled() {
        return this.disabled != null && this.disabled != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isInClientWorld() {
        return Minecraft.getInstance().level != null;
    }

    public abstract boolean trigger(Player var1, HashMap<String, Object> var2);

    public abstract boolean isValid();

    public static void triggerOutcomes(Outcome[] outcomes, Boolean singleOutcomeOnly, HashMap<String, Object> args) {
        List<Object> outcomesToTrigger = new ArrayList<Outcome>();
        if (outcomes.length == 0) {
            return;
        }
        if (outcomes.length == 1) {
            if (outcomes[0].isDisabled()) {
                return;
            }
            outcomesToTrigger.add(outcomes[0]);
        } else {
            int weight = 0;
            for (Outcome outcome : outcomes) {
                if (outcome.isDisabled() || outcome.weight == null) continue;
                weight += outcome.weight.intValue();
            }
            if (weight <= 0) {
                outcomesToTrigger = Arrays.stream(outcomes).filter(o -> !o.isDisabled()).collect(Collectors.toList());
            } else {
                int currentWeight = 0;
                float f = EventHandler.RAND.nextFloat();
                for (Outcome outcome : outcomes) {
                    if (outcome.isDisabled() || outcome.weight == null || !(f < (float)(currentWeight += outcome.weight.intValue()) / (float)weight)) continue;
                    outcomesToTrigger.add(outcome);
                    break;
                }
            }
        }
        Object player = iChunUtil.d().getServer() != null && iChunUtil.d().getEffectiveSide().isServer() ? (args.containsKey("cci-type-origin") ? iChunUtil.d().getServer().getPlayerList().getPlayer(UndashedUuid.fromStringLenient((String)args.get("cci-type-origin").toString())) : iChunUtil.d().getServer().getPlayerList().getPlayer(Outcome.getClientPlayer().getGameProfile().getId())) : Outcome.getClientPlayer();
        for (Outcome outcome : outcomesToTrigger) {
            if (outcome.doTrigger((Player)player, args)) {
                if (singleOutcomeOnly == null || !singleOutcomeOnly.booleanValue()) continue;
                break;
            }
            if (outcome.isClientSide(args) || !ContentCreatorIntegration.configClient.allowOutcomesRequiringServerWait || !iChunUtil.d().getSide().isClient()) continue;
            EventHandler.OUTCOMES_WAITING_FOR_SERVER.add(new EventHandler.OutcomeArgs(outcome, args));
            if (singleOutcomeOnly == null || !singleOutcomeOnly.booleanValue()) continue;
            break;
        }
    }

    public boolean doTrigger(Player player, HashMap<String, Object> args) {
        boolean clientSide = this.isClientSide(args);
        if (clientSide) {
            if (iChunUtil.d().getEffectiveSide().isClient()) {
                return this.trigger(player != null ? player : Outcome.getClientPlayer(), args);
            }
            if (iChunUtil.d().getServer() != null && iChunUtil.d().getServer().isSingleplayer()) {
                Minecraft.getInstance().execute(() -> this.trigger(player != null ? player : Outcome.getClientPlayer(), args));
                return true;
            }
            return false;
        }
        if (iChunUtil.d().getEffectiveSide().isClient()) {
            return this.sendToServer(args);
        }
        return player != null && this.trigger(player, args);
    }

    public boolean doTriggerOrWait(Player player, HashMap<String, Object> args) {
        if (this.isDisabled()) {
            return false;
        }
        if (this.doTrigger(player, args)) {
            return true;
        }
        if (!this.isClientSide(args) && ContentCreatorIntegration.configClient.allowOutcomesRequiringServerWait && iChunUtil.d().getSide().isClient()) {
            EventHandler.OUTCOMES_WAITING_FOR_SERVER.add(new EventHandler.OutcomeArgs(this, args));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static boolean canDoServerOutcomes() {
        return iChunUtil.d().getSide().isClient() && ContentCreatorIntegration.eventHandlerClient != null && ContentCreatorIntegration.eventHandlerClient.canDoServerOutcomes;
    }

    public static class Deserializer
    implements JsonDeserializer<Outcome>,
    JsonSerializer<Outcome> {
        public Outcome deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Deserializer._deserialize(json, typeOfT, context);
        }

        public static Outcome _deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            JsonObject jsonObject = (JsonObject)json;
            String type = jsonObject.get("type").getAsString();
            if (OUTCOME_TYPES.containsKey(type)) {
                Outcome outcome = (Outcome)EventConfiguration.GSON.fromJson(jsonObject.toString(), OUTCOME_TYPES.get(type));
                if (outcome.isValid()) {
                    return outcome;
                }
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Invalid outcome: " + jsonObject.toString());
            } else {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Unknown outcome type: " + type);
            }
            return null;
        }

        public JsonElement serialize(Outcome src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src);
        }
    }

    public static class ConstantOutcomeSerializer
    implements JsonSerializer<Outcome> {
        public JsonElement serialize(Outcome src, Type typeOfSrc, JsonSerializationContext context) {
            if (src instanceof ConstantOutcome) {
                if (EventHandler.constants.outcomes.containsKey(((ConstantOutcome)src).name)) {
                    return context.serialize((Object)EventHandler.constants.outcomes.get(((ConstantOutcome)src).name));
                }
                return context.serialize((Object)new NullOutcome());
            }
            return context.serialize((Object)src);
        }
    }

    public static class ArrayDeserializer
    implements JsonDeserializer<Outcome[]> {
        public Outcome[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array = (JsonArray)json;
            LinkedHashSet<Outcome> outcomes = new LinkedHashSet<Outcome>();
            for (int i = 0; i < array.size(); ++i) {
                Outcome outcome = Deserializer._deserialize(array.get(i), typeOfT, context);
                if (outcome == null) continue;
                outcomes.add(outcome);
            }
            return outcomes.toArray(new Outcome[outcomes.size()]);
        }
    }
}

