/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

public class ReadFromUrlOutcome
extends Outcome {
    public String url;
    public String variableName;
    public Outcome outcome;

    public ReadFromUrlOutcome() {
        this.type = "readFromUrl";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        new ThreadReadFromUrl(Event.replaceStringWithVariables(this.url, args), Event.replaceStringWithVariables(this.variableName, args), this.outcome, args).start();
        return true;
    }

    @Override
    public boolean isValid() {
        return this.url != null && !this.url.isEmpty() && this.variableName != null && !this.variableName.isEmpty() && this.outcome != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ThreadReadFromUrl
    extends Thread {
        public final String url;
        public final String variableName;
        public final Outcome outcome;
        public final HashMap<String, Object> args;

        public ThreadReadFromUrl(String url, String variableName, Outcome outcome, HashMap<String, Object> args) {
            this.setName("CCI - Read From URL");
            this.setDaemon(true);
            this.url = url;
            this.variableName = variableName;
            this.outcome = outcome;
            this.args = args;
        }

        @Override
        public void run() {
            try {
                this.args.put(this.variableName, IOUtils.toString((Reader)new InputStreamReader(new URL(this.url).openStream())));
                Minecraft.getInstance().execute(() -> this.outcome.doTriggerOrWait(Outcome.getClientPlayer(), this.args));
            }
            catch (UnknownHostException e) {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "UnknownHostException - Error retrieving from url: " + this.url + " . Is your internet connection working?");
            }
            catch (MalformedURLException e) {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "MalformedURLException - Error retrieving from url: " + this.url + " . Is your url correct?");
            }
            catch (Exception e) {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Error retrieving from url: " + this.url);
                e.printStackTrace();
            }
        }
    }
}

