/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome.cci;

import java.util.ArrayList;
import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.network.packet.PacketOutcome;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CCISendToPlayerOutcome
extends Outcome {
    public String player;
    public Outcome outcome;
    public Boolean silenceErrors;

    public CCISendToPlayerOutcome() {
        this.type = "cciSendToPlayer";
    }

    @Override
    public boolean trigger(Player player, HashMap<String, Object> args) {
        String s = Event.replaceStringWithVariables(this.player, args);
        MinecraftServer server = player.getServer();
        ServerPlayer playerByUsername = server.getPlayerList().getPlayerByName(s);
        if (playerByUsername != null) {
            if (!ContentCreatorIntegration.eventHandlerServer.isPlayerWhitelisted((Player)playerByUsername)) {
                if (this.silenceErrors == null || !this.silenceErrors.booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"cci.component.CCISendToPlayerOutcome.error.notWhitelisted", (Object[])new Object[]{s}), false);
                }
                return true;
            }
            ContentCreatorIntegration.logger.info(LogType.CCI, "Sending outcome to: " + playerByUsername.getName().getString());
            ArrayList<PacketOutcome> packets = PacketOutcome.createOutcomePackets(EventConfiguration.SERIALIZER_GSON.toJson((Object)this.outcome), args);
            for (PacketOutcome packet : packets) {
                ContentCreatorIntegration.channel.sendTo((AbstractPacket)packet, playerByUsername);
            }
        } else if (this.silenceErrors == null || !this.silenceErrors.booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"cci.component.CCISendToPlayerOutcome.error.notFound", (Object[])new Object[]{s}), false);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.player != null && this.outcome != null;
    }
}

