/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.event;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import me.ichun.mods.cci.api.CCIApi;
import me.ichun.mods.cci.api.IApi;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.IEvents;
import me.ichun.mods.cci.api.socket.SocketProvider;
import me.ichun.mods.cci.client.event.Toast;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Constants;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.CommandOutcome;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.Note;
import me.ichun.mods.cci.common.event.Statistics;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.mc.config.GameEventConfig;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class EventHandler
implements IApi {
    public static Statistics stats;
    public static Constants constants;
    public static HashSet<Note> notes;
    public static Constants collectiveConstants;
    public static TreeMap<String, Constants> libraries;
    public static GameEventConfig gameEventConfig;
    public static final Random RAND;
    public static final HashMap<String, ArrayList<Event.Queue>> QUEUES;
    public static final ArrayList<OutcomeArgs> OUTCOMES_WAITING_FOR_SERVER;
    public static final HashSet<Event.Queue> DELAY_COUNTDOWN;
    public static final HashMap<Event, Integer> COOLDOWN_TIMER;
    public static final TreeMap<String, ArrayList<IEvent>> EVENT_CACHE;
    public static ArrayList<CommandFeedbackListener> commandFeedbackListeners;
    public static final HashMap<String, Object> GLOBAL_VARIABLES;

    public static void init() {
        CCIApi.setApiImpl(new EventHandler());
    }

    public static void readStatistics() {
        File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "stats.json");
        if (file.exists()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                stats = (Statistics)EventConfiguration.GSON.fromJson(json, Statistics.class);
            }
            catch (IOException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading statistics file");
                e.printStackTrace();
            }
        }
        if (stats == null) {
            stats = new Statistics();
        }
        EventHandler.stats.stats.removeIf(info -> info.layer == null || info.type == null);
    }

    public static void resetStats() {
        stats = new Statistics();
        try {
            FileUtils.writeStringToFile((File)new File(ContentCreatorIntegration.cciProfileDir.toFile(), "stats.json"), (String)EventConfiguration.GSON.toJson((Object)stats), (String)"UTF-8");
        }
        catch (IOException e) {
            ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing statistics file");
            e.printStackTrace();
        }
    }

    public static void readConstants() {
        File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "constants.json");
        if (file.exists()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                constants = (Constants)EventConfiguration.GSON.fromJson(json, Constants.class);
            }
            catch (IOException e2) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading constants file");
                e2.printStackTrace();
            }
        } else {
            ContentCreatorIntegration.logger.info(LogType.CCI, "Constants file does not exist. Creating.");
            try {
                constants = new Constants();
                FileUtils.writeStringToFile((File)file, (String)EventConfiguration.GSON.toJson((Object)constants), (String)"UTF-8");
            }
            catch (IOException e3) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing constants file");
                e3.printStackTrace();
            }
        }
        if (constants == null) {
            constants = new Constants();
        }
        EventHandler.constants.conditions.entrySet().removeIf(e -> e.getValue() == null);
        EventHandler.constants.outcomes.entrySet().removeIf(e -> e.getValue() == null);
        EventHandler.constants.events.entrySet().removeIf(e -> e.getValue() == null);
        EventConfiguration.eventConfigurations.put("constants", new EventConfiguration());
    }

    public static void readNotes() {
        try {
            File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "notes.json");
            if (file.exists()) {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                notes = (HashSet)EventConfiguration.GSON.fromJson(json, new TypeToken<HashSet<Note>>(){}.getType());
            }
        }
        catch (JsonSyntaxException | IOException e) {
            ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading notes.json");
            e.printStackTrace();
        }
        if (notes == null) {
            notes = new HashSet();
        }
    }

    public static void addNote(Note note) {
        if (note.name == null || note.name.isEmpty()) {
            return;
        }
        notes.remove(note);
        notes.add(note);
        EventHandler.saveNotes();
    }

    public static void saveNotes() {
        try {
            File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "notes.json");
            FileUtils.writeStringToFile((File)file, (String)EventConfiguration.GSON.toJson(notes), (String)"UTF-8");
        }
        catch (JsonSyntaxException | IOException e) {
            ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing notes.json");
            e.printStackTrace();
        }
    }

    public static Note getNote(String name) {
        for (Note n : notes) {
            if (!n.name.equals(name)) continue;
            return n;
        }
        return null;
    }

    public static void readLibraries() {
        libraries.clear();
        File libDir = ContentCreatorIntegration.cciLibsDir.toFile();
        if (libDir.exists() && libDir.isDirectory()) {
            File[] files = libDir.listFiles();
            int i = 0;
            for (File file : files) {
                if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
                try {
                    String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    Constants constant = (Constants)EventConfiguration.GSON.fromJson(json, Constants.class);
                    if (constant == null || constant.conditions.isEmpty() && constant.outcomes.isEmpty() && constant.events.isEmpty()) continue;
                    String name = file.getName().substring(0, file.getName().length() - 5);
                    libraries.put(name, constant);
                    ++i;
                }
                catch (IOException e) {
                    ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading library file: " + file.getName());
                    e.printStackTrace();
                }
            }
            if (i > 0) {
                ContentCreatorIntegration.logger.info(LogType.CCI, "Loaded " + i + " constants libraries");
            }
        }
    }

    public static void combineConstants() {
        collectiveConstants = new Constants();
        ArrayList<Constants> allOtherConstants = new ArrayList<Constants>();
        allOtherConstants.addAll(libraries.values());
        if (constants != null) {
            allOtherConstants.add(constants);
        }
        for (Constants constant : allOtherConstants) {
            EventHandler.collectiveConstants.conditions.putAll(constant.conditions);
            EventHandler.collectiveConstants.outcomes.putAll(constant.outcomes);
            EventHandler.collectiveConstants.events.putAll(constant.events);
        }
    }

    public static void readGameEventConfig() {
        if (ContentCreatorIntegration.isGameHooksDisabled()) {
            return;
        }
        File file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "gamehooks.json");
        if (file.exists()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                gameEventConfig = (GameEventConfig)EventConfiguration.GSON.fromJson(json, GameEventConfig.class);
            }
            catch (IOException e) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Error reading MC hooks file");
                e.printStackTrace();
            }
        }
        if (gameEventConfig == null) {
            gameEventConfig = new GameEventConfig();
        }
        EventConfiguration.eventConfigurations.put("minecraft", new EventConfiguration());
        ContentCreatorIntegration.eventHandlerClient.clientConfigChange();
    }

    public static void triggerOrQueueEvent(IEvents streamEvent) {
        EventConfiguration eventConfig = EventConfiguration.eventConfigurations.get(streamEvent.configurationType());
        if (eventConfig != null && eventConfig.configs != null) {
            for (EventConfiguration.Configuration config : eventConfig.configs) {
                if (config._for != null && !config._for.equals(streamEvent.forType())) continue;
                String streamEventType = streamEvent.eventType();
                boolean ignore = false;
                if (config.ignoredTypes != null) {
                    for (String ignoredType : config.ignoredTypes) {
                        if (!ignoredType.equals(streamEventType)) continue;
                        ignore = true;
                        break;
                    }
                }
                if (ignore) continue;
                String queueType = null;
                if (config.queue != null) {
                    for (String queueString : config.queue) {
                        if (!queueString.contains(streamEventType)) continue;
                        queueType = queueString;
                        break;
                    }
                }
                Event[] events = config.types.get(streamEventType);
                if (config.types.containsKey("all")) {
                    ArrayList<Event> list = new ArrayList<Event>(Arrays.asList(config.types.get("all")));
                    if (events != null) {
                        list.addAll(Arrays.asList(events));
                    }
                    events = list.toArray(new Event[0]);
                }
                for (int i = 0; i < streamEvent.eventCount(); ++i) {
                    IEvent actualEvent = streamEvent.getEvent(i);
                    if (!EventHandler.cacheEvent(streamEvent.configurationType(), actualEvent)) continue;
                    HashMap<String, Object> args = actualEvent.getArgs();
                    args.putAll(GLOBAL_VARIABLES);
                    args.put("cci-type-config", streamEvent.configurationType());
                    args.put("cci-type-for", streamEvent.forType());
                    args.put("cci-type-event", streamEventType);
                    if (queueType != null) {
                        args.put("cci-type-queue", queueType);
                    }
                    if (events == null) continue;
                    EventHandler.tryEvents(events, args);
                }
            }
            if (ContentCreatorIntegration.eventHandlerClient.debugMode) {
                for (int i = 0; i < streamEvent.eventCount(); ++i) {
                    IEvent actualEvent = streamEvent.getEvent(i);
                    EventHandler.cacheEvent(streamEvent.configurationType(), actualEvent);
                }
            }
        } else {
            ContentCreatorIntegration.logger.error(LogType.CCI, "Missing event configuration: " + streamEvent.configurationType());
        }
    }

    public static void triggerGameEvent(IEvent ievent, Event[] events) {
        if (!EventHandler.cacheEvent("minecraft", ievent)) {
            return;
        }
        if (events != null) {
            EventHandler.tryEvents(events, ievent.getArgs());
        }
    }

    public static void tryEvents(Event[] events, HashMap<String, Object> args) {
        boolean triggered = false;
        for (Event event : events) {
            if (event.conditions.length == 0 && event.outcomes.length == 0 && (event.constantName == null || event.constantName.isEmpty())) {
                ContentCreatorIntegration.logger.warn(LogType.EVENT, "Event has no conditions or outcomes. Skipping. Event: " + new Gson().toJson((Object)event));
                continue;
            }
            if (event.disabled != null && event.disabled.booleanValue() || !event.meetsCondition(args)) continue;
            triggered = true;
            boolean flag = event.allowsOtherEventsToTrigger == null || event.allowsOtherEventsToTrigger == false;
            Integer playTime = event.getPlayTime(args);
            if (args.containsKey("cci-type-queue") && playTime != null && playTime >= 0) {
                EventHandler.putInQueue((String)args.get("cci-type-queue"), event, args);
            } else if (event.getDelay(args) != null) {
                DELAY_COUNTDOWN.add(new Event.Queue(event, args));
            } else if (EventHandler.triggerEvent(event, args)) {
                flag = false;
            }
            if (flag) break;
        }
        if (triggered && iChunUtil.d().getSide().isClient() && ContentCreatorIntegration.configClient.stats && args.containsKey("cci-type-config") && args.containsKey("cci-type-event")) {
            double amount = 0.0;
            if (args.containsKey("amount")) {
                try {
                    amount = Double.parseDouble(args.get("amount").toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            stats.addStat((String)args.get("cci-type-config"), (String)args.get("cci-type-event"), amount);
        }
    }

    public static boolean triggerEvent(Event event, HashMap<String, Object> args) {
        boolean flag = false;
        Integer cool = event.getCooldown(args);
        if (cool != null) {
            if (EventHandler.onCooldown(event)) {
                if ((event.allowsOtherEventsToTrigger == null || !event.allowsOtherEventsToTrigger.booleanValue()) && event.disableShortCircuitWhenOnCooldown != null && event.disableShortCircuitWhenOnCooldown.booleanValue()) {
                    flag = true;
                }
            } else {
                EventHandler.putOnCooldown(event, cool);
                event.trigger(args);
            }
        } else {
            event.trigger(args);
        }
        return flag;
    }

    public static void tick() {
        Iterator<Map.Entry<String, ArrayList<Event.Queue>>> ite1 = QUEUES.entrySet().iterator();
        while (ite1.hasNext()) {
            Map.Entry<String, ArrayList<Event.Queue>> e = ite1.next();
            ArrayList<Event.Queue> events = e.getValue();
            if (events.isEmpty()) {
                ite1.remove();
                continue;
            }
            Event.Queue queue2 = events.get(0);
            if (queue2.delay > 0) {
                --queue2.delay;
                continue;
            }
            if (queue2.playTime == 0) {
                queue2.args.putAll(GLOBAL_VARIABLES);
                EventHandler.triggerEvent(queue2.event, queue2.args);
            }
            ++queue2.playTime;
            if (queue2.event.playTimeEvent != null) {
                queue2.args.put("currentPlayTime", queue2.playTime);
                queue2.args.put("totalPlayTime", queue2.eventPlayTime);
                EventHandler.triggerEvent(queue2.event.playTimeEvent, queue2.args);
            }
            if (queue2.playTime < queue2.eventPlayTime) continue;
            events.remove(0);
        }
        if (!OUTCOMES_WAITING_FOR_SERVER.isEmpty() && ContentCreatorIntegration.eventHandlerClient.canDoServerOutcomes && EventHandler.getWorld() != null) {
            for (OutcomeArgs oa : OUTCOMES_WAITING_FOR_SERVER) {
                oa.args.putAll(GLOBAL_VARIABLES);
                if (!oa.outcome.sendToServer(oa.args) || !(oa.outcome instanceof CommandOutcome) || !((CommandOutcome)oa.outcome).requiresFeedbackListener()) continue;
                EventHandler.addCommandFeedbackListener(Event.replaceStringWithVariables(((CommandOutcome)oa.outcome).handleFeedback, oa.args), ((CommandOutcome)oa.outcome).feedbackKeys);
            }
            OUTCOMES_WAITING_FOR_SERVER.clear();
        }
        HashSet<Event.Queue> delay_clone = new HashSet<Event.Queue>(DELAY_COUNTDOWN);
        delay_clone.forEach(queue -> {
            --queue.delay;
            if (queue.delay == 0) {
                queue.args.putAll(GLOBAL_VARIABLES);
                EventHandler.triggerEvent(queue.event, queue.args);
            }
        });
        DELAY_COUNTDOWN.removeIf(queue -> queue.delay == 0);
        Iterator<Map.Entry<Event, Integer>> ite = COOLDOWN_TIMER.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<Event, Integer> e = ite.next();
            e.setValue(e.getValue() - 1);
            if (e.getValue() >= 0) continue;
            ite.remove();
        }
        for (int i = commandFeedbackListeners.size() - 1; i >= 0; --i) {
            CommandFeedbackListener listener = commandFeedbackListeners.get(i);
            --listener.countdown;
            if (!listener.done && listener.countdown >= 0) continue;
            commandFeedbackListeners.remove(i);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Level getWorld() {
        return iChunUtil.eC().getWorld();
    }

    public static void putInQueue(String queue, Event event, HashMap<String, Object> args) {
        ArrayList events = QUEUES.computeIfAbsent(queue, v -> new ArrayList());
        events.add(new Event.Queue(event, args));
    }

    public static boolean onCooldown(Event event) {
        return COOLDOWN_TIMER.containsKey(event);
    }

    public static void putOnCooldown(Event event, int dur) {
        COOLDOWN_TIMER.put(event, dur);
    }

    private static boolean cacheEvent(String configurationType, IEvent event) {
        ArrayList cache = EVENT_CACHE.computeIfAbsent(configurationType, k -> new ArrayList());
        for (IEvent event1 : cache) {
            if (!event1.getId().equals(event.getId())) continue;
            return false;
        }
        cache.add(0, event);
        if (cache.size() > ContentCreatorIntegration.configClient.maxEventCache) {
            cache.remove(cache.size() - 1);
        }
        return true;
    }

    public static void removeEventFromCache(String eventId) {
        Iterator<Map.Entry<String, ArrayList<IEvent>>> ite = EVENT_CACHE.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<String, ArrayList<IEvent>> e = ite.next();
            ArrayList<IEvent> cache = e.getValue();
            for (int i = cache.size() - 1; i >= 0; --i) {
                IEvent ievent = cache.get(i);
                if (!ievent.getId().equals(eventId)) continue;
                cache.remove(i);
            }
            if (!cache.isEmpty()) continue;
            ite.remove();
        }
    }

    public static void addCommandFeedbackListener(@Nullable String var, @Nullable String[] keys) {
        commandFeedbackListeners.add(new CommandFeedbackListener(var, keys));
    }

    public static void sortArgs(HashMap<String, Object> args) {
        boolean repeat = true;
        while (repeat) {
            HashMap<CallSite, Object> temp = new HashMap<CallSite, Object>();
            Iterator<Map.Entry<String, Object>> ite = args.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, Object> e2 = ite.next();
                if (e2.getValue() == null) {
                    ite.remove();
                    continue;
                }
                if (e2.getValue() instanceof Map) {
                    Map map = (Map)e2.getValue();
                    for (Map.Entry entry : map.entrySet()) {
                        temp.put((CallSite)((Object)(e2.getKey() + "_" + String.valueOf(entry.getKey()))), entry.getValue());
                    }
                    ite.remove();
                    continue;
                }
                if (e2.getValue().getClass().isArray() && Map.class.isAssignableFrom(e2.getValue().getClass().getComponentType())) {
                    Map[] maps = (Map[])e2.getValue();
                    for (int i = 0; i < maps.length; ++i) {
                        temp.put((CallSite)((Object)(e2.getKey() + "_" + i)), maps[i]);
                    }
                    ite.remove();
                    continue;
                }
                if (!(e2.getValue() instanceof List)) continue;
                List list = (List)e2.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    temp.put((CallSite)((Object)(e2.getKey() + "_" + i)), list.get(i));
                }
                ite.remove();
            }
            args.putAll(temp);
            repeat = !temp.isEmpty();
        }
        args.entrySet().removeIf(e -> e.getValue() == null);
        for (Map.Entry<String, Object> e3 : args.entrySet()) {
            Double d;
            if (!(e3.getValue() instanceof Double) || (d = (Double)e3.getValue()) != Math.floor(d) || Double.isInfinite(d)) continue;
            e3.setValue(d.intValue());
        }
        args.putAll(GLOBAL_VARIABLES);
        if (!args.containsKey("user")) {
            if (args.containsKey("username")) {
                args.put("user", args.get("username"));
            }
            if (args.containsKey("name")) {
                args.put("user", args.get("name"));
            }
            if (args.containsKey("from")) {
                args.put("user", args.get("from"));
            }
        }
        if (!args.containsKey("amount")) {
            if (args.containsKey("viewers")) {
                args.put("amount", args.get("viewers"));
            }
            if (args.containsKey("months")) {
                args.put("amount", args.get("months"));
            }
            if (args.containsKey("raiders")) {
                args.put("amount", args.get("raiders"));
            }
        }
        if (!args.containsKey("message") && args.containsKey("type")) {
            args.put("message", args.get("type"));
        }
    }

    @Override
    public void triggerEvent(IEvents events) {
        EventHandler.triggerOrQueueEvent(events);
    }

    @Override
    public void readConfigurationFile(String configurationName) {
        EventConfiguration.readConfigurationFile(configurationName);
    }

    @Override
    public boolean registerSocketProvider(SocketProvider socketProvider) {
        SocketHandler.SOCKET_PROVIDERS.add(socketProvider);
        if (ContentCreatorIntegration.postInit) {
            SocketHandler.initialiseSockets(socketProvider.type(), -1);
            return true;
        }
        return false;
    }

    @Override
    public void triggerInformationalToast(Component title, Component subtitle) {
        EventHandler.triggerToast(title, subtitle);
    }

    public static void triggerToast(Component title, Component subtitle) {
        if (ContentCreatorIntegration.configClient.enableInformationToasts) {
            List list = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)title, 140, Style.EMPTY);
            if (list.size() > 1) {
                title = Component.literal((String)(((FormattedText)list.get(0)).getString() + "..."));
            }
            Component finalTitle = title;
            Minecraft.getInstance().execute(() -> ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast(finalTitle, -256, subtitle, -1, 2)));
        }
    }

    static {
        notes = new HashSet();
        libraries = new TreeMap(Ordering.natural());
        RAND = new Random();
        QUEUES = new HashMap();
        OUTCOMES_WAITING_FOR_SERVER = new ArrayList();
        DELAY_COUNTDOWN = new HashSet();
        COOLDOWN_TIMER = new HashMap();
        EVENT_CACHE = new TreeMap(Ordering.natural());
        commandFeedbackListeners = new ArrayList();
        GLOBAL_VARIABLES = new HashMap();
    }

    public static class OutcomeArgs {
        public final Outcome outcome;
        public final HashMap<String, Object> args;

        public OutcomeArgs(Outcome outcome, HashMap<String, Object> args) {
            this.outcome = outcome;
            this.args = args;
        }
    }

    public static class CommandFeedbackListener {
        @Nullable
        public final String var;
        @Nullable
        public final String[] keys;
        public int countdown = 20;
        public boolean done = false;

        public CommandFeedbackListener(String var, String[] keys) {
            this.var = var;
            this.keys = keys;
        }
    }
}

