/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.logger;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.Util;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class Logger {
    public static final HashSet<LogType> ENABLED_LOG_TYPES = (HashSet)Util.make(new HashSet(), set -> set.addAll(Arrays.asList(LogType.values())));
    public final org.slf4j.Logger logger;
    @NotNull
    public final File logFile;

    public Logger(org.slf4j.Logger logger) {
        this(logger, null);
    }

    public Logger(org.slf4j.Logger logger, File file) {
        this.logger = logger;
        this.logFile = file;
    }

    public void log(LogType type, Level logLevel, String format, Object ... msg) {
        if (!type.equals((Object)LogType.SOCKET_EVENT)) {
            switch (logLevel.ordinal()) {
                case 0: {
                    this.logger.info(String.format(format, msg));
                    break;
                }
                case 1: {
                    this.logger.warn(String.format(format, msg));
                    break;
                }
                case 2: {
                    this.logger.error(String.format(format, msg));
                }
            }
        }
        if (ENABLED_LOG_TYPES.contains((Object)type)) {
            try {
                FileUtils.writeStringToFile((File)this.logFile, (String)(String.format(format, msg) + "\n"), (String)"UTF-8", (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void log(LogType type, Level logLevel, Object msg) {
        this.log(type, logLevel, "%s", msg);
    }

    public void warn(LogType type, Object msg) {
        this.log(type, Level.WARN, msg);
    }

    public void info(LogType type, Object msg) {
        this.log(type, Level.INFO, msg);
    }

    public void error(LogType type, Object msg) {
        this.log(type, Level.ERROR, msg);
    }

    private static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

