/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.donationalerts;

import java.net.URISyntaxException;
import java.util.HashMap;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.donationalerts.event.DonationAlertsEvents;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.thread.ThreadSocket;
import me.ichun.shadow.io.socket.client.IO;
import me.ichun.shadow.io.socket.client.Socket;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ThreadDonationAlertsSocket
extends ThreadSocket {
    public ThreadDonationAlertsSocket(Logger logger, String socketToken, int id) {
        super(logger, socketToken, id);
    }

    @Override
    public String getSocketType() {
        return "DonationAlerts";
    }

    @Override
    public String getSocketUrl() {
        return "https://socket.donationalerts.ru";
    }

    @Override
    public Socket createSocket() throws URISyntaxException {
        Socket socket = this.getDefaultSocket();
        socket.off("connect").on("connect", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Connected to " + this.getSocketType() + " - " + this.getSocketId());
            this.resetReconnects();
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.connected"));
            Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadDonationAlertsSocket.this.getSocketId());
                }
            })));
            try {
                JSONObject auth = new JSONObject();
                auth.putOpt("token", this.getSocketToken());
                auth.putOpt("type", "minor");
                socket.emit("add-user", new Object[]{auth}, null);
            }
            catch (JSONException e) {
                this.getLogger().error(LogType.SOCKET_STATUS, "This shouldn't be happening!");
                e.printStackTrace();
            }
        }).on("authenticated", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Authenticated with DonationAlerts");
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.authenticated"));
            Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "authenticated", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadDonationAlertsSocket.this.getSocketId());
                }
            })));
        }).on("donation", args -> {
            for (Object arg : args) {
                this.getLogger().info(LogType.SOCKET_EVENT, "Event DA: " + arg.toString());
                JSONObject json = null;
                if (arg instanceof String) {
                    try {
                        json = new JSONObject(arg.toString());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else if (arg instanceof JSONObject) {
                    json = (JSONObject)arg;
                }
                if (json != null) {
                    DonationAlertsEvents event = DonationAlertsEvents.deserialize(json, this.getSocketId());
                    if (event == null) continue;
                    Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(event));
                    continue;
                }
                this.getLogger().info(LogType.SOCKET_EVENT, "Received DA event that cannot be parsed as a JSON.");
            }
        });
        return socket;
    }

    @Override
    protected IO.Options getOptions() {
        IO.Options options = new IO.Options();
        options.transports = new String[]{"websocket"};
        return options;
    }
}

