/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.streamelements;

import java.net.URISyntaxException;
import java.util.HashMap;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.module.streamelements.event.StreamElementsEvents;
import me.ichun.mods.cci.common.thread.ThreadSocket;
import me.ichun.shadow.io.socket.client.IO;
import me.ichun.shadow.io.socket.client.Socket;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ThreadStreamElementsSocket
extends ThreadSocket {
    public ThreadStreamElementsSocket(Logger logger, String socketToken, int id) {
        super(logger, socketToken, id);
    }

    @Override
    public String getSocketType() {
        return "StreamElements";
    }

    @Override
    public String getSocketUrl() {
        return "https://realtime.streamelements.com";
    }

    @Override
    public Socket createSocket() throws URISyntaxException {
        Socket socket = this.getDefaultSocket();
        socket.off("connect").on("connect", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Connected to " + this.getSocketType() + " - " + this.getSocketId() + ". Attempting to authenticate");
            this.resetReconnects();
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.authenticating"));
            try {
                JSONObject auth = new JSONObject();
                auth.putOpt("method", "jwt");
                auth.putOpt("token", this.getSocketToken());
                socket.emit("authenticate", new Object[]{auth}, null);
            }
            catch (JSONException e) {
                this.getLogger().error(LogType.SOCKET_STATUS, "This shouldn't be happening!");
                e.printStackTrace();
            }
            Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadStreamElementsSocket.this.getSocketId());
                }
            })));
        }).on("event", this::handleEvent).on("event:test", this::handleEvent).on("event:update", this::handleEvent).on("event:reset", this::handleEvent);
        return socket;
    }

    public void handleEvent(Object ... args) {
        for (Object arg : args) {
            this.getLogger().info(LogType.SOCKET_EVENT, "Event SE: " + arg.toString());
            StreamElementsEvents event = StreamElementsEvents.deserialize((JSONObject)arg, this.getSocketId());
            if (event == null) continue;
            Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(event));
        }
    }

    @Override
    protected IO.Options getOptions() {
        IO.Options options = new IO.Options();
        options.transports = new String[]{"websocket"};
        return options;
    }
}

