/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.twitch.chat;

import com.google.common.base.Splitter;
import com.mojang.util.UndashedUuid;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.thread.ThreadWebSocket;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshake;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class ThreadTwitchChatSocket
extends ThreadWebSocket {
    public ThreadTwitchChatSocket(Logger logger, String socketToken, int id) {
        super(logger, socketToken, id);
    }

    @Override
    public void run() {
        try {
            if (!EventConfiguration.eventConfigurations.containsKey("chat")) {
                EventConfiguration.readConfigurationFile("chat");
            }
            this.getLogger().info(LogType.SOCKET_STATUS, "Connecting to " + this.getSocketType() + " - " + this.getSocketId());
            this.socket = this.createWebSocket();
            this.socket.reconnectAttempt = this.reconnectAttempt;
            this.socket.connect();
        }
        catch (Exception e) {
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.failed"));
            e.printStackTrace();
        }
    }

    @Override
    public String getSocketType() {
        return "TwitchChat";
    }

    @Override
    public String getSocketUrl() {
        return "wss://irc-ws.chat.twitch.tv";
    }

    @Override
    public ThreadWebSocket.WebSocket createWebSocket() throws URISyntaxException {
        return new ThreadWebSocket.WebSocket(this, new URI(this.getSocketUrl()), this.getLogger(), this.getSocketType(), this.getSocketId()){
            private final Splitter COLON_SPLITTER;
            private final Splitter SEMI_COLON_SPLITTER;
            private final Splitter EQUAL_SPLITTER;
            private final Splitter COMMA_SPLITTER;
            private final Splitter FW_SLASH_SPLITTER;
            private final Splitter NEW_LINE_SPLITTER;
            private final Splitter SPACE_SPLITTER;
            {
                this.COLON_SPLITTER = Splitter.on((String)" :").limit(3);
                this.SEMI_COLON_SPLITTER = Splitter.on((String)";").omitEmptyStrings();
                this.EQUAL_SPLITTER = Splitter.on((String)"=");
                this.COMMA_SPLITTER = Splitter.on((String)",");
                this.FW_SLASH_SPLITTER = Splitter.on((String)"/");
                this.NEW_LINE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings();
                this.SPACE_SPLITTER = Splitter.on((String)" ");
            }

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                super.onOpen(handshakedata);
                String chanName = ThreadTwitchChatSocket.this.getSocketToken();
                if (chanName.contains(":")) {
                    String oauth = chanName.substring(chanName.indexOf(":") + 1);
                    chanName = chanName.substring(0, chanName.indexOf(":"));
                    this.send("PASS oauth:" + oauth);
                    this.send("NICK " + chanName);
                    this.send("CAP REQ :twitch.tv/tags twitch.tv/commands");
                    this.send("JOIN #" + chanName.toLowerCase());
                } else {
                    this.send("NICK justinfan" + (EventHandler.RAND.nextInt(9) + 1) + Integer.toString(EventHandler.RAND.nextInt(10)) + Integer.toString(EventHandler.RAND.nextInt(10)) + Integer.toString(EventHandler.RAND.nextInt(10)) + Integer.toString(EventHandler.RAND.nextInt(10)));
                    this.send("CAP REQ :twitch.tv/tags twitch.tv/commands");
                    this.send("JOIN #" + chanName.toLowerCase());
                }
            }

            @Override
            public void onMessage(String message) {
                List lines = this.NEW_LINE_SPLITTER.splitToList((CharSequence)message);
                for (String line : lines) {
                    this.getLogger().info(LogType.SOCKET_EVENT, "Event TC: " + line);
                    List messages = this.COLON_SPLITTER.splitToList((CharSequence)line);
                    if (messages.size() >= 2) {
                        String msg;
                        String metadata = (String)messages.get(0);
                        String command = (String)messages.get(1);
                        String string = msg = messages.size() == 3 ? ((String)messages.get(2)).trim() : "";
                        if (command.contains("#")) {
                            String name = null;
                            String commandActual = null;
                            String channel = null;
                            List cmdBits = this.SPACE_SPLITTER.splitToList((CharSequence)command);
                            for (int i = 0; i < cmdBits.size(); ++i) {
                                String cmd = (String)cmdBits.get(i);
                                if (cmd.startsWith("#")) {
                                    if (i > 0) {
                                        commandActual = ((String)cmdBits.get(i - 1)).trim();
                                    }
                                    channel = cmd.substring(1).trim();
                                    continue;
                                }
                                if (!cmd.contains("!") || !cmd.contains("@")) continue;
                                name = cmd.substring(0, cmd.indexOf("!")).trim();
                            }
                            if (name == null) {
                                name = "Server";
                            }
                            if (commandActual != null) {
                                String id = null;
                                String type = commandActual.toLowerCase();
                                HashMap<String, Object> args = new HashMap<String, Object>();
                                args.put("platform", "twitch");
                                args.put("cci-type-configId", this.getSocketId());
                                args.put("name", name);
                                args.put("source", channel);
                                if (!metadata.isEmpty()) {
                                    metadata = metadata.substring(1).trim();
                                    Object kvs = this.SEMI_COLON_SPLITTER.splitToList((CharSequence)metadata);
                                    Iterator iterator = kvs.iterator();
                                    while (iterator.hasNext()) {
                                        List badgeInfos;
                                        List badges;
                                        String s1 = (String)iterator.next();
                                        List kv = this.EQUAL_SPLITTER.splitToList((CharSequence)s1);
                                        if (kv.size() != 2) continue;
                                        String key = (String)kv.get(0);
                                        String value = (String)kv.get(1);
                                        if (key.equalsIgnoreCase("id")) {
                                            id = value;
                                            continue;
                                        }
                                        if (key.equalsIgnoreCase("badges")) {
                                            badges = this.COMMA_SPLITTER.splitToList((CharSequence)value);
                                            for (String badge : badges) {
                                                badgeInfos = this.FW_SLASH_SPLITTER.splitToList((CharSequence)badge);
                                                if (badgeInfos.size() != 2) continue;
                                                args.put("badges-" + (String)badgeInfos.get(0), badgeInfos.get(1));
                                            }
                                            continue;
                                        }
                                        if (key.equalsIgnoreCase("badge-info")) {
                                            badges = this.COMMA_SPLITTER.splitToList((CharSequence)value);
                                            for (String badge : badges) {
                                                badgeInfos = this.FW_SLASH_SPLITTER.splitToList((CharSequence)badge);
                                                if (badgeInfos.size() != 2) continue;
                                                args.put("badge-info-" + (String)badgeInfos.get(0), badgeInfos.get(1));
                                            }
                                            continue;
                                        }
                                        args.put(key, value);
                                    }
                                }
                                switch (commandActual) {
                                    case "PRIVMSG": {
                                        if (msg.length() > 6 && msg.substring(0, 6).equals("ACTION")) {
                                            type = "action";
                                            msg = msg.substring(7);
                                            break;
                                        }
                                        type = "message";
                                        break;
                                    }
                                    case "USERNOTICE": {
                                        if (args.containsKey("system-msg")) {
                                            args.put("system-msg", args.get("system-msg").toString().replace("\\s", " "));
                                        }
                                        if (!args.containsKey("msg-param-sub-plan-name")) break;
                                        args.put("msg-param-sub-plan-name", args.get("msg-param-sub-plan-name").toString().replace("\\s", " "));
                                        break;
                                    }
                                    case "HOSTTARGET": {
                                        List strings = this.SPACE_SPLITTER.splitToList((CharSequence)msg);
                                        if (strings.isEmpty()) break;
                                        Integer viewers = 0;
                                        if (((String)strings.get(0)).equals("-")) {
                                            type = "unhost";
                                        } else {
                                            type = "host";
                                            args.put("channel", ((String)strings.get(0)).trim());
                                        }
                                        if (strings.size() >= 2 && !((String)strings.get(1)).equals("-")) {
                                            try {
                                                viewers = Integer.parseInt((String)strings.get(1));
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                        }
                                        args.put("viewers", viewers);
                                    }
                                }
                                args.put("message", msg);
                                if (id == null) {
                                    id = UndashedUuid.toString((UUID)UUID.randomUUID());
                                }
                                GenericEvent event = new GenericEvent("chat", "twitch", type, id, args);
                                Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(event));
                            }
                        }
                    }
                    if (!line.contains("PING :tmi.twitch.tv")) continue;
                    this.send("PONG :tmi.twitch.tv");
                }
            }
        };
    }

    @Override
    public ThreadWebSocket copy() {
        return new ThreadTwitchChatSocket(this.getLogger(), this.getSocketToken(), this.getSocketId());
    }
}

