/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.youtube;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.youtube.event.ChatEvent;
import me.ichun.mods.cci.common.module.youtube.event.ChatEvents;
import me.ichun.shadow.org.json.JSONArray;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.IOUtils;

public class ThreadYoutubeChatSocket
extends Thread
implements ISocket {
    private static final String API_PREFIX = "https://youtube.googleapis.com/youtube/v3/";
    private final Logger logger;
    private final String apiKey;
    private final int socketId;
    private String channelId;
    private boolean killed;
    private int connectAttempt;

    public ThreadYoutubeChatSocket(Logger logger, String apiKey, String channelId, int id) {
        this.setName("CCI - " + this.getSocketType() + " - " + id + " Integration");
        this.setDaemon(true);
        this.logger = logger;
        this.apiKey = apiKey;
        this.channelId = channelId;
        this.socketId = id;
        this.killed = false;
    }

    @Override
    public void run() {
        if (this.apiKey.isEmpty()) {
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.apiKeyEmpty"));
            this.killSocket();
            return;
        }
        if (!EventConfiguration.eventConfigurations.containsKey("chat")) {
            EventConfiguration.readConfigurationFile("chat");
        }
        if (!this.channelId.startsWith("UC")) {
            this.logger.info(LogType.SOCKET_STATUS, "Getting channel ID from user ID: " + this.channelId);
            String query = "https://youtube.googleapis.com/youtube/v3/channels?part=id&fields=items(id)&key=" + this.apiKey + "&forUsername=" + this.channelId;
            try {
                JSONObject response = new JSONObject(IOUtils.toString((Reader)new InputStreamReader(new URL(query).openStream())));
                JSONArray items = response.getJSONArray("items");
                if (items.length() == 0) {
                    EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.cannotGetChannelId", (Object[])new Object[]{this.channelId}));
                    this.killSocket();
                    return;
                }
                this.channelId = items.getJSONObject(0).getString("id");
                this.logger.info(LogType.SOCKET_STATUS, "Channel ID found: " + this.channelId);
            }
            catch (IOException | JSONException e) {
                EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.cannotGetChannelId", (Object[])new Object[]{this.channelId}));
                e.printStackTrace();
                this.killSocket();
                return;
            }
        }
        this.logger.info(LogType.SOCKET_STATUS, "Getting video ID of currently live broadcast");
        String videoId = null;
        while (!this.killed) {
            String query = "https://youtube.googleapis.com/youtube/v3/search?part=snippet&fields=items(id(videoId))&eventType=live&type=video&channelId=" + this.channelId + "&key=" + this.apiKey;
            try {
                JSONObject response = new JSONObject(IOUtils.toString((Reader)new InputStreamReader(new URL(query).openStream())));
                JSONArray items = response.getJSONArray("items");
                if (items.length() > 0) {
                    this.connectAttempt = 0;
                    videoId = items.getJSONObject(0).getJSONObject("id").getString("videoId");
                    this.logger.info(LogType.SOCKET_STATUS, "Video ID get: " + videoId);
                    break;
                }
            }
            catch (IOException | JSONException e) {
                this.logger.error(LogType.SOCKET_STATUS, "Error trying to get video ID for channel: " + this.channelId);
                e.printStackTrace();
            }
            ++this.connectAttempt;
            if (this.connectAttempt <= ContentCreatorIntegration.configClient.maxAutomaticReconnects) {
                EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.cannotGetBroadcastIdRetrying", (Object[])new Object[]{this.channelId}));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.cannotGetBroadcastIdDisconnecting"));
            this.killSocket();
            return;
        }
        String chatId = null;
        String query = "https://youtube.googleapis.com/youtube/v3/videos?part=liveStreamingDetails&fields=items(liveStreamingDetails(activeLiveChatId))&id=" + videoId + "&key=" + this.apiKey;
        try {
            JSONObject response = new JSONObject(IOUtils.toString((Reader)new InputStreamReader(new URL(query).openStream())));
            JSONArray items = response.getJSONArray("items");
            if (items.length() > 0) {
                chatId = items.getJSONObject(0).getJSONObject("liveStreamingDetails").getString("activeLiveChatId");
                this.logger.info(LogType.SOCKET_STATUS, "Chat ID get: " + chatId);
            }
        }
        catch (IOException | JSONException e) {
            EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.cannotGetBroadcastIdDisconnecting"));
            this.logger.error(LogType.SOCKET_STATUS, "Error trying to get chat ID for channel: " + this.channelId);
            e.printStackTrace();
            this.killSocket();
            return;
        }
        String chatQuery = "https://youtube.googleapis.com/youtube/v3/liveChat/messages?part=id,snippet,authorDetails&liveChatId=" + chatId + "&key=" + this.apiKey;
        ArrayList lastChatEvents = new ArrayList();
        this.logger.info(LogType.SOCKET_STATUS, "Ready to... *shudder* ...process YouTube chat.");
        EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.ready"));
        boolean firstPass = true;
        String nextPageToken = null;
        while (!this.killed) {
            try {
                String chatQueryToUse = chatQuery;
                if (nextPageToken != null) {
                    chatQueryToUse = chatQuery + "&pageToken=" + nextPageToken;
                }
                JSONObject response = new JSONObject(IOUtils.toString((Reader)new InputStreamReader(new URL(chatQueryToUse).openStream())));
                ContentCreatorIntegration.logger.info(LogType.SOCKET_EVENT, "Event YC: " + String.valueOf(response));
                JSONArray items = response.getJSONArray("items");
                ArrayList<ChatEvent> chatEvents = new ArrayList<ChatEvent>();
                for (int i = 0; i < items.length(); ++i) {
                    ChatEvent chatEvent = ChatEvent.deserialise(items.getJSONObject(i));
                    if (chatEvent == null) continue;
                    chatEvents.add(chatEvent);
                }
                if (firstPass) {
                    firstPass = false;
                    lastChatEvents.addAll(chatEvents);
                } else {
                    ArrayList newChatEvents = new ArrayList(chatEvents);
                    newChatEvents.removeAll(lastChatEvents);
                    HashMap<String, ArrayList> eventByType = new HashMap<String, ArrayList>();
                    for (ChatEvent chatEvent : newChatEvents) {
                        ArrayList chats = eventByType.computeIfAbsent(chatEvent.getArgs().containsKey("type") ? chatEvent.getArgs().get("type").toString() : "generic", k -> new ArrayList());
                        chats.add(chatEvent);
                        chatEvent.getArgs().put("cci-type-configId", this.getSocketId());
                    }
                    Minecraft.getInstance().execute(() -> eventByType.forEach((k, v) -> EventHandler.triggerOrQueueEvent(new ChatEvents((String)k, (ArrayList<ChatEvent>)v))));
                    lastChatEvents = chatEvents;
                }
                if (response.has("nextPageToken")) {
                    nextPageToken = response.getString("nextPageToken");
                }
                this.connectAttempt = 0;
                Thread.sleep(response.has("pollingIntervalMillis") ? response.getLong("pollingIntervalMillis") : 5000L);
            }
            catch (IOException | InterruptedException | JSONException e) {
                this.logger.error(LogType.SOCKET_EVENT, "Error parsing chat.");
                e.printStackTrace();
                ++this.connectAttempt;
                if (this.connectAttempt > ContentCreatorIntegration.configClient.maxAutomaticReconnects) {
                    EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.errorDuringChatDC"));
                    this.killSocket();
                    return;
                }
                EventHandler.triggerToast((Component)Component.literal((String)(this.getSocketType() + " - " + this.getSocketId())), (Component)Component.translatable((String)"cci.toast.youtube.errorDuringChat"));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public boolean isOpen() {
        return !this.killed;
    }

    @Override
    public void killSocket() {
        this.killed = true;
    }

    @Override
    public int getSocketId() {
        return this.socketId;
    }

    @Override
    public String getSocketType() {
        return "YouTubeChat";
    }
}

