/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.youtube.event;

import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import org.jetbrains.annotations.Nullable;

public class ChatEvent
implements IEvent {
    private final String id;
    private final HashMap<String, Object> args;

    private ChatEvent(String id, HashMap<String, Object> args) {
        this.id = id;
        this.args = args;
    }

    @Override
    public HashMap<String, Object> getArgs() {
        return this.args;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof ChatEvent && ((ChatEvent)obj).getId().equals(this.getId());
    }

    @Nullable
    public static ChatEvent deserialise(JSONObject jsonObject) {
        try {
            String id = jsonObject.getString("id");
            HashMap args = (HashMap)EventConfiguration.GSON.fromJson(jsonObject.getJSONObject("snippet").toString(), new TypeToken<HashMap<String, Object>>(){}.getType());
            args.put("authorDetails", EventConfiguration.GSON.fromJson(jsonObject.getJSONObject("authorDetails").toString(), new TypeToken<HashMap<String, Object>>(){}.getType()));
            EventHandler.sortArgs(args);
            return new ChatEvent(id, args);
        }
        catch (JSONException e) {
            ContentCreatorIntegration.logger.error(LogType.SOCKET_EVENT, "Error parsing YouTube Chat event: " + String.valueOf(jsonObject));
            e.printStackTrace();
            return null;
        }
    }
}

