/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.loader.neoforge.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.CommandDispatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.IEvents;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.client.command.CCIClientCommand;
import me.ichun.mods.cci.client.core.EventHandlerClient;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.donationalerts.event.DonationAlertsEvents;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.module.streamelements.event.StreamElementsEvents;
import me.ichun.mods.cci.common.module.streamlabs.event.StreamlabsEvents;
import me.ichun.mods.cci.common.module.twitch.pubsub.ThreadTwitchPubSubSocket;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.ichunutil.loader.neoforge.event.client.OverlayChangeEvent;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

@OnlyIn(value=Dist.CLIENT)
public class EventHandlerClientNeoForge
extends EventHandlerClient {
    @SubscribeEvent
    public void onOverlayChangeEvent(OverlayChangeEvent event) {
        this.onOverlayChange(event.getCurrentOverlay(), event.getNewOverlay());
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        CCIClientCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (event.isSystem()) {
            for (EventHandler.CommandFeedbackListener listener : EventHandler.commandFeedbackListeners) {
                if (listener.done) continue;
                if (listener.var != null && !listener.var.isEmpty()) {
                    if (listener.keys != null) {
                        String[] stringArray = event.getMessage().getContents();
                        if (stringArray instanceof TranslatableContents) {
                            TranslatableContents text = (TranslatableContents)stringArray;
                            for (String key : listener.keys) {
                                if (!key.equals(text.getKey())) continue;
                                Minecraft.getInstance().execute(() -> EventHandler.GLOBAL_VARIABLES.put(listener.var, event.getMessage().getString()));
                                listener.done = true;
                                break;
                            }
                        }
                    } else {
                        Minecraft.getInstance().execute(() -> EventHandler.GLOBAL_VARIABLES.put(listener.var, event.getMessage().getString()));
                        listener.done = true;
                    }
                }
                if (!listener.done) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        if (this.showGuiEditConfig) {
            this.showGuiEditConfig = false;
            Minecraft.getInstance().setScreen((Screen)EventHandlerClientNeoForge.getGuiInstance(Minecraft.getInstance(), null));
        }
        EventHandler.tick();
        if (this.debugMode && this.tabDown && !InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)258) && Screen.hasShiftDown()) {
            if (this.bufferedReader == null) {
                try {
                    this.bufferedReader = new BufferedReader(new FileReader(new File(ContentCreatorIntegration.cciProfileDir.toFile(), "test.log")));
                    ContentCreatorIntegration.logger.info(LogType.DEBUG, "Loading test.log");
                }
                catch (IOException e) {
                    ContentCreatorIntegration.logger.info(LogType.DEBUG, "Error loading test.log");
                    e.printStackTrace();
                }
            }
            if (this.bufferedReader != null) {
                String[] slPrefixes = new String[]{"Event: ", "Event Replay: ", "Event SL: ", "Event Replay SL: "};
                String[] sePrefixes = new String[]{"Event SE: ", "Event Replay SE: "};
                String[] daPrefixes = new String[]{"Event DA: ", "Event Replay DA: "};
                String[] tpsPrefixes = new String[]{"Event TP: ", "Event Replay TP: "};
                try {
                    String line = null;
                    while ((line = this.bufferedReader.readLine()) != null) {
                        IEvents event1;
                        String eventLine;
                        boolean needBreak = false;
                        for (String s : slPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay SL: " + eventLine);
                            event1 = StreamlabsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                for (int i = 0; i < ((StreamlabsEvents)event1).eventCount(); ++i) {
                                    IEvent actualEvent = ((StreamlabsEvents)event1).getEvent(i);
                                    EventHandler.removeEventFromCache(actualEvent.getId());
                                }
                                Minecraft.getInstance().execute(() -> EventHandlerClientNeoForge.lambda$onClientTick$2((StreamlabsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : sePrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay SE: " + eventLine);
                            event1 = StreamElementsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                EventHandler.removeEventFromCache(((StreamElementsEvents)event1).getEvent(0).getId());
                                Minecraft.getInstance().execute(() -> EventHandlerClientNeoForge.lambda$onClientTick$3((StreamElementsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : daPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay DA: " + eventLine);
                            event1 = DonationAlertsEvents.deserialize(new JSONObject(eventLine), 0);
                            if (event1 != null) {
                                EventHandler.removeEventFromCache(((DonationAlertsEvents)event1).getEvent(0).getId());
                                Minecraft.getInstance().execute(() -> EventHandlerClientNeoForge.lambda$onClientTick$4((DonationAlertsEvents)event1));
                            }
                            needBreak = true;
                            break;
                        }
                        for (String s : tpsPrefixes) {
                            if (!line.startsWith(s)) continue;
                            eventLine = line.substring(s.length());
                            ContentCreatorIntegration.logger.info(LogType.DEBUG, "Event Replay TP: " + eventLine);
                            for (ISocket socket : SocketHandler.sockets) {
                                if (!(socket instanceof ThreadTwitchPubSubSocket)) continue;
                                GenericEvent event12 = ((ThreadTwitchPubSubSocket)socket).parseMessage(new JSONObject(eventLine));
                                if (event12 == null) break;
                                EventHandler.removeEventFromCache(event12.getEvent(0).getId());
                                Minecraft.getInstance().execute(() -> EventHandler.triggerOrQueueEvent(event12));
                                break;
                            }
                            needBreak = true;
                            break;
                        }
                        if (!needBreak) continue;
                        break;
                    }
                    if (line == null) {
                        this.bufferedReader.close();
                        this.bufferedReader = null;
                        ContentCreatorIntegration.logger.info(LogType.DEBUG, "End of test.log");
                    }
                }
                catch (IOException | JSONException exception) {
                    // empty catch block
                }
            }
        }
        this.tabDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)258);
    }

    private static /* synthetic */ void lambda$onClientTick$4(DonationAlertsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }

    private static /* synthetic */ void lambda$onClientTick$3(StreamElementsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }

    private static /* synthetic */ void lambda$onClientTick$2(StreamlabsEvents event1) {
        EventHandler.triggerOrQueueEvent(event1);
    }
}

