/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.shadow.io.socket.engineio.client.transports;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import me.ichun.shadow.io.socket.engineio.client.Transport;
import me.ichun.shadow.io.socket.engineio.client.transports.PollingXHR;
import me.ichun.shadow.io.socket.engineio.parser.Packet;
import me.ichun.shadow.io.socket.engineio.parser.Parser;
import me.ichun.shadow.io.socket.parseqs.ParseQS;
import me.ichun.shadow.io.socket.thread.EventThread;
import me.ichun.shadow.io.socket.utf8.UTF8Exception;
import me.ichun.shadow.io.socket.yeast.Yeast;
import me.ichun.shadow.okhttp3.OkHttpClient;
import me.ichun.shadow.okhttp3.Request;
import me.ichun.shadow.okhttp3.Response;
import me.ichun.shadow.okhttp3.WebSocket;
import me.ichun.shadow.okhttp3.WebSocketListener;
import me.ichun.shadow.okio.ByteString;

public class WebSocket
extends Transport {
    public static final String NAME = "websocket";
    private static final Logger logger = Logger.getLogger(PollingXHR.class.getName());
    private me.ichun.shadow.okhttp3.WebSocket ws;

    public WebSocket(Transport.Options opts) {
        super(opts);
        this.name = NAME;
    }

    @Override
    protected void doOpen() {
        TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.emit("requestHeaders", headers);
        final WebSocket self = this;
        WebSocket.Factory factory = this.webSocketFactory != null ? this.webSocketFactory : new OkHttpClient();
        Request.Builder builder = new Request.Builder().url(this.uri());
        for (Map.Entry entry : headers.entrySet()) {
            for (String v : (List)entry.getValue()) {
                builder.addHeader((String)entry.getKey(), v);
            }
        }
        Request request = builder.build();
        this.ws = factory.newWebSocket(request, new WebSocketListener(){

            @Override
            public void onOpen(me.ichun.shadow.okhttp3.WebSocket webSocket, Response response) {
                final Map<String, List<String>> headers = response.headers().toMultimap();
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.emit("responseHeaders", headers);
                        self.onOpen();
                    }
                });
            }

            @Override
            public void onMessage(me.ichun.shadow.okhttp3.WebSocket webSocket, final String text) {
                if (text == null) {
                    return;
                }
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onData(text);
                    }
                });
            }

            @Override
            public void onMessage(me.ichun.shadow.okhttp3.WebSocket webSocket, final ByteString bytes) {
                if (bytes == null) {
                    return;
                }
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onData(bytes.toByteArray());
                    }
                });
            }

            @Override
            public void onClosed(me.ichun.shadow.okhttp3.WebSocket webSocket, int code, String reason) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onClose();
                    }
                });
            }

            @Override
            public void onFailure(me.ichun.shadow.okhttp3.WebSocket webSocket, final Throwable t, Response response) {
                if (!(t instanceof Exception)) {
                    return;
                }
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        self.onError("websocket error", (Exception)t);
                    }
                });
            }
        });
    }

    @Override
    protected void write(Packet[] packets) throws UTF8Exception {
        final WebSocket self = this;
        this.writable = false;
        final Runnable done = new Runnable(){

            @Override
            public void run() {
                EventThread.nextTick(new Runnable(){

                    @Override
                    public void run() {
                        self.writable = true;
                        self.emit("drain", new Object[0]);
                    }
                });
            }
        };
        final int[] total = new int[]{packets.length};
        for (Packet packet : packets) {
            if (this.readyState != Transport.ReadyState.OPENING && this.readyState != Transport.ReadyState.OPEN) break;
            Parser.encodePacket(packet, new Parser.EncodeCallback(){

                public void call(Object packet) {
                    try {
                        if (packet instanceof String) {
                            self.ws.send((String)packet);
                        } else if (packet instanceof byte[]) {
                            self.ws.send(ByteString.of((byte[])packet));
                        }
                    }
                    catch (IllegalStateException e) {
                        logger.fine("websocket closed before we could write");
                    }
                    total[0] = total[0] - 1;
                    if (0 == total[0]) {
                        done.run();
                    }
                }
            });
        }
    }

    @Override
    protected void doClose() {
        if (this.ws != null) {
            this.ws.close(1000, "");
            this.ws = null;
        }
    }

    protected String uri() {
        String derivedQuery;
        HashMap<String, String> query = this.query;
        if (query == null) {
            query = new HashMap<String, String>();
        }
        String schema = this.secure ? "wss" : "ws";
        String port = "";
        if (this.port > 0 && ("wss".equals(schema) && this.port != 443 || "ws".equals(schema) && this.port != 80)) {
            port = ":" + this.port;
        }
        if (this.timestampRequests) {
            query.put(this.timestampParam, Yeast.yeast());
        }
        if ((derivedQuery = ParseQS.encode(query)).length() > 0) {
            derivedQuery = "?" + derivedQuery;
        }
        boolean ipv6 = this.hostname.contains(":");
        return schema + "://" + (ipv6 ? "[" + this.hostname + "]" : this.hostname) + port + this.path + derivedQuery;
    }
}

