/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8019;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class FakeCrashOutcome
extends Outcome {
    public String crashType;
    public String crashDuration;

    public FakeCrashOutcome() {
        this.type = "fakeCrash";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(class_1657 player, HashMap<String, Object> args) {
        ContentCreatorIntegration.logger.info(LogType.EVENT, "We are intentionally (fake) crashing the game!");
        int crashType = Event.getAsInt(Event.replaceStringWithVariables(this.crashType, args));
        int crashDuration = 100;
        if (this.crashDuration != null) {
            crashDuration = Event.getAsInt(Event.replaceStringWithVariables(this.crashDuration, args));
        }
        switch (crashType) {
            case 1: {
                try {
                    Thread.sleep((long)(crashDuration / 20) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            case 2: {
                this.openOOMScreen(crashDuration);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.crashType != null && !this.crashType.isEmpty();
    }

    @Environment(value=EnvType.CLIENT)
    public void openOOMScreen(int duration) {
        class_310.method_1551().method_1507((class_437)new MemoryErrorScreen(class_310.method_1551().field_1755, duration));
    }

    @Environment(value=EnvType.CLIENT)
    public static class MemoryErrorScreen
    extends class_437 {
        public class_437 lastScreen;
        public int duration;
        public int currentDuration;
        private static final class_2561 TITLE = class_2561.method_43471((String)"outOfMemory.title");
        private static final class_2561 MESSAGE = class_2561.method_43471((String)"outOfMemory.message");
        private static final int MESSAGE_WIDTH = 300;
        private final class_8132 layout = new class_8132((class_437)this);

        public MemoryErrorScreen(class_437 lastScreen, int duration) {
            super(TITLE);
            this.lastScreen = lastScreen;
            this.duration = duration;
        }

        protected void method_25426() {
            this.layout.method_57726(TITLE, this.field_22793);
            this.layout.method_48999((class_8021)new class_8019(300, MESSAGE, this.field_22793));
            class_8667 linearLayout = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
            linearLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_43109, button -> {}).method_46431());
            linearLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"menu.quit"), button -> {}).method_46431());
            this.layout.method_48206(arg_0 -> ((MemoryErrorScreen)this).method_37063(arg_0));
            this.method_48640();
        }

        public void method_25393() {
            super.method_25393();
            ++this.currentDuration;
            if (this.currentDuration > this.duration) {
                this.field_22787.method_1507(this.lastScreen);
            }
        }

        protected void method_48640() {
            this.layout.method_48222();
        }

        public boolean method_25422() {
            return false;
        }
    }
}

