/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import com.google.common.base.Splitter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.event.Note;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.class_1657;

public class NoteOutcome
extends Outcome {
    public static final Splitter SPLIT_COMMA = Splitter.on((String)", ");
    public static final char[] NUMBER_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public String noteName;
    public String noteContent;
    public Boolean append;
    public Boolean putInNotesArray;
    public String expiresIn;

    public NoteOutcome() {
        this.type = "note";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(class_1657 player, HashMap<String, Object> args) {
        String name = Event.replaceStringWithVariables(this.noteName, args);
        String content = Event.replaceStringWithVariables(this.noteContent, args);
        Note note = EventHandler.getNote(name);
        if (note == null) {
            note = new Note(name);
        }
        if (this.putInNotesArray != null && this.putInNotesArray.booleanValue()) {
            if (this.append != null && this.append.booleanValue()) {
                String[] notes = note.notes;
                if (notes == null) {
                    notes = new String[]{};
                }
                note.notes = new String[notes.length + 1];
                for (int i = 0; i < notes.length; ++i) {
                    note.notes[i] = notes[i];
                }
                note.notes[note.notes.length - 1] = content;
            } else {
                List strings = SPLIT_COMMA.splitToList((CharSequence)content);
                note.notes = strings.toArray(new String[strings.size()]);
            }
        } else {
            note.note = this.append != null && this.append != false && note.note != null ? note.note + content : content;
        }
        if (this.expiresIn != null) {
            String expires = Event.replaceStringWithVariables(this.expiresIn, args).toLowerCase(Locale.ROOT);
            if (expires.equalsIgnoreCase("null")) {
                note.expires = null;
            } else {
                Calendar calendar = Calendar.getInstance();
                try {
                    StringBuilder number = new StringBuilder();
                    for (int i = 0; i < expires.length(); ++i) {
                        char c = expires.charAt(i);
                        if (NoteOutcome.isNumber(c)) {
                            number.append(c);
                            continue;
                        }
                        if (c == ' ') continue;
                        int value = number.toString().isEmpty() ? 0 : Integer.parseInt(number.toString());
                        switch (c) {
                            case 'y': {
                                calendar.add(1, value);
                                break;
                            }
                            case 'd': {
                                calendar.add(5, value);
                                break;
                            }
                            case 'h': {
                                calendar.add(10, value);
                                break;
                            }
                            case 'm': {
                                calendar.add(12, value);
                                break;
                            }
                            case 's': {
                                calendar.add(13, value);
                                break;
                            }
                            default: {
                                ContentCreatorIntegration.logger.error(LogType.EVENT, "Unknown time value marker, ignoring: " + c);
                            }
                        }
                        number = new StringBuilder();
                    }
                    if (number.length() != 0) {
                        ContentCreatorIntegration.logger.info(LogType.EVENT, "Expiry has no trailing time marker, presuming seconds: " + expires);
                        calendar.add(13, Integer.parseInt(number.toString()));
                    }
                    note.expires = calendar.getTimeInMillis();
                }
                catch (NumberFormatException e) {
                    ContentCreatorIntegration.logger.error(LogType.EVENT, "Error parsing note expiry of: " + this.expiresIn + " ; " + expires + " ; in note name: " + note.name);
                    e.printStackTrace();
                }
            }
        }
        EventHandler.addNote(note);
        return true;
    }

    @Override
    public boolean isValid() {
        return this.noteName != null && this.noteContent != null;
    }

    private static boolean isNumber(char c) {
        for (char c1 : NUMBER_CHAR) {
            if (c != c1) continue;
            return true;
        }
        return false;
    }
}

