/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.mc.config.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.mc.config.reflect.ParamInjector;
import org.jetbrains.annotations.Nullable;

public class ObjectAccessor {
    private transient boolean catastrophicFailure = false;
    public String name;
    public String function;
    public transient Object functionObj;
    public ParamInjector[] paramInjectors;
    public transient Class<?>[] paramInjectorClasses;
    public String classForStaticAccess;
    public transient Class<?> classForStaticAccessClass;
    public Event preAccessorEvent;
    public String instanceCheck;
    public transient Class<?> instanceCheckClass;
    public Event postAccessorEvent;
    public ObjectAccessor[] nextAccessors;
    public Event nullObjectEvent;
    public String argName;

    public void process(Object o, HashMap<String, Object> args) {
        if (this.catastrophicFailure || args.containsKey("stopEventProcessing")) {
            return;
        }
        if (this.function != null) {
            boolean flag;
            Object nextObj;
            Class<?> refClass;
            Object refObj;
            if (this.classForStaticAccess != null) {
                if (this.classForStaticAccessClass == null) {
                    try {
                        this.classForStaticAccessClass = Class.forName(this.classForStaticAccess);
                    }
                    catch (ClassNotFoundException e) {
                        ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find class type, disabling object accessor: " + this.classForStaticAccess);
                        e.printStackTrace();
                        this.catastrophicFailure = true;
                        return;
                    }
                }
                refObj = null;
                refClass = this.classForStaticAccessClass;
            } else {
                refObj = o;
                refClass = o.getClass();
            }
            if (this.functionObj == null) {
                if (this.function.contains("(") || this.function.equals("<>")) {
                    if (this.paramInjectors != null) {
                        this.paramInjectorClasses = new Class[this.paramInjectors.length];
                        for (ParamInjector paramInjector : this.paramInjectors) {
                            if (!paramInjector.setup()) {
                                this.catastrophicFailure = true;
                                return;
                            }
                            this.paramInjectorClasses[i] = paramInjector.classTypeClass;
                        }
                    } else {
                        this.paramInjectorClasses = new Class[0];
                    }
                    this.functionObj = this.function.equals("<>") ? ObjectAccessor.findConstructor(refClass, this.paramInjectorClasses) : ObjectAccessor.findMethod(refClass, this.function.substring(0, this.function.indexOf("(")), this.paramInjectorClasses);
                } else {
                    this.functionObj = ObjectAccessor.findField(refClass, this.function);
                }
                if (this.functionObj == null) {
                    this.catastrophicFailure = true;
                    return;
                }
            }
            if (this.preAccessorEvent != null) {
                EventHandler.tryEvents(new Event[]{this.preAccessorEvent}, args);
                if (args.containsKey("stopEventProcessing")) {
                    return;
                }
            }
            try {
                if (this.function.equals("<>")) {
                    Constructor c = (Constructor)this.functionObj;
                    c.setAccessible(true);
                    params = new Object[this.paramInjectorClasses.length];
                    for (i = 0; i < params.length; ++i) {
                        params[i] = this.paramInjectors[i].pullArg(args);
                    }
                    nextObj = c.newInstance(params);
                } else if (this.function.contains("(")) {
                    Method method = (Method)this.functionObj;
                    method.setAccessible(true);
                    params = new Object[this.paramInjectorClasses.length];
                    for (i = 0; i < params.length; ++i) {
                        params[i] = this.paramInjectors[i].pullArg(args);
                    }
                    nextObj = method.invoke(refObj, params);
                } else {
                    Field field = (Field)this.functionObj;
                    field.setAccessible(true);
                    nextObj = field.get(refObj);
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Error executing the function: " + this.function);
                e.printStackTrace();
                this.catastrophicFailure = true;
                return;
            }
            boolean bl = flag = nextObj == null;
            if (flag && this.nullObjectEvent != null) {
                EventHandler.tryEvents(new Event[]{this.nullObjectEvent}, args);
                if (args.containsKey("stopEventProcessing")) {
                    return;
                }
            }
            if (!flag && this.instanceCheck != null) {
                if (this.instanceCheckClass == null) {
                    try {
                        this.instanceCheckClass = Class.forName(this.instanceCheck);
                    }
                    catch (ClassNotFoundException e) {
                        ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find class type, disabling object accessor: " + this.instanceCheck);
                        e.printStackTrace();
                        this.catastrophicFailure = true;
                        return;
                    }
                }
                boolean bl2 = flag = !this.instanceCheckClass.isInstance(nextObj);
            }
            if (!flag && this.argName != null) {
                args.put(Event.replaceStringWithVariables(this.argName, args), nextObj);
            }
            if (this.postAccessorEvent != null) {
                EventHandler.tryEvents(new Event[]{this.postAccessorEvent}, args);
                if (args.containsKey("stopEventProcessing")) {
                    return;
                }
            }
            if (!flag && this.nextAccessors != null) {
                for (ObjectAccessor accessor : this.nextAccessors) {
                    accessor.process(nextObj, args);
                }
            }
        }
    }

    @Nullable
    private static Constructor findConstructor(Class clz, Class ... params) {
        try {
            Constructor c = clz.getDeclaredConstructor(params);
            c.setAccessible(true);
            return c;
        }
        catch (NoSuchMethodException e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find constructor for: " + clz.getName());
            e.printStackTrace();
        }
        catch (Exception e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Exception when trying to find constructor for: " + clz.getName());
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static Method findMethod(Class clz, String method, Class ... params) {
        try {
            String renamedMethod = ContentCreatorIntegration.modProxy.getRenamedMethod(method);
            Method m = clz.getDeclaredMethod(renamedMethod, params);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            if (clz != Object.class) {
                return ObjectAccessor.findMethod(clz.getSuperclass(), method, params);
            }
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find method: " + method);
        }
        catch (Exception e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Exception when trying to call method: " + method);
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static Field findField(Class clz, String field) {
        try {
            String renamedField = ContentCreatorIntegration.modProxy.getRenamedMethod(field);
            Field f = clz.getDeclaredField(renamedField);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            if (clz != Object.class) {
                return ObjectAccessor.findField(clz.getSuperclass(), field);
            }
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find field: " + field);
        }
        catch (Exception e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Exception when trying to access field: " + field);
            e.printStackTrace();
        }
        return null;
    }
}

