/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.streamelements.websocket;

import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.cci.common.thread.ThreadWebSocket;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshake;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ThreadStreamElementsWebsocketSocket
extends ThreadWebSocket {
    public ThreadStreamElementsWebsocketSocket(Logger logger, String socketToken, int id) {
        super(logger, socketToken, id);
    }

    @Override
    public String getSocketType() {
        return "StreamElementsWebsocket";
    }

    @Override
    public String getSocketUrl() {
        return "wss://astro.streamelements.com";
    }

    public void subscribeToEvents() {
        this.subscribeToEvent("channel.activities");
        this.subscribeToEvent("channel.tips");
    }

    public void subscribeToEvent(String topic) {
        try {
            JSONObject json = new JSONObject();
            json.put("type", "subscribe");
            json.put("nonce", "TotallyRandomListenRequestNonce");
            JSONObject data = new JSONObject();
            data.put("topic", topic);
            data.put("token", this.getSocketToken());
            data.put("token_type", "jwt");
            json.put("data", data);
            this.socket.send(json.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ThreadWebSocket.WebSocket createWebSocket() throws URISyntaxException {
        return new ThreadWebSocket.WebSocket(this, new URI(this.getSocketUrl()), this.getLogger(), this.getSocketType(), this.getSocketId()){

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                super.onOpen(handshakedata);
                ThreadStreamElementsWebsocketSocket.this.subscribeToEvents();
            }

            @Override
            public void onMessage(String message) {
                try {
                    JSONObject json = new JSONObject(message.trim());
                    String type = json.getString("type");
                    if (json.has("error")) {
                        this.getLogger().error(LogType.SOCKET_EVENT, "SEWS error:" + json.toString());
                    } else if (type.equals("response")) {
                        this.getLogger().info(LogType.SOCKET_EVENT, "SEWS response:" + json.toString());
                    } else if (type.equals("message")) {
                        this.getLogger().info(LogType.SOCKET_EVENT, "SEWS message:" + json.toString());
                        GenericEvent genericEvent = ThreadStreamElementsWebsocketSocket.this.parseEvent(json.getString("topic"), json.getJSONObject("data").getJSONObject("data"));
                        if (genericEvent != null) {
                            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(genericEvent));
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                this.getLogger().error(LogType.SOCKET_STATUS, "Disconnected from " + this.getSocketType() + " - " + this.getSocketId() + ": " + code + " ; " + reason + " ; " + remote);
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disconnected"));
                class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "disconnected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                    {
                        this.put("cci-type-configId", this.getSocketId());
                    }
                })));
                if (!this.killed && this.canReconnect()) {
                    ++this.reconnectAttempt;
                    this.close();
                    SocketHandler.sockets.remove(ThreadStreamElementsWebsocketSocket.this);
                    ThreadWebSocket socket2 = ThreadStreamElementsWebsocketSocket.this.copy();
                    SocketHandler.sockets.add(socket2);
                    socket2.setReconnectAttempt(this.reconnectAttempt);
                    socket2.start();
                }
            }
        };
    }

    public GenericEvent parseEvent(String eventType, JSONObject data) {
        String platform = eventType;
        String type = eventType;
        String id = String.valueOf(data.toString().hashCode());
        if (eventType.equals("channel.activities")) {
            try {
                platform = data.getString("provider");
                type = data.getString("type");
                id = data.getString("_id");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        HashMap args = (HashMap)EventConfiguration.GSON.fromJson(data.toString(), new TypeToken<HashMap<String, Object>>(this){}.getType());
        EventHandler.sortArgs(args);
        args.put("cci-type-configId", this.getSocketId());
        args.put("cci-type-for", platform);
        args.put("cci-type-event", type);
        return new GenericEvent(this.getSocketType().toLowerCase(Locale.ROOT), platform, type, id, args);
    }

    @Override
    public ThreadWebSocket copy() {
        return new ThreadStreamElementsWebsocketSocket(this.getLogger(), this.getSocketToken(), this.getSocketId());
    }
}

