/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.twitch.eventsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubscriptionType
implements Comparable<SubscriptionType> {
    public final String name;
    public final ArrayList<Version> versions = new ArrayList();
    public final ArrayList<String> requiredConditions = new ArrayList();
    public final ArrayList<String> optionalConditions = new ArrayList();
    private boolean unsupported = false;

    public SubscriptionType(String name) {
        this.name = name;
        this.versions.add(new Version(1, new Scope[0]));
    }

    public SubscriptionType(String name, int version) {
        this.name = name;
        this.versions.add(new Version(version, new Scope[0]));
    }

    public SubscriptionType(String name, String requiredScope) {
        this.name = name;
        this.versions.add(new Version(1, new Scope(requiredScope)));
    }

    public SubscriptionType(String name, Scope ... scopes) {
        this.name = name;
        this.versions.add(new Version(1, scopes));
    }

    public SubscriptionType(String name, int version, String requiredScope) {
        this.name = name;
        this.versions.add(new Version(version, new Scope(requiredScope)));
    }

    public SubscriptionType(String name, int version, Scope ... scopes) {
        this.name = name;
        this.versions.add(new Version(version, scopes));
    }

    public SubscriptionType addVersion(int version, String requiredScope) {
        this.versions.add(new Version(version, new Scope(requiredScope)));
        return this;
    }

    public SubscriptionType addVersion(int version, Scope ... scopes) {
        this.versions.add(new Version(version, scopes));
        return this;
    }

    public SubscriptionType setRequiredConditions(String ... conditions) {
        this.requiredConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public SubscriptionType setOptionalConditions(String ... conditions) {
        this.optionalConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    @Override
    public int compareTo(@NotNull SubscriptionType o) {
        return this.name.compareTo(o.name);
    }

    public SubscriptionType setNotSupported() {
        this.unsupported = true;
        return this;
    }

    public SubscriptionType webhookOnly() {
        this.unsupported = true;
        return this;
    }

    public SubscriptionType doNotSubscribe() {
        this.unsupported = true;
        return this;
    }

    public boolean isSupported() {
        return !this.unsupported;
    }

    @Nullable
    public Version getVersionWithinScope(HashSet<String> availableScopes) {
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            Version version = this.versions.get(i);
            if (!version.hasScopes(availableScopes)) continue;
            return version;
        }
        return null;
    }

    public static class Version {
        public final int version;
        public final ArrayList<Scope> requiredScopes = new ArrayList();

        public Version(int version, Scope ... scopes) {
            this.version = version;
            this.requiredScopes.addAll(Arrays.asList(scopes));
        }

        public String getVersion() {
            if (this.version == -1) {
                return "beta";
            }
            return Integer.toString(this.version);
        }

        public boolean hasScopes(HashSet<String> availableScopes) {
            for (Scope scope : this.requiredScopes) {
                boolean has = false;
                for (String scopeName : scope.scopes) {
                    if (!availableScopes.contains(scopeName)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                return false;
            }
            return true;
        }
    }

    public static class Scope {
        public ArrayList<String> scopes = new ArrayList();

        public Scope(String ... scopes) {
            this.scopes.addAll(Arrays.asList(scopes));
        }
    }
}

