/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.twitch.eventsub;

import java.util.List;
import java.util.Optional;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.api.socket.SocketProvider;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.module.twitch.eventsub.ThreadTwitchEventSubSocket;
import org.jetbrains.annotations.NotNull;

public class TwitchEventSubSocketProvider
extends SocketProvider {
    @Override
    public Optional<List<String>> getConfigTokens() {
        return Optional.of(ContentCreatorIntegration.configClient.eventsubOauthTokens);
    }

    @Override
    @NotNull
    public String type() {
        return "twitcheventsub";
    }

    @Override
    @NotNull
    public String name() {
        return "Twitch EventSub";
    }

    @Override
    @NotNull
    public String tokenInstructions() {
        return "cci.config.twitch.eventsub.twitchOauthTokens";
    }

    @Override
    @NotNull
    public ISocket provideSocket(int id) {
        ThreadTwitchEventSubSocket t = new ThreadTwitchEventSubSocket(ContentCreatorIntegration.logger, "wss://eventsub.wss.twitch.tv/ws", id < ContentCreatorIntegration.configClient.eventsubClientIDs.size() ? ContentCreatorIntegration.configClient.eventsubClientIDs.get(id) : "", this.getConfigTokens().get().get(id).trim(), id + 1);
        t.start();
        return t;
    }

    @Override
    public boolean isOurs(ISocket socket) {
        return socket instanceof ThreadTwitchEventSubSocket;
    }
}

