/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.thread;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.api.socket.SocketProvider;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.donationalerts.DonationAlertsSocketProvider;
import me.ichun.mods.cci.common.module.streamelements.StreamElementsSocketProvider;
import me.ichun.mods.cci.common.module.streamlabs.StreamlabsSocketProvider;
import me.ichun.mods.cci.common.module.twitch.chat.TwitchChatSocketProvider;
import me.ichun.mods.cci.common.module.twitch.eventsub.TwitchEventSubSocketProvider;
import me.ichun.mods.cci.common.module.twitch.pubsub.TwitchPubSubSocketProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SocketHandler {
    public static final TreeSet<SocketProvider> SOCKET_PROVIDERS = new TreeSet<SocketProvider>(){
        {
            this.add(new StreamlabsSocketProvider());
            this.add(new StreamElementsSocketProvider());
            this.add(new DonationAlertsSocketProvider());
            this.add(new TwitchChatSocketProvider());
            this.add(new TwitchPubSubSocketProvider());
            this.add(new TwitchEventSubSocketProvider());
        }
    };
    public static boolean initialisedSockets = false;
    public static HashSet<ISocket> sockets = new HashSet();

    public static boolean initialiseSockets(String type, int id) {
        boolean flag = false;
        if (type != null) {
            SocketHandler.killSockets(type, id);
            for (SocketProvider socketProvider : SOCKET_PROVIDERS) {
                if (!type.equals(socketProvider.type())) continue;
                socketProvider.init(sockets, id);
                flag = true;
            }
        } else if (!initialisedSockets) {
            SocketHandler.killSockets(null, id);
            initialisedSockets = true;
            boolean hasSocket = false;
            for (SocketProvider socketProvider : SOCKET_PROVIDERS) {
                if (socketProvider.getConfigTokens().get().size() <= 0) continue;
                hasSocket = true;
                break;
            }
            if (!hasSocket) {
                ContentCreatorIntegration.logger.error(LogType.CCI, "No socket tokens or chat channels found. Cannot initialise.");
                return false;
            }
            for (SocketProvider socketProvider : SOCKET_PROVIDERS) {
                socketProvider.init(sockets, id);
            }
            flag = true;
        }
        return flag;
    }

    public static boolean killSockets(String type, int id) {
        boolean flag = false;
        if (type != null) {
            Iterator<ISocket> ite = sockets.iterator();
            block0: while (ite.hasNext()) {
                ISocket socket = ite.next();
                for (SocketProvider socketProvider : SOCKET_PROVIDERS) {
                    if (!type.equals(socketProvider.type()) || !socketProvider.isOurs(socket) || id != -1 && socket.getSocketId() != id) continue;
                    socket.killSocket();
                    ite.remove();
                    flag = true;
                    continue block0;
                }
            }
        } else {
            for (ISocket socket : sockets) {
                socket.killSocket();
                flag = true;
            }
            sockets.clear();
            initialisedSockets = false;
        }
        return flag;
    }
}

