/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.thread;

import java.net.URISyntaxException;
import java.util.HashMap;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.shadow.io.socket.client.IO;
import me.ichun.shadow.io.socket.client.Socket;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public abstract class ThreadSocket
extends Thread
implements ISocket {
    private final Logger logger;
    private final String socketToken;
    private final int socketId;
    private int reconnectAttempt = 0;
    protected Socket socket = null;

    public ThreadSocket(Logger logger, String socketToken, int id) {
        this.setName("CCI - " + this.getSocketType() + " Integration");
        this.setDaemon(true);
        this.logger = logger;
        this.socketToken = socketToken;
        this.socketId = id;
    }

    @Override
    public void run() {
        try {
            if (!EventConfiguration.eventConfigurations.containsKey(this.getSocketType().toLowerCase())) {
                EventConfiguration.readConfigurationFile(this.getSocketType().toLowerCase());
            }
            this.socket = this.createSocket();
            this.socket.connect();
        }
        catch (Exception e) {
            this.logger.error(LogType.SOCKET_STATUS, "We've encountered an error creating a socket for " + this.getSocketType() + ". Uh oh!");
            e.printStackTrace();
        }
    }

    @Override
    public void killSocket() {
        if (this.socket != null) {
            this.socket.disconnect();
            this.socket = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.socket != null && this.socket.connected();
    }

    protected void resetReconnects() {
        this.reconnectAttempt = 0;
    }

    protected boolean canReconnect() {
        ++this.reconnectAttempt;
        return this.reconnectAttempt <= ContentCreatorIntegration.configClient.maxAutomaticReconnects;
    }

    @Override
    public int getSocketId() {
        return this.socketId;
    }

    protected String getSocketToken() {
        return this.socketToken;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Socket getDefaultSocket() throws URISyntaxException {
        Socket socket = IO.socket(this.getSocketUrl(), this.getOptions());
        socket.on("connecting", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Connecting to " + this.getSocketType() + " - " + this.getSocketId());
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.connecting"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connecting", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("error", args -> {
            this.getLogger().error(LogType.SOCKET_STATUS, "Failed to connect to " + this.getSocketType() + " - " + this.getSocketId());
            for (Object arg : args) {
                this.getLogger().error(LogType.SOCKET_STATUS, "---" + String.valueOf(arg));
                if (!(arg instanceof Exception)) continue;
                ((Exception)arg).printStackTrace();
            }
            socket.disconnect();
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.failed"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connectError", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("connect_error", args -> {
            this.getLogger().error(LogType.SOCKET_STATUS, "Failed to connect to " + this.getSocketType() + " - " + this.getSocketId());
            for (Object arg : args) {
                this.getLogger().error(LogType.SOCKET_STATUS, "---" + String.valueOf(arg));
                if (!(arg instanceof Exception)) continue;
                ((Exception)arg).printStackTrace();
            }
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.failed"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connectError", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("connect", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Connected to " + this.getSocketType() + " - " + this.getSocketId());
            this.resetReconnects();
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.connected"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "connected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("authenticated", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Authenticated with " + this.getSocketType() + " - " + this.getSocketId());
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.authenticated"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "authenticated", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("disconnect", args -> {
            this.getLogger().error(LogType.SOCKET_STATUS, "Disconnected from " + this.getSocketType() + " - " + this.getSocketId());
            for (Object arg : args) {
                this.getLogger().error(LogType.SOCKET_STATUS, "---" + String.valueOf(arg));
                if (!(arg instanceof Exception)) continue;
                ((Exception)arg).printStackTrace();
            }
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disconnected"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "disconnected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        }).on("reconnecting", args -> {
            if (this.canReconnect()) {
                this.getLogger().info(LogType.SOCKET_STATUS, "Reconnecting to " + this.getSocketType() + " - " + this.getSocketId());
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.reconnecting"));
                class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "reconnecting", "connected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                    {
                        this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                    }
                })));
            } else {
                this.getLogger().error(LogType.SOCKET_STATUS, "Failed to reconnect to " + this.getSocketType() + " - " + this.getSocketId() + " after " + (this.reconnectAttempt - 1) + " tries. Will stop attempting to reconnect.");
                socket.disconnect();
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disablingReconnects"));
            }
        }).on("reconnect_failed", args -> {
            this.getLogger().info(LogType.SOCKET_STATUS, "Failed to reconnect to " + this.getSocketType() + " - " + this.getSocketId());
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.failedReconnect"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "reconnectFailed", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", ThreadSocket.this.getSocketId());
                }
            })));
        });
        return socket;
    }

    protected IO.Options getOptions() {
        return null;
    }

    public abstract String getSocketUrl();

    public abstract Socket createSocket() throws URISyntaxException;
}

