/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.thread;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import me.ichun.mods.cci.api.socket.ISocket;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.shadow.org.java_websocket.client.WebSocketClient;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshake;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public abstract class ThreadWebSocket
extends Thread
implements ISocket {
    private final Logger logger;
    private final String socketToken;
    private final int socketId;
    protected WebSocket socket;
    protected int reconnectAttempt;

    public ThreadWebSocket(Logger logger, String socketToken, int id) {
        this.setName("CCI - " + this.getSocketType() + " Integration");
        this.setDaemon(true);
        this.logger = logger;
        this.socketToken = socketToken;
        this.socketId = id;
    }

    public void setReconnectAttempt(int i) {
        this.reconnectAttempt = i;
    }

    @Override
    public void run() {
        try {
            if (!EventConfiguration.eventConfigurations.containsKey(this.getSocketType().toLowerCase())) {
                EventConfiguration.readConfigurationFile(this.getSocketType().toLowerCase());
            }
            this.getLogger().info(LogType.SOCKET_STATUS, "Connecting to " + this.getSocketType() + " - " + this.getSocketId());
            this.socket = this.createWebSocket();
            this.socket.reconnectAttempt = this.reconnectAttempt;
            this.socket.connect();
        }
        catch (Exception e) {
            this.logger.error(LogType.SOCKET_STATUS, "We've encountered an error creating a socket for " + this.getSocketType() + " - " + this.getSocketId() + ". Uh oh!");
            e.printStackTrace();
        }
    }

    @Override
    public void killSocket() {
        if (this.socket != null) {
            this.socket.killed = true;
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.socket != null && this.socket.isOpen();
    }

    @Override
    public int getSocketId() {
        return this.socketId;
    }

    protected String getSocketToken() {
        return this.socketToken;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected WebSocket getDefaultWebSocket() throws URISyntaxException {
        return new WebSocket(this, new URI(this.getSocketUrl()), this.getLogger(), this.getSocketType(), this.getSocketId());
    }

    public abstract String getSocketUrl();

    public abstract WebSocket createWebSocket() throws URISyntaxException;

    public abstract ThreadWebSocket copy();

    public static class WebSocket
    extends WebSocketClient {
        private final ThreadWebSocket initialiser;
        private final Logger logger;
        private final String socketType;
        private final int socketId;
        public int reconnectAttempt = 0;
        public boolean killed = false;

        public WebSocket(ThreadWebSocket init, URI serverUri, Logger logger, String socketType, int socketId) {
            super(serverUri);
            this.initialiser = init;
            this.logger = logger;
            this.socketType = socketType;
            this.socketId = socketId;
        }

        @Override
        public void onOpen(ServerHandshake handshakedata) {
            this.getLogger().info(LogType.SOCKET_STATUS, "Connected to " + this.getSocketType() + " - " + this.getSocketId());
            this.resetReconnects();
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.connected"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent("chat", this.getSocketType().toLowerCase() + "connection", "connected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", this.getSocketId());
                }
            })));
        }

        @Override
        public void onMessage(String message) {
            this.getLogger().info(LogType.SOCKET_EVENT, message);
        }

        @Override
        public void onMessage(ByteBuffer bytes) {
            this.getLogger().info(LogType.SOCKET_EVENT, "DASKLHJ WHY WOULD WE RECEIVE BYTES?");
            this.getLogger().info(LogType.SOCKET_EVENT, bytes);
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            this.getLogger().error(LogType.SOCKET_STATUS, "Disconnected from " + this.getSocketType() + " - " + this.getSocketId() + ": " + code + " ; " + reason + " ; " + remote);
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disconnected"));
            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent("chat", this.getSocketType().toLowerCase() + "connection", "disconnected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                {
                    this.put("cci-type-configId", this.getSocketId());
                }
            })));
            if (!this.killed && this.canReconnect()) {
                ++this.reconnectAttempt;
                this.close();
                SocketHandler.sockets.remove(this.initialiser);
                ThreadWebSocket socket2 = this.initialiser.copy();
                SocketHandler.sockets.add(socket2);
                socket2.setReconnectAttempt(this.reconnectAttempt);
                socket2.start();
            }
        }

        @Override
        public void onError(Exception ex) {
            this.getLogger().error(LogType.SOCKET_STATUS, "An error occurred with " + this.getSocketType());
            ex.printStackTrace();
        }

        protected void resetReconnects() {
            this.reconnectAttempt = 0;
        }

        protected boolean canReconnect() {
            ++this.reconnectAttempt;
            return this.reconnectAttempt <= ContentCreatorIntegration.configClient.maxAutomaticReconnects;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public String getSocketType() {
            return this.socketType;
        }

        public int getSocketId() {
            return this.socketId;
        }
    }
}

