/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.client.gui.cci.window;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.cci.api.socket.SocketProvider;
import me.ichun.mods.cci.client.core.EventHandlerClient;
import me.ichun.mods.cci.client.event.Toast;
import me.ichun.mods.cci.client.gui.cci.WorkspaceConfigs;
import me.ichun.mods.cci.client.gui.cci.window.popup.WindowConnections;
import me.ichun.mods.cci.client.gui.cci.window.popup.WindowEditString;
import me.ichun.mods.cci.client.gui.cci.window.popup.WindowEventsViewer;
import me.ichun.mods.cci.client.gui.cci.window.popup.WindowHelp;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewPopup;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class WindowToolbar
extends Window<WorkspaceConfigs, ViewToolbar> {
    public WindowToolbar(WorkspaceConfigs parent) {
        super((Workspace)parent);
        this.setView(new ViewToolbar(this));
        this.size(200, 20 + (Integer)this.borderSize.get() * 2);
        this.disableDockingEntirely();
        this.disableBringToFront();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
    }

    public static class ViewToolbar
    extends View<WindowToolbar> {
        public ElementTextWrapper clipboardText;
        public int textTimeout;
        public ArrayList<String> profileNames = new ArrayList();
        public ElementToggleTextable<?> serverIndicator;

        public ViewToolbar(@NotNull WindowToolbar parent) {
            super((Window)parent, "");
            int padding = 3;
            this.populateProfileNames();
            int buttonWidth = 80;
            ElementDropdownContextMenu profileSetter = new ElementDropdownContextMenu((Fragment)this, ContentCreatorIntegration.cciProfileDir.getFileName().toString(), this.profileNames, (menu, item) -> {
                if (item.selected) {
                    ElementDropdownContextMenu contextMenu = (ElementDropdownContextMenu)menu;
                    contextMenu.text = item.getObject().toString().trim();
                    this.changeProfile(contextMenu.text);
                }
            });
            profileSetter.setSize(buttonWidth, 20);
            profileSetter.setConstraint(new Constraint((Constrainable)profileSetter).left((Rectangle)this, Constraint.Property.Type.LEFT, padding).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(profileSetter);
            ElementButton newProfile = (ElementButton)new ElementButton((Fragment)this, "+", btn -> {
                if (class_437.method_25442()) {
                    class_156.method_668().method_672(ContentCreatorIntegration.cciProfileDir.toFile());
                } else if (class_437.method_25441()) {
                    this.getWorkspace().openWindowInCenter((Window)new WindowEditString(parent.parent, ContentCreatorIntegration.cciProfileDir.getFileName().toString(), text -> {
                        String newProf = text;
                        for (char c0 : class_155.field_1126) {
                            newProf = newProf.replace(c0, '_');
                        }
                        if ((newProf = newProf.replaceAll("[./\"]", "_")).length() > 255) {
                            newProf = newProf.substring(0, 255);
                        }
                        try {
                            Files.move(ContentCreatorIntegration.cciProfileDir, ContentCreatorIntegration.cciProfileDir.getParent().resolve(newProf), new CopyOption[0]);
                            this.changeProfile(newProf);
                            profileSetter.text = newProf;
                        }
                        catch (IOException e) {
                            ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.3, (double)0.3, w -> {}, (String[])new String[]{class_1074.method_4662((String)"cci.command.profile.errorChangingProfile", (Object[])new Object[]{text})});
                            e.printStackTrace();
                        }
                    }), 0.8, 100.0, true);
                } else {
                    this.getWorkspace().openWindowInCenter((Window)new WindowEditString(parent.parent, "NewProfile", text -> {
                        String newProf = text;
                        for (char c0 : class_155.field_1126) {
                            newProf = newProf.replace(c0, '_');
                        }
                        if ((newProf = newProf.replaceAll("[./\"]", "_")).length() > 255) {
                            newProf = newProf.substring(0, 255);
                        }
                        this.changeProfile(newProf);
                        profileSetter.text = newProf;
                    }), 0.8, 100.0, true);
                }
            }).setSize(14, 14);
            newProfile.setTooltip(class_1074.method_4662((String)"cci.gui.toolbar.newProfile", (Object[])new Object[0]));
            newProfile.setConstraint(new Constraint((Constrainable)newProfile).left((Rectangle)profileSetter, Constraint.Property.Type.RIGHT, padding).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(newProfile);
            ElementButton events = (ElementButton)new ElementButton((Fragment)this, "cci.gui.toolbar.events", btn -> this.getWorkspace().openWindowInCenter((Window)new WindowEventsViewer((WorkspaceConfigs)parent.parent), 0.6, 0.9, true)).setSize(buttonWidth, 20);
            events.setTooltip(class_1074.method_4662((String)"cci.gui.toolbar.eventViewer", (Object[])new Object[0]));
            events.setConstraint(new Constraint((Constrainable)events).left((Rectangle)newProfile, Constraint.Property.Type.RIGHT, 16).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(events);
            ElementButton connections = new ElementButton((Fragment)this, "cci.gui.toolbar.connections", btn -> {
                boolean hasSocket = false;
                for (SocketProvider socketProvider : SocketHandler.SOCKET_PROVIDERS) {
                    if (socketProvider.getConfigTokens().get().size() <= 0) continue;
                    hasSocket = true;
                    break;
                }
                if (SocketHandler.sockets.isEmpty() && !hasSocket) {
                    ViewPopup.popup((Workspace)((WorkspaceConfigs)parent.parent), (double)0.3, (double)110.0, w -> {}, (String[])new String[]{class_1074.method_4662((String)"cci.command.nosockets", (Object[])new Object[0])});
                } else {
                    WindowConnections window = new WindowConnections((WorkspaceConfigs)parent.parent);
                    this.getWorkspace().openWindowInCenter((Window)window, 0.4, 0.5, true);
                    window.init();
                }
            });
            connections.setSize(buttonWidth, 20);
            connections.setConstraint(new Constraint((Constrainable)connections).left((Rectangle)events, Constraint.Property.Type.RIGHT, 15).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(connections);
            this.clipboardText = new ElementTextWrapper((Fragment)this);
            this.clipboardText.setText(" ").setWidth(100);
            this.clipboardText.setConstraint(new Constraint((Constrainable)this.clipboardText).left((Rectangle)connections, Constraint.Property.Type.RIGHT, 8));
            this.elements.add(this.clipboardText);
            ElementButton exitButton = (ElementButton)new ElementButton((Fragment)this, "cci.gui.toolbar.exit", btn -> {
                if (class_437.method_25442()) {
                    if (this.save()) {
                        ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast((class_2561)class_2561.method_43471((String)"cci.gui.toolbar.saveApplied"), -256, null, -1, 0));
                        ((WorkspaceConfigs)parent.parent).method_25419();
                    } else {
                        ViewPopup.popup((Workspace)((WorkspaceConfigs)parent.parent), (double)0.3, (double)110.0, w -> {}, (String[])new String[]{class_1074.method_4662((String)"cci.gui.toolbar.saveError", (Object[])new Object[0])});
                    }
                } else {
                    ((WorkspaceConfigs)parent.parent).method_25419();
                }
            }).setSize(buttonWidth, 20);
            exitButton.setTooltip(class_1074.method_4662((String)"cci.gui.toolbar.shiftSave", (Object[])new Object[0]));
            exitButton.setConstraint(new Constraint((Constrainable)exitButton).right((Rectangle)this, Constraint.Property.Type.RIGHT, padding).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(exitButton);
            ElementButton saveButton = (ElementButton)new ElementButton((Fragment)this, "cci.gui.toolbar.save", btn -> {
                if (!this.save()) {
                    ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.3, (double)110.0, w -> {}, (String[])new String[]{class_1074.method_4662((String)"cci.gui.toolbar.saveError", (Object[])new Object[0])});
                }
            }).setSize(buttonWidth, 20);
            saveButton.setTooltip(class_1074.method_4662((String)"cci.gui.button.save", (Object[])new Object[0]));
            saveButton.setConstraint(new Constraint((Constrainable)saveButton).right((Rectangle)exitButton, Constraint.Property.Type.LEFT, 15).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(saveButton);
            ElementButton reload = (ElementButton)new ElementButton((Fragment)this, "cci.gui.toolbar.reload", btn -> this.reloadConfigs()).setSize(buttonWidth, 20);
            reload.setTooltip(class_1074.method_4662((String)"cci.gui.button.reloadConfigurations", (Object[])new Object[0]));
            reload.setConstraint(new Constraint((Constrainable)reload).right((Rectangle)saveButton, Constraint.Property.Type.LEFT, 15).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(reload);
            ElementButton helpButton = new ElementButton((Fragment)this, "cci.gui.toolbar.help", btn -> this.getWorkspace().openWindowInCenter((Window)new WindowHelp((WorkspaceConfigs)parent.parent), 0.6, 0.8, true));
            helpButton.setSize(buttonWidth, 20);
            helpButton.setConstraint(new Constraint((Constrainable)helpButton).right((Rectangle)reload, Constraint.Property.Type.LEFT, 15).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding));
            this.elements.add(helpButton);
            this.serverIndicator = new ElementToggleTextable((Fragment)this, class_1074.method_4662((String)"cci.gui.toolbar.server.tooltip", (Object[])new Object[0]), class_1074.method_4662((String)"cci.gui.toolbar.server", (Object[])new Object[]{class_1074.method_4662((String)"gui.no", (Object[])new Object[0])}), class_1074.method_4662((String)"cci.gui.toolbar.server", (Object[])new Object[]{class_1074.method_4662((String)"gui.yes", (Object[])new Object[0])}), btn -> {
                btn.toggleState = !btn.toggleState;
                btn.text = btn.toggleState ? btn.onString : btn.offString;
            });
            this.serverIndicator.setSize(buttonWidth, 20);
            this.serverIndicator.constraints().right((Rectangle)helpButton, Constraint.Property.Type.LEFT, 15).top((Rectangle)this, Constraint.Property.Type.TOP, padding).bottom((Rectangle)this, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(this.serverIndicator);
        }

        public void populateProfileNames() {
            File[] files;
            this.profileNames.clear();
            File workingDir = ContentCreatorIntegration.cciProfileDir.getParent().toFile();
            for (File file : files = workingDir.listFiles()) {
                if (!file.isDirectory() || file.getName().equals("logs") || file.getName().equals("libs")) continue;
                this.profileNames.add(file.getName());
            }
        }

        public void tick() {
            super.tick();
            if (this.textTimeout > 0) {
                --this.textTimeout;
                if (this.textTimeout == 0) {
                    this.clipboardText.setText(" ");
                    this.clipboardText.init();
                }
            }
            this.serverIndicator.toggleState = Outcome.canDoServerOutcomes();
            this.serverIndicator.text = this.serverIndicator.toggleState ? this.serverIndicator.onString : this.serverIndicator.offString;
        }

        private void changeProfile(String text) {
            if (ContentCreatorIntegration.setProfile(text)) {
                EventHandler.readNotes();
                EventHandler.readStatistics();
                EventConfiguration.reloadAllConfigurations();
                ContentCreatorIntegration.configClient.defaultProfile = text;
                ContentCreatorIntegration.configClient.save();
                this.populateProfileNames();
                this.reloadGui();
                ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast((class_2561)class_2561.method_43471((String)"cci.command.profile.profileChanged"), -256, null, -1, 0));
            } else {
                ViewPopup.popup((Workspace)this.getWorkspace(), (double)0.3, (double)0.3, w -> {}, (String[])new String[]{class_1074.method_4662((String)"cci.command.profile.errorChangingProfile", (Object[])new Object[]{text})});
            }
        }

        public void reloadConfigs() {
            EventHandler.readNotes();
            EventHandler.readStatistics();
            EventConfiguration.reloadAllConfigurations();
            this.reloadGui();
            ContentCreatorIntegration.eventHandlerClient.addOrQueueToast(new Toast((class_2561)class_2561.method_43471((String)"cci.gui.toolbar.reloaded"), -256, null, -1, 0));
        }

        public boolean save() {
            String json;
            File file;
            boolean flag = true;
            TreeMap<String, EventConfiguration> old = EventConfiguration.eventConfigurations;
            EventConfiguration.eventConfigurations = ((WorkspaceConfigs)((WindowToolbar)this.parent).parent).eventConfigurations;
            for (Map.Entry<String, EventConfiguration> entry : EventConfiguration.eventConfigurations.entrySet()) {
                if (entry.getKey().equals("constants")) {
                    file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "constants.json");
                    try {
                        json = EventConfiguration.GSON.toJson((Object)((WorkspaceConfigs)((WindowToolbar)this.parent).parent).constants.constants);
                        if (EventConfiguration.GSON.toJson((Object)EventHandler.constants).equals(json)) continue;
                        FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
                        ContentCreatorIntegration.logger.info(LogType.CCI, "Wrote file: " + file.getName());
                    }
                    catch (IOException e1) {
                        flag = false;
                        ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing constants file: " + file.getName());
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (entry.getKey().equals("minecraft")) {
                    file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), "gamehooks.json");
                    try {
                        json = EventConfiguration.GSON.toJson((Object)((WorkspaceConfigs)((WindowToolbar)this.parent).parent).gameEventConfig.config);
                        if (EventConfiguration.GSON.toJson((Object)EventHandler.gameEventConfig).equals(json)) continue;
                        FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
                        ContentCreatorIntegration.logger.info(LogType.CCI, "Wrote file: " + file.getName());
                    }
                    catch (IOException e1) {
                        flag = false;
                        ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing MC hooks file: " + file.getName());
                        e1.printStackTrace();
                    }
                    continue;
                }
                file = new File(ContentCreatorIntegration.cciProfileDir.toFile(), entry.getKey() + (entry.getValue().online ? "-online" : "") + ".json");
                try {
                    json = EventConfiguration.GSON.toJson((Object)entry.getValue());
                    if (old.containsKey(entry.getKey()) && EventConfiguration.GSON.toJson((Object)old.get(entry.getKey())).equals(json)) continue;
                    FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
                    ContentCreatorIntegration.logger.info(LogType.CCI, "Wrote file: " + file.getName());
                }
                catch (IOException e1) {
                    flag = false;
                    ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing configuration file: " + file.getName());
                    e1.printStackTrace();
                }
            }
            for (Map.Entry<String, Object> entry : EventHandler.libraries.entrySet()) {
                if (!((WorkspaceConfigs)((WindowToolbar)this.parent).parent).libraries.containsKey(entry.getKey())) continue;
                file = new File(ContentCreatorIntegration.cciLibsDir.toFile(), entry.getKey() + ".json");
                try {
                    json = EventConfiguration.GSON.toJson((Object)((WorkspaceConfigs)((WindowToolbar)this.parent).parent).libraries.get((Object)entry.getKey()).constants);
                    if (EventConfiguration.GSON.toJson(entry.getValue()).equals(json)) continue;
                    FileUtils.writeStringToFile((File)file, (String)json, (String)"UTF-8");
                    ContentCreatorIntegration.logger.info(LogType.CCI, "Wrote library file: " + file.getName());
                }
                catch (IOException e1) {
                    flag = false;
                    ContentCreatorIntegration.logger.error(LogType.CCI, "Error writing library constants file: " + file.getName());
                    e1.printStackTrace();
                }
            }
            EventConfiguration.reloadAllConfigurations();
            return flag;
        }

        public WorkspaceConfigs reloadGui() {
            WorkspaceConfigs screen;
            if (((WorkspaceConfigs)((WindowToolbar)this.parent).parent).oriScale != (Integer)class_310.method_1551().field_1690.method_42474().method_41753()) {
                class_310.method_1551().field_1690.method_42474().method_41748((Object)((WorkspaceConfigs)((WindowToolbar)this.parent).parent).oriScale);
            }
            if ((screen = EventHandlerClient.getGuiInstance(class_310.method_1551(), this.getWorkspace().lastScreen)) != ((WindowToolbar)this.parent).parent) {
                if (((WorkspaceConfigs)((WindowToolbar)this.parent).parent).oriScale != (Integer)class_310.method_1551().field_1690.method_42474().method_41753()) {
                    ((WorkspaceConfigs)((WindowToolbar)this.parent).parent).oriScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
                }
                class_310.method_1551().method_1507((class_437)screen);
            }
            return screen;
        }
    }
}

