/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config;

import java.util.HashMap;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.config.outcome.ChatMessageOutcome;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.config.outcome.ToastOutcome;

public class DefaultEventConfiguration {
    public static EventConfiguration getDefaults(String name) {
        EventConfiguration config = new EventConfiguration();
        config.type = name;
        switch (name) {
            case "streamlabs": {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration(), new EventConfiguration.Configuration()};
                config.configs[0]._for = "twitch_account";
                config.configs[0].queue = new String[]{"host+subscription+bits", "follow"};
                config.configs[1].ignoredTypes = new String[]{"streamlabels", "streamlabels.underlying"};
                Event event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                ChatMessageOutcome outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just sent you $amount bits!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("bits", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $name just gave out $amount subs!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("subMysteryGift", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just subscribed for $amount months!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("subscription", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just followed!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("follow", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just hosted you for up to $amount viewers!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("host", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just raided you with $amount raiders!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("raid", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just tipped $formatted_amount!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[1].types.put("donation", new Event[]{event});
                break;
            }
            case "streamelementswebsocket": 
            case "streamelements": {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration()};
                config.configs[0].queue = new String[]{"host+subscriber+cheer", "follow"};
                Event event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                ChatMessageOutcome outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just sent you $amount bits!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("cheer", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just dropped for $amount gift subs!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("communityGiftPurchase", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just subscribed for $amount months!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("subscriber", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just followed!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("follow", new Event[]{event});
                event = new Event();
                event.playTime = "20";
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just hosted you for up to $amount viewers!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("host", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just raided you with $amount raiders!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("raid", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $user just tipped $$amount!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("tip", new Event[]{event});
                break;
            }
            case "chat": {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration(), new EventConfiguration.Configuration()};
                config.configs[0]._for = "twitch";
                Event event = new Event();
                event.conditions = new Condition[0];
                ToastOutcome outcome = new ToastOutcome();
                outcome.title = "$user says:";
                outcome.subtitle = "$message";
                outcome.titleColor = "$color";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("message", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ToastOutcome();
                outcome.toastType = 2;
                outcome.title = "$user";
                outcome.subtitle = "$message";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("action", new Event[]{event});
                config.configs[1]._for = "youtube";
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ToastOutcome();
                outcome.title = "$authorDetails_displayName says:";
                outcome.subtitle = "$displayMessage";
                event.outcomes = new Outcome[]{outcome};
                config.configs[1].types.put("textMessageEvent", new Event[]{event});
                break;
            }
            case "donationalerts": {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration()};
                Event event = new Event();
                event.conditions = new Condition[0];
                ChatMessageOutcome outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, $username just tipped $amount!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0].types.put("donation", new Event[]{event});
                break;
            }
            case "twitchpubsub": {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration(), new EventConfiguration.Configuration(), new EventConfiguration.Configuration(), new EventConfiguration.Configuration(), new EventConfiguration.Configuration()};
                Event event = new Event();
                event.conditions = new Condition[0];
                ChatMessageOutcome outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, new prediction!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[0]._for = "predictions-channel-v1";
                config.configs[0].types.put("event-created", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, new poll!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[1]._for = "polls";
                config.configs[1].types.put("POLL_CREATE", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, poll ended!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[1].types.put("POLL_COMPLETE", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, channel point reward redeemed!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[2]._for = "community-points-channel-v1";
                config.configs[2].types.put("reward-redeemed", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Heads up $streamer, something happened in chat!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[3]._for = "chat_moderator_actions";
                config.configs[3].types.put("moderation_action", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hey $streamer, HYPE TRAIN!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[4]._for = "hype-train-events-v1";
                config.configs[4].types.put("hype-train-start", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Choo Chooo!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[4].types.put("hype-train-end", new Event[]{event});
                event = new Event();
                event.conditions = new Condition[0];
                outcome = new ChatMessageOutcome();
                outcome.message = "Hype train incoming!";
                event.outcomes = new Outcome[]{outcome};
                config.configs[4].types.put("hype-train-approaching", new Event[]{event});
                break;
            }
            case "twitcheventsub": {
                HashMap<String, String> subToMessage = new HashMap<String, String>();
                subToMessage.put("channel.ad_break.begin", "Hey $streamer, an ad break is starting!");
                subToMessage.put("channel.bits.use", "Hey $streamer, someone just used Bits on your channel!");
                subToMessage.put("channel.channel_points_automatic_reward_redemption.add", "Hey $streamer, someone just redeemed an automatic channel points reward!");
                subToMessage.put("channel.channel_points_custom_reward.add", "Hey $streamer, a new channel points reward was created!");
                subToMessage.put("channel.channel_points_custom_reward.remove", "Hey $streamer, a channel points reward has been removed!");
                subToMessage.put("channel.channel_points_custom_reward.update", "Hey $streamer, a channel points reward has been updated!");
                subToMessage.put("channel.channel_points_custom_reward_redemption.add", "Hey $streamer, someone just redeemed a channel points reward!");
                subToMessage.put("channel.channel_points_custom_reward_redemption.update", "Hey $streamer, a redeemed a channel points reward has just been updated!");
                subToMessage.put("channel.charity_campaign.donate", "Hey $streamer, someone just donated to your charity campaign!");
                subToMessage.put("channel.charity_campaign.progress", "Hey $streamer, your charity campaign is progressing!");
                subToMessage.put("channel.charity_campaign.start", "Hey $streamer, you've just started a charity campaign!");
                subToMessage.put("channel.charity_campaign.stop", "Hey $streamer, you've just stopped a charity campaign!");
                subToMessage.put("channel.chat.clear", "Hey $streamer, chat's been cleared!");
                subToMessage.put("channel.chat.clear_user_messages", "Hey $streamer, someone's messages have just been cleared!");
                subToMessage.put("channel.chat.message", "$chatter_user_name: $message_text");
                subToMessage.put("channel.chat.message_delete", "Hey $streamer, someone's chat message was just removed!");
                subToMessage.put("channel.chat.notification", "Hey $streamer, something's just happened in chat!");
                subToMessage.put("channel.chat.user_message_hold", "Hey $streamer, a message has been caught by AutoMod!");
                subToMessage.put("channel.chat.user_message_update", "Hey $streamer, a message caught by AutoMod's status has been updated!");
                subToMessage.put("channel.chat_settings.update", "Hey $streamer, your chat settings have been updated!");
                subToMessage.put("channel.cheer", "Hey $streamer, someone's cheered in your chat!");
                subToMessage.put("channel.goal.begin", "Hey $streamer, good luck with that new goal!");
                subToMessage.put("channel.goal.end", "Hey $streamer, you've just ended your goal, let's hope you've met it!");
                subToMessage.put("channel.goal.progress", "Hey $streamer, some progress made towards your goal!");
                subToMessage.put("channel.guest_star_guest.update", "Hey $streamer, there's been an update to your guest!");
                subToMessage.put("channel.guest_star_session.begin", "Hey $streamer, new Guest Star session, have fun!");
                subToMessage.put("channel.guest_star_session.end", "Hey $streamer, Guest Star session ended, hope you had fun!");
                subToMessage.put("channel.guest_star_settings.update", "Hey $streamer, Guest Star host preferences updated!");
                subToMessage.put("channel.hype_train.begin", "Hype train incoming!");
                subToMessage.put("channel.hype_train.end", "Choo Chooo!");
                subToMessage.put("channel.hype_train.progress", "Hype train progress made!");
                subToMessage.put("channel.poll.begin", "Hey $streamer, new poll!");
                subToMessage.put("channel.poll.end", "Hey $streamer, poll ended!");
                subToMessage.put("channel.poll.progress", "Hey $streamer, progress on the poll!");
                subToMessage.put("channel.prediction.begin", "Hey $streamer, new prediction!");
                subToMessage.put("channel.prediction.end", "Hey $streamer, prediction ended!");
                subToMessage.put("channel.prediction.lock", "Hey $streamer, prediction locked!");
                subToMessage.put("channel.prediction.progress", "Hey $streamer, someone's contributed to the prediction!");
                subToMessage.put("channel.raid.incoming", "Hey $streamer, you just got raided!");
                subToMessage.put("channel.raid.outgoing", "Hey $streamer, raiding out? Hope you had a good stream!");
                subToMessage.put("channel.shared_chat.begin", "Hey $streamer, sharing chats huh? Enjoy the collab!");
                subToMessage.put("channel.shared_chat.end", "Hey $streamer, shared chat ended!");
                subToMessage.put("channel.shared_chat.update", "Hey $streamer, an update to shared chat!");
                subToMessage.put("channel.subscribe", "Hey $streamer, new subscriber!");
                subToMessage.put("channel.subscription.end", "Hey $streamer, someone's subscription ended :(");
                subToMessage.put("channel.subscription.gift", "Hey $streamer, someone gave subs out!");
                subToMessage.put("channel.subscription.message", "Hey $streamer, resub message!");
                subToMessage.put("channel.update", "Hey $streamer, your channel's been updated!");
                subToMessage.put("stream.offline", "Hey $streamer, stream offline!");
                subToMessage.put("stream.online", "Hey $streamer, stream online!");
                HashMap forToConfig = new HashMap();
                subToMessage.forEach((key, value) -> {
                    String topic = key.substring(0, key.lastIndexOf("."));
                    String type = key.substring(key.lastIndexOf(".") + 1);
                    EventConfiguration.Configuration configConfig = forToConfig.computeIfAbsent(topic, k -> new EventConfiguration.Configuration());
                    configConfig._for = topic;
                    Event event = new Event();
                    event.conditions = new Condition[0];
                    ChatMessageOutcome outcome = new ChatMessageOutcome();
                    outcome.message = value;
                    event.outcomes = new Outcome[]{outcome};
                    configConfig.types.put(type, new Event[]{event});
                });
                config.configs = forToConfig.values().toArray(new EventConfiguration.Configuration[0]);
                break;
            }
            default: {
                config.configs = new EventConfiguration.Configuration[]{new EventConfiguration.Configuration()};
                config.configs[0]._for = "default";
                Event event = new Event();
                config.configs[0].types.put("unspecified", new Event[]{event});
                break;
            }
        }
        return config;
    }
}

