/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config;

import com.google.common.base.Splitter;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.ichunutil.client.entity.EntityHelperClient;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Event {
    public String name = null;
    public String constantName = null;
    public Boolean disabled = null;
    public Condition[] conditions = new Condition[0];
    public Outcome[] outcomes = new Outcome[0];
    public Boolean triggersFromAnyConditionMet = null;
    public Boolean allowsOtherEventsToTrigger = true;
    public Boolean singleOutcomeOnly = null;
    public String playTime = null;
    public Event playTimeEvent = null;
    public String delay = null;
    public String cooldown = null;
    public Boolean disableShortCircuitWhenOnCooldown = null;
    public static final Splitter VARIABLE_SPLITTER = Splitter.on((String)"$");
    public static final String DECIMAL_PRECISION = "%.2f";
    public static final int IDENTIFIER_LENGTH = 20;

    public Integer getPlayTime(HashMap<String, Object> args) {
        if (this.playTime != null) {
            String playtimeV = Event.replaceStringWithVariables(this.playTime, args);
            Double d = null;
            if (args.containsKey(playtimeV)) {
                if (args.get(playtimeV) instanceof Number) {
                    d = ((Number)args.get(playtimeV)).doubleValue();
                } else if (args.get(playtimeV) != null) {
                    try {
                        d = Double.parseDouble(args.get(playtimeV).toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    d = Double.parseDouble(playtimeV);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d != null && d > 0.0) {
                return d.intValue();
            }
        }
        return null;
    }

    public Integer getDelay(HashMap<String, Object> args) {
        if (this.delay != null) {
            String delayV = Event.replaceStringWithVariables(this.delay, args);
            Double d = null;
            if (args.containsKey(delayV)) {
                if (args.get(delayV) instanceof Number) {
                    d = ((Number)args.get(delayV)).doubleValue();
                } else if (args.get(delayV) != null) {
                    try {
                        d = Double.parseDouble(args.get(delayV).toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    d = Double.parseDouble(delayV);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d != null && d > 0.0) {
                return d.intValue();
            }
        }
        return null;
    }

    public Integer getCooldown(HashMap<String, Object> args) {
        if (this.cooldown != null) {
            String cooldownV = Event.replaceStringWithVariables(this.cooldown, args);
            Double d = null;
            if (args.containsKey(cooldownV)) {
                if (args.get(cooldownV) instanceof Number) {
                    d = ((Number)args.get(cooldownV)).doubleValue();
                } else if (args.get(cooldownV) != null) {
                    try {
                        d = Double.parseDouble(args.get(cooldownV).toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                try {
                    d = Double.parseDouble(cooldownV);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d != null && d > 0.0) {
                return d.intValue();
            }
        }
        return null;
    }

    public boolean meetsCondition(HashMap<String, Object> args) {
        if (this.constantName != null && !this.constantName.isEmpty()) {
            Event event = EventHandler.collectiveConstants.events.get(Event.replaceStringWithVariables(this.constantName, args));
            if (event == null) {
                ContentCreatorIntegration.logger.warn(LogType.EVENT, "No such constant event: " + Event.replaceStringWithVariables(this.constantName, args));
                return false;
            }
            return (event.disabled == null || event.disabled == false) && event.meetsCondition(args);
        }
        boolean trigger = this.conditions.length == 0;
        for (Condition condition : this.conditions) {
            boolean inverse;
            boolean met = condition.meetsCondition(args);
            boolean bl = inverse = condition.inverseMatch != null && condition.inverseMatch != false;
            if (inverse != met) {
                trigger = true;
                if (this.triggersFromAnyConditionMet == null || !this.triggersFromAnyConditionMet.booleanValue()) continue;
                break;
            }
            if (this.triggersFromAnyConditionMet != null && this.triggersFromAnyConditionMet.booleanValue()) continue;
            trigger = false;
            break;
        }
        return trigger;
    }

    public void trigger(HashMap<String, Object> args) {
        if (this.constantName != null) {
            Event event = EventHandler.collectiveConstants.events.get(Event.replaceStringWithVariables(this.constantName, args));
            if (event == null) {
                ContentCreatorIntegration.logger.warn(LogType.EVENT, "No such constant event: " + Event.replaceStringWithVariables(this.constantName, args));
                return;
            }
            if (event.disabled == null || !event.disabled.booleanValue()) {
                event.trigger(args);
            }
            return;
        }
        Outcome.triggerOutcomes(this.outcomes, this.singleOutcomeOnly, args);
    }

    public static String getRandomIdentifier() {
        return RandomStringUtils.randomAscii((int)20);
    }

    public static String replaceStringWithVariables(String input, HashMap<String, Object> defaultArgs) {
        int maxRecursive = -2;
        if (defaultArgs.containsKey("variableInsertionMaxRecursion")) {
            maxRecursive = Event.getAsInt(defaultArgs.get("variableInsertionMaxRecursion"));
        }
        if (maxRecursive == -1) {
            return input;
        }
        HashMap<String, Object> args = new HashMap<String, Object>(defaultArgs);
        ArrayList recursive = new ArrayList();
        String line = input;
        boolean loop = true;
        int currentLoop = 0;
        while (loop) {
            ++currentLoop;
            loop = false;
            List var = VARIABLE_SPLITTER.splitToList((CharSequence)line);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> newRecursives = new ArrayList<String>();
            for (int i1 = 0; i1 < var.size(); ++i1) {
                int i;
                String s = (String)var.get(i1);
                if (i1 == 0 && line.startsWith(s)) {
                    sb.append(s);
                    continue;
                }
                ArrayList<String> variableMatches = new ArrayList<String>();
                if (!s.isEmpty()) {
                    for (Map.Entry<String, Object> e : args.entrySet()) {
                        if (recursive.contains(e.getKey()) || !s.startsWith(e.getKey())) continue;
                        for (i = 0; i < variableMatches.size(); ++i) {
                            String key = (String)variableMatches.get(i);
                            if (key.length() >= e.getKey().length()) continue;
                            variableMatches.add(i, e.getKey());
                            break;
                        }
                        if (variableMatches.contains(e.getKey())) continue;
                        variableMatches.add(e.getKey());
                    }
                }
                if (!variableMatches.isEmpty()) {
                    String longestVar = (String)variableMatches.get(0);
                    if (args.get(longestVar) instanceof String[]) {
                        String[] array = (String[])args.get(longestVar);
                        for (i = 0; i < array.length; ++i) {
                            String aObj = array[i];
                            if (aObj.contains(longestVar)) {
                                newRecursives.add(longestVar);
                                continue;
                            }
                            sb.append(aObj);
                            if (i == array.length - 1) continue;
                            sb.append(", ");
                        }
                    } else {
                        Object argVar = args.get(longestVar);
                        if (argVar.toString().contains(longestVar)) {
                            newRecursives.add(longestVar);
                        }
                        sb.append(argVar);
                    }
                    sb.append(s.substring(longestVar.length()));
                    if (maxRecursive >= 0 && currentLoop > maxRecursive) continue;
                    loop = true;
                    continue;
                }
                sb.append((String)(line.startsWith("$") && i1 == 0 || i1 >= 1 ? "$" + s : s));
            }
            recursive.addAll(newRecursives);
            line = sb.toString();
        }
        return line;
    }

    public static List<? extends class_1297> getTarget(@Nullable class_1657 player, @NotNull String input) {
        List targets;
        class_2300 selector;
        if (iChunUtil.d().getServer() == null && !(player instanceof class_3222)) {
            return Event.clientGetTarget(input);
        }
        class_2303 parser = new class_2303(new StringReader(input), true);
        try {
            selector = parser.method_9882();
        }
        catch (CommandSyntaxException e) {
            ArrayList<class_1657> targets2 = new ArrayList<class_1657>();
            if (player != null) {
                targets2.add(player);
            }
            return targets2;
        }
        class_2168 source = player != null ? new class_2168((class_2165)player, new class_243(player.method_23317(), player.method_23318(), player.method_23321()), player.method_5802(), player.method_37908() instanceof class_3218 ? (class_3218)player.method_37908() : null, 4, player.method_5477().getString(), player.method_5476(), player.method_37908().method_8503(), (class_1297)player) : new class_2168((class_2165)iChunUtil.d().getServer(), iChunUtil.d().getServer().method_3847(class_1937.field_25179) == null ? class_243.field_1353 : class_243.method_24954((class_2382)iChunUtil.d().getServer().method_3847(class_1937.field_25179).method_43126()), class_241.field_1340, iChunUtil.d().getServer().method_3847(class_1937.field_25179), 4, "Server", (class_2561)class_2561.method_43470((String)"Server"), iChunUtil.d().getServer(), (class_1297)null);
        try {
            targets = selector.method_9816(source);
        }
        catch (CommandSyntaxException e) {
            targets = Collections.emptyList();
        }
        return targets;
    }

    public static List<? extends class_1297> clientGetTarget(@NotNull String input) {
        return EntityHelperClient.clientGetTarget((String)input);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getMinecraftVersion() {
        return class_155.method_16673().method_48019();
    }

    @Environment(value=EnvType.CLIENT)
    public static String getPlayerName() {
        return iChunUtil.eC().getPlayerName();
    }

    @Environment(value=EnvType.CLIENT)
    public static class_1657 getPlayer() {
        return iChunUtil.eC().getPlayer();
    }

    public static double getAsDouble(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static int getAsInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        try {
            return (int)Math.floor(Double.parseDouble(o.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static class Queue {
        public final Event event;
        public final HashMap<String, Object> args;
        public int eventPlayTime = 0;
        public int playTime = 0;
        public int delay = 0;

        public Queue(Event event, HashMap<String, Object> args) {
            Integer del;
            this.event = event;
            this.args = new HashMap<String, Object>(args);
            Integer playTime = event.getPlayTime(args);
            if (playTime != null) {
                this.eventPlayTime = playTime;
            }
            if ((del = event.getDelay(args)) != null) {
                this.delay = del;
            }
        }
    }
}

