/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition;

import com.mojang.util.UndashedUuid;
import java.util.HashMap;
import java.util.UUID;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;
import me.ichun.mods.cci.common.logger.LogType;
import net.minecraft.class_2495;
import net.minecraft.class_2512;

public class UUIDToNBTCondition
extends Condition {
    public String input = null;
    public String variableResult = null;
    public Boolean convertToMostLeast = false;

    public UUIDToNBTCondition() {
        this.type = "uuidToNBT";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        String uuidString = Event.replaceStringWithVariables(this.input, args);
        try {
            String varResult = Event.replaceStringWithVariables(this.variableResult, args);
            UUID uuid = UndashedUuid.fromStringLenient((String)uuidString);
            if (this.convertToMostLeast != null && this.convertToMostLeast.booleanValue()) {
                args.put(varResult + "Most", Long.toString(uuid.getMostSignificantBits()));
                args.put(varResult + "Least", Long.toString(uuid.getLeastSignificantBits()));
            } else {
                class_2495 arrayTag = class_2512.method_25929((UUID)uuid);
                args.put(varResult, arrayTag.toString());
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot parse string as UUID: " + uuidString);
            return false;
        }
    }

    @Override
    public boolean isValid() {
        return this.input != null && this.variableResult != null;
    }
}

