/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.condition.unconditional;

import java.util.HashMap;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.condition.Condition;

public class ArithmeticCondition
extends Condition {
    public String calc;
    public String value1;
    public String value2;
    public String variableName;

    public ArithmeticCondition() {
        this.type = "math";
    }

    @Override
    public boolean meetsCondition(HashMap<String, Object> args) {
        double d1;
        double d;
        String varName = Event.replaceStringWithVariables(this.variableName, args);
        String val1 = Event.replaceStringWithVariables(this.value1, args);
        if (args.containsKey(val1)) {
            d = 0.0;
            if (args.get(val1) instanceof Number) {
                d = ((Number)args.get(val1)).doubleValue();
            } else if (args.get(val1) != null) {
                try {
                    d = Double.parseDouble(args.get(val1).toString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                d = Double.parseDouble(val1);
            }
            catch (NumberFormatException e) {
                d = 0.0;
            }
        }
        String val2 = Event.replaceStringWithVariables(this.value2, args);
        if (args.containsKey(val2)) {
            d1 = 0.0;
            if (args.get(val2) instanceof Number) {
                d1 = ((Number)args.get(val2)).doubleValue();
            } else if (args.get(val2) != null) {
                try {
                    d1 = Double.parseDouble(args.get(val2).toString());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                d1 = Double.parseDouble(val2);
            }
            catch (NumberFormatException e) {
                d1 = 0.0;
            }
        }
        double result = 0.0;
        switch (this.calc) {
            case "+": {
                result = d + d1;
                break;
            }
            case "-": {
                result = d - d1;
                break;
            }
            case "x": 
            case "*": {
                result = d * d1;
                break;
            }
            case "/": 
            case "\u00f7": {
                if (d1 == 0.0) break;
                result = d / d1;
                break;
            }
            case "pow": {
                result = Math.pow(d, d1);
                break;
            }
            case "sqrt": {
                result = Math.sqrt(d);
                break;
            }
            case "cbrt": {
                result = Math.cbrt(d);
                break;
            }
            case "mod": {
                result = d % d1;
                break;
            }
            case "min": {
                result = Math.min(d, d1);
                break;
            }
            case "max": {
                result = Math.max(d, d1);
                break;
            }
            case "round": {
                args.put(varName, (int)Math.round(d));
                return true;
            }
            case "floor": {
                args.put(varName, (int)Math.floor(d));
                return true;
            }
            case "ceil": {
                args.put(varName, (int)Math.ceil(d));
                return true;
            }
            case "log": {
                result = Math.log(d);
                break;
            }
            case "signum": {
                result = Math.signum(d);
                break;
            }
            case "abs": {
                result = Math.abs(d);
                break;
            }
            case "sin": {
                result = Math.sin(Math.toRadians(d));
                break;
            }
            case "cos": {
                result = Math.cos(Math.toRadians(d));
                break;
            }
            case "tan": {
                result = Math.tan(Math.toRadians(d));
                break;
            }
            case "asin": {
                result = Math.toDegrees(Math.asin(d));
                break;
            }
            case "acos": {
                result = Math.toDegrees(Math.acos(d));
                break;
            }
            case "atan": {
                result = Math.toDegrees(Math.atan(d));
            }
        }
        args.put(varName, result);
        return true;
    }

    @Override
    public boolean isValid() {
        return this.calc != null && !this.calc.isEmpty() && this.value1 != null && !this.value1.isEmpty() && this.value2 != null && !this.value2.isEmpty() && this.variableName != null && !this.variableName.isEmpty();
    }
}

