/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.config.outcome;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5489;

public class FakeCrashOutcome
extends Outcome {
    public String crashType;
    public String crashDuration;

    public FakeCrashOutcome() {
        this.type = "fakeCrash";
    }

    @Override
    public boolean isClientSide(HashMap<String, Object> args) {
        return true;
    }

    @Override
    public boolean trigger(class_1657 player, HashMap<String, Object> args) {
        ContentCreatorIntegration.logger.info(LogType.EVENT, "We are intentionally (fake) crashing the game!");
        int crashType = Event.getAsInt(Event.replaceStringWithVariables(this.crashType, args));
        int crashDuration = 100;
        if (this.crashDuration != null) {
            crashDuration = Event.getAsInt(Event.replaceStringWithVariables(this.crashDuration, args));
        }
        switch (crashType) {
            case 1: {
                try {
                    Thread.sleep((long)(crashDuration / 20) * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            case 2: {
                this.openOOMScreen(crashDuration);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.crashType != null && !this.crashType.isEmpty();
    }

    @Environment(value=EnvType.CLIENT)
    public void openOOMScreen(int duration) {
        class_310.method_1551().method_1507((class_437)new MemoryErrorScreen(class_310.method_1551().field_1755, duration));
    }

    @Environment(value=EnvType.CLIENT)
    public static class MemoryErrorScreen
    extends class_437 {
        public class_437 lastScreen;
        public int duration;
        public int currentDuration;
        private class_5489 message = class_5489.field_26528;

        public MemoryErrorScreen(class_437 lastScreen, int duration) {
            super((class_2561)class_2561.method_43471((String)"outOfMemory.title"));
            this.lastScreen = lastScreen;
            this.duration = duration;
        }

        protected void method_25426() {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_43109, button -> {}).method_46434(this.field_22789 / 2 - 155, this.field_22790 / 4 + 120 + 12, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"menu.quit"), button -> {}).method_46434(this.field_22789 / 2 - 155 + 160, this.field_22790 / 4 + 120 + 12, 150, 20).method_46431());
            this.message = class_5489.method_30890((class_327)this.field_22793, (class_5348)class_2561.method_43471((String)"outOfMemory.message"), (int)295);
        }

        public void method_25393() {
            super.method_25393();
            ++this.currentDuration;
            if (this.currentDuration > this.duration) {
                this.field_22787.method_1507(this.lastScreen);
            }
        }

        public boolean method_25422() {
            return false;
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 4 - 60 + 20, 0xFFFFFF);
            this.message.method_30893(guiGraphics, this.field_22789 / 2 - 145, this.field_22790 / 4, 9, 0xA0A0A0);
        }
    }
}

