/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.mc.config.reflect;

import java.util.HashMap;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.logger.LogType;
import org.jetbrains.annotations.Nullable;

public class ParamInjector {
    private static final HashMap<String, Class<?>> PRIMITIVES = new HashMap<String, Class<?>>(){
        {
            this.put("byte", Byte.TYPE);
            this.put("short", Short.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("char", Character.TYPE);
            this.put("String", String.class);
        }
    };
    public Boolean isPrimitive;
    public transient Object primitiveObjectWrapper;
    public String classType;
    public transient Class<?> classTypeClass;
    public String argToPull;

    public boolean setup() {
        if (this.classType != null) {
            if (this.isPrimitive != null && this.isPrimitive.booleanValue()) {
                if (PRIMITIVES.containsKey(this.classType)) {
                    this.classTypeClass = PRIMITIVES.get(this.classType);
                    if (this.argToPull != null) {
                        try {
                            switch (this.classType) {
                                case "byte": {
                                    this.primitiveObjectWrapper = Byte.parseByte(this.argToPull);
                                    break;
                                }
                                case "short": {
                                    this.primitiveObjectWrapper = Short.parseShort(this.argToPull);
                                    break;
                                }
                                case "int": {
                                    this.primitiveObjectWrapper = Integer.parseInt(this.argToPull);
                                    break;
                                }
                                case "long": {
                                    this.primitiveObjectWrapper = Long.parseLong(this.argToPull);
                                    break;
                                }
                                case "float": {
                                    this.primitiveObjectWrapper = Float.valueOf(Float.parseFloat(this.argToPull));
                                    break;
                                }
                                case "double": {
                                    this.primitiveObjectWrapper = Double.parseDouble(this.argToPull);
                                    break;
                                }
                                case "boolean": {
                                    this.primitiveObjectWrapper = this.argToPull.equals("true");
                                    break;
                                }
                                case "char": {
                                    this.primitiveObjectWrapper = Character.valueOf(this.argToPull.charAt(0));
                                    break;
                                }
                                case "String": {
                                    this.primitiveObjectWrapper = this.argToPull;
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Unknown primitive type: " + this.classType);
                return false;
            }
            try {
                this.classTypeClass = Class.forName(this.classType);
                return true;
            }
            catch (ClassNotFoundException e) {
                ContentCreatorIntegration.logger.error(LogType.EVENT, "Cannot find class type, disabling param injector: " + this.classType);
                e.printStackTrace();
            }
        }
        return false;
    }

    @Nullable
    public Object pullArg(HashMap<String, Object> args) {
        if (this.isPrimitive != null && this.isPrimitive.booleanValue() && !args.containsKey(this.argToPull)) {
            return this.primitiveObjectWrapper;
        }
        return this.argToPull != null ? args.get(Event.replaceStringWithVariables(this.argToPull, args)) : null;
    }
}

