/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.streamelements.event.type;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.shadow.org.json.JSONObject;

public class EventInfo
implements IEvent {
    public final String id;
    public HashMap<String, Object> messages = new HashMap();

    public EventInfo(String id, JSONObject info) {
        this.id = id;
        try {
            String json = info.toString();
            if (json.startsWith("[")) {
                HashMap[] messageArray = (HashMap[])EventConfiguration.GSON.fromJson(json, new TypeToken<HashMap<String, Object>[]>(){}.getType());
                if (messageArray != null && messageArray.length > 0) {
                    for (int i = 0; i < messageArray.length; ++i) {
                        HashMap map = messageArray[i];
                        for (Map.Entry e : map.entrySet()) {
                            this.messages.put(i + "_" + (String)e.getKey(), e.getValue());
                        }
                    }
                }
            } else {
                this.messages = (HashMap)EventConfiguration.GSON.fromJson(json, new TypeToken<HashMap<String, Object>>(){}.getType());
            }
            EventHandler.sortArgs(this.messages);
        }
        catch (JsonSyntaxException e) {
            ContentCreatorIntegration.logger.error(LogType.SOCKET_EVENT, "Error parsing StreamElements event: " + info.toString());
            e.printStackTrace();
        }
    }

    @Override
    public HashMap<String, Object> getArgs() {
        return this.messages;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

