/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.streamlabs.event;

import java.util.ArrayList;
import java.util.Iterator;
import me.ichun.mods.cci.api.event.IEvent;
import me.ichun.mods.cci.api.event.IEvents;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.module.streamlabs.event.type.EventInfo;
import me.ichun.shadow.org.json.JSONArray;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;

public class StreamlabsEvents
implements IEvents {
    private String type;
    private EventInfo[] message;
    private String eventId;
    private String _for;

    private StreamlabsEvents(String type, EventInfo[] eventInfo, String eventId, String _for) {
        this.type = type;
        this.message = eventInfo;
        this.eventId = eventId;
        this._for = _for;
    }

    public String getType() {
        return this.type;
    }

    public Object getMessage() {
        return this.message;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getFor() {
        return this._for;
    }

    public static StreamlabsEvents deserialize(JSONObject json, int socketId) {
        String type = null;
        EventInfo[] info = null;
        String eventId = null;
        String _for = null;
        ArrayList<JSONObject> eventInfoArray = new ArrayList<JSONObject>();
        try {
            Iterator ite = json.keys();
            block17: while (ite.hasNext()) {
                String key;
                switch (key = (String)ite.next()) {
                    case "type": {
                        type = json.getString(key);
                        break;
                    }
                    case "message": {
                        JSONArray array = json.optJSONArray(key);
                        if (array != null) {
                            for (int i = 0; i < array.length(); ++i) {
                                JSONObject obj = array.getJSONObject(i);
                                eventInfoArray.add(obj);
                            }
                            continue block17;
                        }
                        JSONObject obj = json.optJSONObject(key);
                        if (obj == null) continue block17;
                        eventInfoArray.add(obj);
                        break;
                    }
                    case "event_id": {
                        eventId = json.getString(key);
                        break;
                    }
                    case "for": {
                        _for = json.getString(key);
                        break;
                    }
                    case "event": 
                    case "payload": {
                        break;
                    }
                    default: {
                        ContentCreatorIntegration.logger.error(LogType.SOCKET_EVENT, "Unknown event key \"" + key + "\" for Streamlabs event");
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (type != null && !eventInfoArray.isEmpty() && (info = EventInfo.parseEvents(eventInfoArray, type, _for)) != null) {
            for (EventInfo info1 : info) {
                info1.messages.put("cci-type-configId", socketId);
            }
            if (eventId == null && info.length == 1) {
                eventId = info[0].getId();
            }
            return new StreamlabsEvents(type, info, eventId, _for);
        }
        return null;
    }

    @Override
    public String configurationType() {
        return "streamlabs";
    }

    @Override
    public String eventType() {
        return this.type;
    }

    @Override
    public String forType() {
        return this._for;
    }

    @Override
    public int eventCount() {
        return this.message.length;
    }

    @Override
    public IEvent getEvent(int i) {
        return this.message[i];
    }
}

