/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.twitch.eventsub;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.module.twitch.eventsub.SubscriptionType;
import me.ichun.mods.cci.common.module.twitch.eventsub.SubscriptionTypeRegistry;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.cci.common.thread.ThreadWebSocket;
import me.ichun.shadow.org.json.JSONArray;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ThreadTwitchEventSubSocket
extends ThreadWebSocket {
    public static final String DEFAULT_WS_URL = "wss://eventsub.wss.twitch.tv/ws";
    public String url;
    public String clientId;
    public boolean oauthValid = false;
    public String channelId = null;
    public HashSet<String> availableScopes = new HashSet();
    public String sessionId;

    public ThreadTwitchEventSubSocket(Logger logger, String url, String clientID, String socketToken, int id) {
        super(logger, socketToken, id);
        this.url = url;
        this.clientId = clientID;
        if (this.clientId.isEmpty()) {
            this.clientId = "gp762nuuoqcoxypju8c569th9wz7q5";
        }
    }

    @Override
    public void run() {
        this.validateOauth();
        if (this.oauthValid) {
            try {
                if (!EventConfiguration.eventConfigurations.containsKey("twitcheventsub")) {
                    EventConfiguration.readConfigurationFile("twitcheventsub");
                }
                this.getLogger().info(LogType.SOCKET_STATUS, "Connecting to " + this.getSocketType() + " - " + this.getSocketId());
                this.socket = this.createWebSocket();
                this.socket.reconnectAttempt = this.reconnectAttempt;
                this.socket.connect();
            }
            catch (Exception e) {
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.failed"));
                e.printStackTrace();
            }
        } else {
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.pubsub.errorConsole"));
        }
    }

    public void validateOauth() {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet("https://id.twitch.tv/oauth2/validate");
            request.addHeader("Authorization", "Bearer " + this.getSocketToken());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String result = EntityUtils.toString((HttpEntity)entity);
                        JSONObject jsonObject = new JSONObject(result);
                        this.channelId = jsonObject.getString("user_id");
                        JSONArray scopes = jsonObject.getJSONArray("scopes");
                        for (int i = 0; i < scopes.length(); ++i) {
                            this.availableScopes.add(scopes.getString(i));
                        }
                        this.oauthValid = true;
                    }
                } else {
                    this.channelId = null;
                    this.availableScopes.clear();
                    this.oauthValid = false;
                    this.getLogger().error(LogType.SOCKET_STATUS, "Error validating OAuth key for " + this.getSocketType() + " " + this.getSocketId() + ": " + response.getStatusLine());
                }
            }
        }
        catch (IOException | JSONException e) {
            this.getLogger().error(LogType.SOCKET_STATUS, "Error validating OAuth key for " + this.getSocketType() + " " + this.getSocketId());
            e.printStackTrace();
        }
    }

    public void subscribeToEvents() {
        for (SubscriptionType type : SubscriptionTypeRegistry.SUBSCRIPTION_TYPES) {
            SubscriptionType.Version versionWithinScope;
            if (!type.isSupported() || (versionWithinScope = type.getVersionWithinScope(this.availableScopes)) == null) continue;
            if (type.name.equals("channel.raid")) {
                try {
                    for (String requiredCondition : type.optionalConditions) {
                        JSONObject condition = new JSONObject();
                        condition.put(requiredCondition, this.channelId);
                        this.subscribeToEvent(type.name, versionWithinScope.getVersion(), condition);
                    }
                    continue;
                }
                catch (JSONException e) {
                    this.getLogger().error(LogType.SOCKET_STATUS, "Error subscribing to event " + type.name + " for " + this.getSocketType() + " " + this.getSocketId());
                    e.printStackTrace();
                    continue;
                }
            }
            try {
                JSONObject condition = new JSONObject();
                for (String requiredCondition : type.requiredConditions) {
                    condition.put(requiredCondition, this.channelId);
                }
                this.subscribeToEvent(type.name, versionWithinScope.getVersion(), condition);
            }
            catch (JSONException e) {
                this.getLogger().error(LogType.SOCKET_STATUS, "Error subscribing to event " + type.name + " for " + this.getSocketType() + " " + this.getSocketId());
                e.printStackTrace();
            }
        }
    }

    private void subscribeToEvent(String subscriptionType, String version, JSONObject condition) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost request = new HttpPost("https://api.twitch.tv/helix/eventsub/subscriptions");
            JSONObject json = new JSONObject();
            json.put("type", subscriptionType);
            json.put("version", version);
            json.put("condition", condition);
            JSONObject transport = new JSONObject();
            transport.put("method", "websocket");
            transport.put("session_id", this.sessionId);
            json.put("transport", transport);
            request.setEntity((HttpEntity)new StringEntity(json.toString()));
            request.addHeader("Authorization", "Bearer " + this.getSocketToken());
            request.addHeader("Client-Id", this.clientId);
            request.addHeader("Content-Type", "application/json");
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 202) {
                } else {
                    this.getLogger().error(LogType.SOCKET_STATUS, "Error subscribing to event " + subscriptionType + " for " + this.getSocketType() + " " + this.getSocketId() + ": " + response.getStatusLine());
                }
            }
        }
        catch (IOException | JSONException e) {
            this.getLogger().error(LogType.SOCKET_STATUS, "Error subscribing to event " + subscriptionType + " for " + this.getSocketType() + " " + this.getSocketId());
            e.printStackTrace();
        }
    }

    @Override
    public String getSocketType() {
        return "TwitchEventSub";
    }

    @Override
    public String getSocketUrl() {
        return this.url;
    }

    @Override
    public ThreadWebSocket.WebSocket createWebSocket() throws URISyntaxException {
        return new ThreadWebSocket.WebSocket(this, new URI(this.getSocketUrl()), this.getLogger(), this.getSocketType(), this.getSocketId()){

            @Override
            public void onMessage(String message) {
                try {
                    JSONObject json = new JSONObject(message.trim());
                    JSONObject metadata = json.getJSONObject("metadata");
                    String type = metadata.getString("message_type");
                    if (!type.equals("session_keepalive")) {
                        this.getLogger().info(LogType.SOCKET_EVENT, "Event TE: " + message.trim());
                    }
                    switch (type) {
                        case "session_welcome": {
                            JSONObject payload = json.getJSONObject("payload");
                            JSONObject session = payload.getJSONObject("session");
                            ThreadTwitchEventSubSocket.this.sessionId = session.getString("id");
                            if (ThreadTwitchEventSubSocket.this.getSocketUrl().equals(ThreadTwitchEventSubSocket.DEFAULT_WS_URL)) {
                                ThreadTwitchEventSubSocket.this.subscribeToEvents();
                            }
                            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.ready"));
                            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent("twitcheventsub", this.getSocketType().toLowerCase() + "connection", "ready", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                                {
                                    this.put("cci-type-configId", this.getSocketId());
                                }
                            })));
                            break;
                        }
                        case "session_keepalive": {
                            break;
                        }
                        case "notification": {
                            String subscriptionType = metadata.getString("subscription_type");
                            JSONObject payload = json.getJSONObject("payload");
                            GenericEvent genericEvent = ThreadTwitchEventSubSocket.this.parseEvent(subscriptionType, payload);
                            if (genericEvent == null) break;
                            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(genericEvent));
                            break;
                        }
                        case "session_reconnect": {
                            JSONObject payload = json.getJSONObject("payload");
                            JSONObject session = payload.getJSONObject("session");
                            SocketHandler.sockets.remove(ThreadTwitchEventSubSocket.this);
                            ThreadTwitchEventSubSocket socket2 = (ThreadTwitchEventSubSocket)ThreadTwitchEventSubSocket.this.copy();
                            socket2.url = session.getString("reconnect_url");
                            SocketHandler.sockets.add(socket2);
                            socket2.setReconnectAttempt(this.reconnectAttempt);
                            socket2.start();
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ThreadTwitchEventSubSocket.this.killSocket();
                            break;
                        }
                        case "revocation": {
                            String subscriptionType = metadata.getString("subscription_type");
                            this.getLogger().info(LogType.SOCKET_EVENT, "Received revocation message of type " + subscriptionType + " with reason: " + json.getJSONObject("payload").getJSONObject("subscription").getString("status"));
                            break;
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                this.getLogger().error(LogType.SOCKET_STATUS, "Disconnected from " + this.getSocketType() + " - " + this.getSocketId() + ": " + code + " ; " + reason + " ; " + remote);
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disconnected"));
                class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "disconnected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                    {
                        this.put("cci-type-configId", this.getSocketId());
                    }
                })));
                if (!this.killed && this.canReconnect()) {
                    ++this.reconnectAttempt;
                    this.close();
                    SocketHandler.sockets.remove(ThreadTwitchEventSubSocket.this);
                    ThreadWebSocket socket2 = ThreadTwitchEventSubSocket.this.copy();
                    SocketHandler.sockets.add(socket2);
                    socket2.setReconnectAttempt(this.reconnectAttempt);
                    socket2.start();
                }
            }
        };
    }

    public GenericEvent parseEvent(String eventType, JSONObject payload) {
        try {
            JSONObject event = payload.getJSONObject("event");
            String topic = eventType.substring(0, eventType.lastIndexOf("."));
            String type = eventType.substring(eventType.lastIndexOf(".") + 1);
            if (eventType.equals("channel.raid")) {
                JSONObject condition = payload.getJSONObject("subscription").getJSONObject("condition");
                type = condition.has("to_broadcaster_user_id") ? "incoming" : "outgoing";
            }
            HashMap args = (HashMap)EventConfiguration.GSON.fromJson(event.toString(), new TypeToken<HashMap<String, Object>>(){}.getType());
            EventHandler.sortArgs(args);
            args.put("cci-type-configId", this.getSocketId());
            args.put("cci-type-for", topic);
            args.put("cci-type-event", type);
            return new GenericEvent(this.getSocketType().toLowerCase(Locale.ROOT), topic, type, String.valueOf(event.toString().hashCode()), args);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ThreadWebSocket copy() {
        return new ThreadTwitchEventSubSocket(this.getLogger(), this.url, this.clientId, this.getSocketToken(), this.getSocketId());
    }
}

