/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.module.twitch.pubsub;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import me.ichun.mods.cci.common.config.Event;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.event.EventHandler;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.cci.common.logger.Logger;
import me.ichun.mods.cci.common.module.generic.GenericEvent;
import me.ichun.mods.cci.common.thread.SocketHandler;
import me.ichun.mods.cci.common.thread.ThreadWebSocket;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshake;
import me.ichun.shadow.org.json.JSONArray;
import me.ichun.shadow.org.json.JSONException;
import me.ichun.shadow.org.json.JSONObject;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ThreadTwitchPubSubSocket
extends ThreadWebSocket {
    private static final HashMap<String, HashSet<String>> SCOPE_TO_EVENT = new HashMap();
    public boolean oauthValid;
    public String channelId;
    public HashSet<String> availableScopes;
    public long timer;
    public long heartbeatTime;
    public Random rand;

    public ThreadTwitchPubSubSocket(Logger logger, String socketToken, int id) {
        super(logger, socketToken, id);
        SCOPE_TO_EVENT.computeIfAbsent("bits:read", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("channel-bits-events-v2.%s");
            set.add("channel-bits-badge-unlocks.%s");
            set.add("channel-bit-events-public.%s");
            set.add("channel-cheer-events-public-v1.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("chat:read", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("user-moderation-notifications.%s.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:moderate", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("chat_moderator_actions.%s.%s");
            set.add("automod-queue.%s.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:read:hype_train", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("hype-train-events-v1.rewards.%s");
            set.add("hype-train-events-v1.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:read:polls", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("polls.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:read:predictions", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("predictions-channel-v1.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:read:redemptions", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("community-points-channel-v1.%s");
            set.add("channel-points-channel-v1.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("channel:read:subscriptions", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("channel-subscribe-events-v1.%s");
            set.add("channel-sub-gifts-v1.%s");
            return set;
        });
        SCOPE_TO_EVENT.computeIfAbsent("", v -> {
            HashSet<String> set = new HashSet<String>();
            set.add("leaderboard-events-v1.bits-usage-by-channel-v1-%s-WEEK");
            set.add("leaderboard-events-v1.bits-usage-by-channel-v1-%s-MONTH");
            set.add("leaderboard-events-v1.sub-gifts-sent-%s-WEEK");
            set.add("leaderboard-events-v1.sub-gifts-sent-%s-MONTH");
            set.add("following.%s");
            set.add("raid.%s");
            set.add("celebration-events-v1.%s");
            return set;
        });
        this.oauthValid = false;
        this.channelId = null;
        this.availableScopes = new HashSet();
        this.timer = 0L;
        this.rand = new Random();
    }

    @Override
    public void run() {
        this.validateOauth();
        if (this.oauthValid) {
            try {
                if (!EventConfiguration.eventConfigurations.containsKey("twitchpubsub")) {
                    EventConfiguration.readConfigurationFile("twitchpubsub");
                }
                this.getLogger().info(LogType.SOCKET_STATUS, "Connecting to " + this.getSocketType() + " - " + this.getSocketId());
                this.socket = this.createWebSocket();
                this.socket.reconnectAttempt = this.reconnectAttempt;
                LocalDate date = LocalDate.now();
                LocalDate endDate = LocalDate.of(2025, 4, 14);
                if (date.isAfter(endDate)) {
                    EventHandler.triggerToast((class_2561)class_2561.method_43470((String)"PubSub has shut down!"), (class_2561)class_2561.method_43470((String)"Twitch has shut down PubSub. Switch to EventSub which has replaced PubSub"));
                    return;
                }
                this.socket.connect();
                while (this.socket != null && !this.socket.killed) {
                    ++this.timer;
                    if (this.timer > this.heartbeatTime + 10L) {
                        this.socket.close();
                    }
                    if (this.timer == this.heartbeatTime) {
                        this.sendHeartbeat();
                    }
                    if (this.timer % 3600L == 0L) {
                        this.validateOauth();
                        if (!this.oauthValid) {
                            this.socket.close();
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.failed"));
                e.printStackTrace();
            }
        } else {
            EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.pubsub.errorConsole"));
        }
    }

    public void validateOauth() {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet request = new HttpGet("https://id.twitch.tv/oauth2/validate");
            request.addHeader("Authorization", "Bearer " + this.getSocketToken());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String result = EntityUtils.toString((HttpEntity)entity);
                        JSONObject jsonObject = new JSONObject(result);
                        this.channelId = jsonObject.getString("user_id");
                        JSONArray scopes = jsonObject.getJSONArray("scopes");
                        for (int i = 0; i < scopes.length(); ++i) {
                            this.availableScopes.add(scopes.getString(i));
                        }
                        this.availableScopes.add("");
                        this.oauthValid = true;
                    }
                } else {
                    this.channelId = null;
                    this.availableScopes.clear();
                    this.oauthValid = false;
                    this.getLogger().error(LogType.SOCKET_STATUS, "Error validating OAuth key for " + this.getSocketType() + " " + this.getSocketId() + ": " + response.getStatusLine());
                }
            }
        }
        catch (IOException | JSONException e) {
            this.getLogger().error(LogType.SOCKET_STATUS, "Error validating OAuth key for " + this.getSocketType() + " " + this.getSocketId());
            e.printStackTrace();
        }
    }

    public void sendHeartbeat() {
        if (this.socket != null && !this.socket.killed && this.socket.isOpen()) {
            try {
                JSONObject object = new JSONObject();
                object.put("type", "PING");
                this.socket.send(object.toString());
                this.heartbeatTime = this.timer;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void itsAlive() {
        this.heartbeatTime = this.timer + 240L + (long)this.rand.nextInt(30);
    }

    @Override
    public String getSocketType() {
        return "TwitchPubSub";
    }

    @Override
    public String getSocketUrl() {
        return "wss://pubsub-edge.twitch.tv";
    }

    @Override
    public ThreadWebSocket.WebSocket createWebSocket() throws URISyntaxException {
        return new ThreadWebSocket.WebSocket(this, new URI(this.getSocketUrl()), this.getLogger(), this.getSocketType(), this.getSocketId()){

            @Override
            public void onOpen(ServerHandshake handshakedata) {
                super.onOpen(handshakedata);
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)"PubSub shutting down!"), (class_2561)class_2561.method_43470((String)"Twitch is shutting down PubSub in favour of EventSub. Move over to EventSub before April 14 to minimalise disruptions! You will need to restart CCI after connecting EventSub for the first time."));
                ThreadTwitchPubSubSocket.this.sendHeartbeat();
                HashSet temp = new HashSet();
                HashSet<String> topics = new HashSet<String>();
                for (String availableScope : ThreadTwitchPubSubSocket.this.availableScopes) {
                    if (SCOPE_TO_EVENT.containsKey(availableScope)) {
                        temp.addAll(SCOPE_TO_EVENT.get(availableScope));
                        continue;
                    }
                    this.getLogger().error(LogType.SOCKET_STATUS, "Unknown scope " + this.getSocketType() + " " + this.getSocketId() + ": " + availableScope);
                }
                for (String s : temp) {
                    topics.add(s.replaceAll("%s", ThreadTwitchPubSubSocket.this.channelId));
                }
                try {
                    JSONObject json = new JSONObject();
                    json.put("type", "LISTEN");
                    json.put("nonce", "TotallyRandomListenRequestNonce");
                    JSONObject data = new JSONObject();
                    data.put("topics", topics);
                    data.put("auth_token", ThreadTwitchPubSubSocket.this.getSocketToken());
                    json.put("data", data);
                    this.send(json.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onMessage(String message) {
                try {
                    String type;
                    JSONObject json = new JSONObject(message.trim());
                    if (!json.has("type") || !json.getString("type").equals("PONG")) {
                        this.getLogger().info(LogType.SOCKET_EVENT, "Event TP: " + message.trim());
                    }
                    switch (type = json.getString("type")) {
                        case "RECONNECT": {
                            this.close();
                            break;
                        }
                        case "PONG": {
                            ThreadTwitchPubSubSocket.this.itsAlive();
                            break;
                        }
                        case "RESPONSE": {
                            if (!json.has("error")) break;
                            String s = json.getString("error");
                            if (!s.isEmpty() && json.has("nonce") && json.getString("nonce").equals("TotallyRandomListenRequestNonce")) {
                                this.getLogger().error(LogType.SOCKET_STATUS, "Error listening to topics for " + this.getSocketType() + " - " + this.getSocketId() + ": " + s);
                                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.pubsub.errorConsole"));
                                ThreadTwitchPubSubSocket.this.killSocket();
                            }
                            break;
                        }
                        case "MESSAGE": {
                            GenericEvent event = ThreadTwitchPubSubSocket.this.parseMessage(json);
                            if (event == null) break;
                            class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(event));
                            break;
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                this.getLogger().error(LogType.SOCKET_STATUS, "Disconnected from " + this.getSocketType() + " - " + this.getSocketId() + ": " + code + " ; " + reason + " ; " + remote);
                EventHandler.triggerToast((class_2561)class_2561.method_43470((String)(this.getSocketType() + " - " + this.getSocketId())), (class_2561)class_2561.method_43471((String)"cci.toast.disconnected"));
                class_310.method_1551().execute(() -> EventHandler.triggerOrQueueEvent(new GenericEvent(this.getSocketType().toLowerCase(), "connection", "disconnected", Event.getRandomIdentifier(), new HashMap<String, Object>(){
                    {
                        this.put("cci-type-configId", this.getSocketId());
                    }
                })));
                if (!this.killed && this.canReconnect()) {
                    ++this.reconnectAttempt;
                    this.close();
                    SocketHandler.sockets.remove(ThreadTwitchPubSubSocket.this);
                    ThreadWebSocket socket2 = ThreadTwitchPubSubSocket.this.copy();
                    SocketHandler.sockets.add(socket2);
                    socket2.setReconnectAttempt(this.reconnectAttempt);
                    socket2.start();
                }
            }
        };
    }

    public GenericEvent parseMessage(JSONObject json) {
        try {
            JSONObject data = json.getJSONObject("data");
            Object topic = data.getString("topic");
            topic = ((String)topic).contains("WEEK") || ((String)topic).contains("MONTH") ? ((String)topic).substring(0, ((String)topic).indexOf(this.channelId) - 1) + ((String)topic).substring(((String)topic).indexOf(this.channelId) + this.channelId.length()) : ((String)topic).substring(0, ((String)topic).indexOf(this.channelId) - 1);
            JSONObject message = new JSONObject(data.getString("message"));
            Object type = topic;
            if (message.has("type")) {
                type = message.getString("type");
            }
            HashMap args = message.has("data") ? (HashMap)EventConfiguration.GSON.fromJson(message.getJSONObject("data").toString(), new TypeToken<HashMap<String, Object>>(){}.getType()) : (HashMap)EventConfiguration.GSON.fromJson(message.toString(), new TypeToken<HashMap<String, Object>>(){}.getType());
            EventHandler.sortArgs(args);
            args.put("cci-type-configId", this.getSocketId());
            args.put("cci-type-for", topic);
            args.put("cci-type-event", type);
            return new GenericEvent(this.getSocketType().toLowerCase(Locale.ROOT), (String)topic, (String)type, String.valueOf(json.toString().hashCode()), args);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ThreadWebSocket copy() {
        return new ThreadTwitchPubSubSocket(this.getLogger(), this.getSocketToken(), this.getSocketId());
    }
}

