/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.cci.common.network.packet;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.ichun.mods.cci.common.ContentCreatorIntegration;
import me.ichun.mods.cci.common.config.EventConfiguration;
import me.ichun.mods.cci.common.config.outcome.Outcome;
import me.ichun.mods.cci.common.logger.LogType;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public class PacketOutcome
extends AbstractPacket {
    public String id;
    public byte packetIndex;
    public byte packetCount;
    public byte[] data;
    private static final HashMap<String, byte[][]> PACKET_FRAGMENTS = new HashMap();

    public PacketOutcome() {
    }

    private PacketOutcome(String id, byte index, byte count, byte[] data) {
        this.id = id;
        this.packetIndex = index;
        this.packetCount = count;
        this.data = data;
    }

    public void writeTo(class_2540 buf) {
        buf.method_10814(this.id);
        buf.method_52997((int)this.packetIndex);
        buf.method_52997((int)this.packetCount);
        buf.method_53002(this.data.length);
        buf.method_52983(this.data);
    }

    public void readFrom(class_2540 buf) {
        this.id = buf.method_10800(Short.MAX_VALUE);
        this.packetIndex = buf.readByte();
        this.packetCount = buf.readByte();
        this.data = new byte[buf.readInt()];
        buf.method_52979(this.data);
    }

    public Optional<Runnable> process(class_1657 player) {
        byte[][] packets = PACKET_FRAGMENTS.computeIfAbsent(this.id, v -> new byte[this.packetCount][]);
        packets[this.packetIndex] = this.data;
        boolean complete = true;
        for (byte[] b : packets) {
            if (b != null && b.length != 0) continue;
            complete = false;
            break;
        }
        if (complete) {
            int size = 0;
            for (byte[] packet : packets) {
                size += packet.length;
            }
            byte[] fileData = new byte[size];
            int index = 0;
            for (byte[] packet : packets) {
                System.arraycopy(packet, 0, fileData, index, packet.length);
                index += packet.length;
            }
            PACKET_FRAGMENTS.remove(this.id);
            Holder holder = (Holder)EventConfiguration.GSON.fromJson(new String(fileData, StandardCharsets.UTF_8), Holder.class);
            holder.sanitizeArgs();
            return this.oldProcess(player, holder.json, holder.args);
        }
        return Optional.empty();
    }

    public Optional<Runnable> oldProcess(class_1657 player, String outcomeJson, HashMap<String, Object> args) {
        block10: {
            boolean clientBound = player == null || player.method_37908().method_8608();
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(outcomeJson).getAsJsonObject();
            String type = jsonObject.get("type").getAsString();
            if (Outcome.OUTCOME_TYPES.containsKey(type)) {
                try {
                    Outcome outcome = (Outcome)EventConfiguration.GSON.fromJson(jsonObject.toString(), Outcome.OUTCOME_TYPES.get(type));
                    if (clientBound) {
                        ContentCreatorIntegration.logger.info(LogType.CCI, "Received outcome from server, triggering.");
                        args.remove("cci-type-origin");
                        return Optional.of(() -> outcome.doTriggerOrWait(Outcome.getClientPlayer(), args));
                    }
                    if (player != null && !outcome.isClientSide(args)) {
                        args.put("cci-type-origin", player.method_7334().getId().toString());
                        if (iChunUtil.d().getServer().method_3724()) {
                            if (player.method_5477().getString().equalsIgnoreCase(iChunUtil.d().getServer().method_43824().getName())) {
                                return Optional.of(() -> outcome.trigger(player, args));
                            }
                        } else if (ContentCreatorIntegration.eventHandlerServer.isPlayerWhitelisted(player)) {
                            ContentCreatorIntegration.logger.info(LogType.CCI, "Triggering event for: " + player.method_5477().getString());
                            return Optional.of(() -> outcome.trigger(player, args));
                        }
                        break block10;
                    }
                    ContentCreatorIntegration.logger.error(LogType.CCI, "Received client-side outcome on server from " + player.method_5477().getString() + ", this is an error: " + jsonObject.toString());
                }
                catch (JsonParseException e) {
                    ContentCreatorIntegration.logger.error(LogType.CCI, "Error parsing outcome: " + type);
                    e.printStackTrace();
                }
            } else {
                ContentCreatorIntegration.logger.error(LogType.CCI, "Unknown outcome type: " + type);
            }
        }
        return Optional.empty();
    }

    public static ArrayList<PacketOutcome> createOutcomePackets(String outcomeJson, HashMap<String, Object> oldArgs) {
        ArrayList<PacketOutcome> packets = new ArrayList<PacketOutcome>();
        HashMap<String, Object> args = new HashMap<String, Object>(oldArgs);
        args.entrySet().removeIf(e -> !(e.getValue() instanceof Double) && !(e.getValue() instanceof Integer) && !(e.getValue() instanceof String) && !(e.getValue() instanceof Boolean) && !(e.getValue() instanceof ArrayList) && !(e.getValue() instanceof String[]) && e.getValue() != null);
        Holder holder = new Holder(outcomeJson, args);
        String holderJson = EventConfiguration.GSON.toJson((Object)holder);
        byte[] holderBytes = holderJson.getBytes(StandardCharsets.UTF_8);
        int maxFile = 32000;
        int fileSize = holderBytes.length;
        byte packetsToSend = (byte)Math.ceil((float)fileSize / 32000.0f);
        byte packetCount = 0;
        int offset = 0;
        String id = class_3532.method_15394().toString();
        while (fileSize > 0) {
            int index;
            byte[] fileBytes = new byte[Math.min(fileSize, 32000)];
            for (index = 0; index < fileBytes.length; ++index) {
                fileBytes[index] = holderBytes[index + offset];
            }
            packets.add(new PacketOutcome(id, packetCount, packetsToSend, fileBytes));
            packetCount = (byte)(packetCount + 1);
            fileSize -= fileBytes.length;
            offset += index;
        }
        return packets;
    }

    private static class Holder {
        public String json;
        public HashMap<String, Object> args;

        public Holder(String json, HashMap<String, Object> args) {
            this.json = json;
            this.args = args;
        }

        public void sanitizeArgs() {
            for (Map.Entry<String, Object> e : this.args.entrySet()) {
                Double d;
                Object object = e.getValue();
                if (!(object instanceof Double) || (double)(d = (Double)object).intValue() != d) continue;
                e.setValue(d.intValue());
            }
        }
    }
}

