/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.shadow.org.java_websocket;

import me.ichun.shadow.org.java_websocket.WebSocket;
import me.ichun.shadow.org.java_websocket.WebSocketListener;
import me.ichun.shadow.org.java_websocket.drafts.Draft;
import me.ichun.shadow.org.java_websocket.exceptions.InvalidDataException;
import me.ichun.shadow.org.java_websocket.framing.Framedata;
import me.ichun.shadow.org.java_websocket.framing.PingFrame;
import me.ichun.shadow.org.java_websocket.framing.PongFrame;
import me.ichun.shadow.org.java_websocket.handshake.ClientHandshake;
import me.ichun.shadow.org.java_websocket.handshake.HandshakeImpl1Server;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshake;
import me.ichun.shadow.org.java_websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }
}

