/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.Validations;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BeaconCache {
    public static Map<UUID, class_2338> cachedPlayersBeacons = new HashMap<UUID, class_2338>();
    private static final Map<UUID, Long> playersToRemove = new HashMap<UUID, Long>();
    private static final int REMOVE_PLAYER_TIMEOUT = 6000;

    public static void init() {
        LifecycleEvent.SERVER_STOPPING.register(BeaconCache::clearCache);
        TickEvent.SERVER_LEVEL_POST.register(BeaconCache::onServerWorldTick);
        PlayerEvent.PLAYER_QUIT.register(BeaconCache::onPlayerQuit);
        PlayerEvent.PLAYER_JOIN.register(BeaconCache::onPlayerJoin);
    }

    private static void clearCache(MinecraftServer minecraftServer) {
        cachedPlayersBeacons.clear();
        playersToRemove.clear();
    }

    public static boolean IsPlayerOnRemoveQueue(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return false;
        }
        UUID playerUUID = serverPlayerEntity.method_5667();
        return playersToRemove.containsKey(playerUUID);
    }

    public static void addPlayerToRemoveQueue(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.method_5667();
        playersToRemove.put(playerUUID, serverPlayerEntity.method_51469().method_8510());
    }

    public static void removePlayerFromRemoveQueue(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.method_5667();
        playersToRemove.remove(playerUUID);
    }

    private static void onPlayerQuit(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.method_5667();
        playersToRemove.put(playerUUID, serverPlayerEntity.method_51469().method_8510());
    }

    private static void onPlayerJoin(class_3222 serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        class_2338 cachedBeaconPos = cachedPlayersBeacons.getOrDefault(serverPlayerEntity.method_5667(), null);
        if (cachedBeaconPos == null) {
            return;
        }
        if (Validations.getBeaconSecondaryEffect(serverPlayerEntity.method_51469(), cachedBeaconPos) != class_1294.field_5917.comp_349() || !Validations.isPlayerOnBeaconRange(serverPlayerEntity, cachedBeaconPos)) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.method_5667();
        playersToRemove.remove(playerUUID);
    }

    private static void onServerWorldTick(class_3218 serverWorld) {
        if (serverWorld == null) {
            return;
        }
        if (serverWorld.method_8510() % 6000L == 0L) {
            BeaconCache.removePlayersOnCache(serverWorld);
        }
    }

    private static void removePlayersOnCache(class_3218 serverWorld) {
        HashSet<UUID> queuedPlayersToRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, Long> entry : playersToRemove.entrySet()) {
            UUID playerUUID = entry.getKey();
            long joinTime = entry.getValue();
            if (serverWorld.method_8510() - joinTime < 6000L) continue;
            cachedPlayersBeacons.remove(playerUUID);
            queuedPlayersToRemove.add(playerUUID);
        }
        for (UUID playerUUID : queuedPlayersToRemove) {
            playersToRemove.remove(playerUUID);
        }
    }
}

