/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.Constants;
import com.c24rew.deepin.Validations;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class BeaconSearchAlgorithm {
    private static final int ROD_RADIUS = 15;
    private static final int ROD_SPACING = 9;
    private static final int BEACON_BASE_LINE_SEARCH_LENGTH = 12;
    private static final int BEACON_SEARCH_RADIUS = 3;
    private Direction currentDirection;
    private float rodLineLength;
    private int stepsTaken;
    private final class_3218 world;
    private final class_2338 center;

    public BeaconSearchAlgorithm(class_3218 world, class_2338 center) {
        this.world = world;
        this.center = center;
        this.currentDirection = Direction.NORTH;
        this.rodLineLength = 1.0f;
        this.stepsTaken = 0;
    }

    public Set<class_2338> searchBeacon() {
        this.stepsTaken = 0;
        this.rodLineLength = 1.0f;
        this.currentDirection = Direction.NORTH;
        HashSet<class_2338> beaconMaterialsPositions = new HashSet<class_2338>();
        HashSet<class_2338> beaconPositions = new HashSet<class_2338>();
        class_2338 rodSearchPosition = this.center;
        while (rodSearchPosition != null) {
            this.searchRod(rodSearchPosition, beaconMaterialsPositions);
            rodSearchPosition = this.getNextRodPosition(rodSearchPosition);
        }
        if (beaconMaterialsPositions.isEmpty()) {
            return new HashSet<class_2338>();
        }
        for (class_2338 pos : beaconMaterialsPositions) {
            this.findBeaconFromBase(pos, beaconPositions);
        }
        if (beaconPositions.isEmpty()) {
            return new HashSet<class_2338>();
        }
        HashSet<class_2338> validBeaconPositions = new HashSet<class_2338>();
        for (class_2338 beaconPos : beaconPositions) {
            if (!Validations.validateBeacon(this.world, beaconPos)) continue;
            validBeaconPositions.add(beaconPos);
        }
        return validBeaconPositions;
    }

    private void searchRod(class_2338 center, Set<class_2338> positions) {
        int maxHeight;
        int minY = this.world.method_31607();
        int maxY = center.method_10264() + 50 + 1;
        if (maxY > (maxHeight = this.world.method_31605() - minY - 1)) {
            maxY = maxHeight;
        }
        int centerX = center.method_10263();
        int centerZ = center.method_10260();
        boolean lastPosWasBeaconMaterial = false;
        for (int y = minY; y <= maxY; ++y) {
            class_2338 pos = new class_2338(centerX, y, centerZ);
            class_2248 block = this.world.method_8320(pos).method_26204();
            if (!Constants.BEACON_MATERIALS.contains(block)) {
                lastPosWasBeaconMaterial = false;
                continue;
            }
            if (lastPosWasBeaconMaterial) continue;
            positions.add(pos);
            lastPosWasBeaconMaterial = true;
        }
    }

    private class_2338 getNextRodPosition(class_2338 lastRodPosition) {
        int x = lastRodPosition.method_10263();
        int z = lastRodPosition.method_10260();
        switch (this.currentDirection.ordinal()) {
            case 0: {
                z -= 9;
                break;
            }
            case 1: {
                z += 9;
                break;
            }
            case 2: {
                x += 9;
                break;
            }
            case 3: {
                x -= 9;
            }
        }
        ++this.stepsTaken;
        if (this.stepsTaken > 15) {
            return null;
        }
        if ((double)this.stepsTaken >= Math.floor(this.rodLineLength)) {
            this.stepsTaken = 0;
            this.rodLineLength += 0.5f;
            this.currentDirection = this.currentDirection.next();
        }
        return new class_2338(x, lastRodPosition.method_10264(), z);
    }

    private void findBeaconFromBase(class_2338 pos, Set<class_2338> beaconPositions) {
        class_2338 blockPos;
        boolean foundBeaconMaterial;
        class_2338 xCenterPos = this.getCenterPos(pos, true);
        if (xCenterPos == null) {
            return;
        }
        class_2338 zCenterPos = this.getCenterPos(xCenterPos, false);
        if (zCenterPos == null) {
            return;
        }
        for (int y = zCenterPos.method_10264() + 5 - 1; y <= zCenterPos.method_10264() + 5 && (foundBeaconMaterial = this.findBeaconsFromBeacon(blockPos = new class_2338(zCenterPos.method_10263(), y, zCenterPos.method_10260()), beaconPositions)); ++y) {
        }
    }

    private class_2338 getCenterPos(class_2338 initialPos, boolean isXAxis) {
        class_2338 firstBeaconMaterialBlockPos = null;
        int beaconMaterialLength = 0;
        for (int i = 0; i <= 25; ++i) {
            class_2338 currentPos = isXAxis ? initialPos.method_10069(i - 12, 0, 0) : initialPos.method_10069(0, 0, i - 12);
            class_2248 block = this.world.method_8320(currentPos).method_26204();
            if (!Constants.BEACON_MINERAL_BLOCKS.contains(block)) {
                if (firstBeaconMaterialBlockPos == null) continue;
                break;
            }
            if (firstBeaconMaterialBlockPos == null) {
                firstBeaconMaterialBlockPos = currentPos;
            }
            ++beaconMaterialLength;
        }
        if (firstBeaconMaterialBlockPos == null || beaconMaterialLength < 9) {
            return null;
        }
        if (isXAxis) {
            int xCenter = firstBeaconMaterialBlockPos.method_10263() + beaconMaterialLength / 2;
            return new class_2338(xCenter, initialPos.method_10264(), initialPos.method_10260());
        }
        int zCenter = firstBeaconMaterialBlockPos.method_10260() + beaconMaterialLength / 2;
        return new class_2338(initialPos.method_10263(), initialPos.method_10264(), zCenter);
    }

    private boolean findBeaconsFromBeacon(class_2338 beaconPos, Set<class_2338> beaconPositions) {
        boolean foundBeaconMaterial = false;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    class_2338 currentPos = beaconPos.method_10069(x, y, z);
                    class_2248 block = this.world.method_8320(currentPos).method_26204();
                    if (block == class_2246.field_10327) {
                        beaconPositions.add(currentPos);
                    }
                    if (!Constants.BEACON_MATERIALS.contains(block)) continue;
                    foundBeaconMaterial = true;
                }
            }
        }
        return foundBeaconMaterial;
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;


        public Direction next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EAST;
                case 2 -> SOUTH;
                case 1 -> WEST;
                case 3 -> NORTH;
            };
        }
    }
}

