/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.DeepIn;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class Validations {
    public static boolean validateBeacon(class_3218 serverWorld, class_2338 beaconPos) {
        if (!(serverWorld.method_8321(beaconPos) instanceof class_2580)) {
            return false;
        }
        if (!Validations.hasBeamAccess(serverWorld, beaconPos)) {
            return false;
        }
        return Validations.getBeaconLevel(serverWorld, beaconPos) > 0;
    }

    public static int getBeaconLevel(class_3218 serverWorld, class_2338 beaconPos) {
        class_2586 class_25862 = serverWorld.method_8321(beaconPos);
        if (!(class_25862 instanceof class_2580)) {
            return 0;
        }
        class_2580 beacon = (class_2580)class_25862;
        try {
            class_2487 nbt = beacon.method_38244((class_7225.class_7874)serverWorld.method_30349());
            if (!nbt.method_10545("Levels")) {
                return 0;
            }
            Optional levelsOptional = nbt.method_10550("Levels");
            return levelsOptional.orElse(0);
        }
        catch (Exception e) {
            DeepIn.LOGGER.error("Error accessing beacon level from NBT: {}", (Object)e.getMessage());
            return 0;
        }
    }

    private static boolean hasBeamAccess(class_3218 world, class_2338 beaconPos) {
        int maxHeight = world.method_31605() - world.method_31607() - 1;
        for (int y = beaconPos.method_10264() + 1; y < maxHeight; ++y) {
            class_2338 checkPos = new class_2338(beaconPos.method_10263(), y, beaconPos.method_10260());
            if (world.method_8320(checkPos).method_26167() || world.method_8320(checkPos).method_26204() == class_2246.field_9987) continue;
            return false;
        }
        return true;
    }

    public static class_1291 getBeaconSecondaryEffect(class_3218 serverWorld, class_2338 beaconPos) {
        if (!Validations.validateBeacon(serverWorld, beaconPos)) {
            return null;
        }
        class_2580 beacon = (class_2580)serverWorld.method_8321(beaconPos);
        if (beacon == null) {
            return null;
        }
        try {
            class_2487 nbt = beacon.method_38244((class_7225.class_7874)serverWorld.method_30349());
            if (!nbt.method_10545("secondary_effect")) {
                return null;
            }
            Optional secondaryEffectOptional = nbt.method_10558("secondary_effect");
            if (secondaryEffectOptional.isEmpty()) {
                return null;
            }
            String secondaryEffectId = (String)secondaryEffectOptional.get();
            class_2960 effectId = class_2960.method_12829((String)secondaryEffectId);
            if (effectId == null) {
                return null;
            }
            return (class_1291)class_7923.field_41174.method_63535(effectId);
        }
        catch (Exception e) {
            DeepIn.LOGGER.error("Error accessing beacon secondary effect from NBT: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean beaconHasHaste2(class_3218 world, class_2338 beaconPos) {
        class_1291 statusEffect = Validations.getBeaconSecondaryEffect(world, beaconPos);
        if (statusEffect == null) {
            return false;
        }
        return statusEffect == class_1294.field_5917.comp_349();
    }

    public static boolean isPlayerOnBeaconRange(class_3222 player, class_2338 beaconPos) {
        boolean horizontalIntersection;
        if (player == null || beaconPos == null) {
            return false;
        }
        if (Validations.isPosOnBeaconRange(player.method_24515(), beaconPos)) {
            return true;
        }
        float width = player.method_17681();
        float height = player.method_17682();
        double minX = player.method_23317() - (double)width / 2.0;
        double maxX = player.method_23317() + (double)width / 2.0;
        double minY = player.method_23318();
        double maxY = player.method_23318() + (double)height;
        double minZ = player.method_23321() - (double)width / 2.0;
        double maxZ = player.method_23321() + (double)width / 2.0;
        double beaconMinX = beaconPos.method_10263() - 50;
        double beaconMaxX = beaconPos.method_10263() + 50 + 1;
        double beaconMinZ = beaconPos.method_10260() - 50;
        double beaconMaxZ = beaconPos.method_10260() + 50 + 1;
        boolean bl = horizontalIntersection = !(maxX <= beaconMinX || minX >= beaconMaxX || maxZ <= beaconMinZ || minZ >= beaconMaxZ);
        if (!horizontalIntersection) {
            return false;
        }
        if (minY >= (double)beaconPos.method_10264()) {
            return true;
        }
        double beaconMinY = beaconPos.method_10264() - 50;
        return maxY > beaconMinY;
    }

    public static boolean isPosOnBeaconRange(class_2338 pos, class_2338 beaconPos) {
        if (pos == null || beaconPos == null) {
            return false;
        }
        int dx = Math.abs(pos.method_10263() - beaconPos.method_10263());
        int dz = Math.abs(pos.method_10260() - beaconPos.method_10260());
        if (dx > 50 || dz > 50) {
            return false;
        }
        int dy = pos.method_10264() - beaconPos.method_10264();
        if (dy >= 0) {
            return true;
        }
        return Math.abs(dy) <= 50;
    }

    public static boolean playerHasHaste2(class_3222 player) {
        if (!player.method_6059(class_1294.field_5917)) {
            return false;
        }
        class_1293 statusEffect = player.method_6112(class_1294.field_5917);
        if (statusEffect == null || statusEffect.method_5578() < 1) {
            return false;
        }
        return statusEffect.method_5584() > 0;
    }
}

