/*
 * Decompiled with CFR 0.152.
 */
package com.c24rew.deepin;

import com.c24rew.deepin.Validations;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;

public class BeaconCache {
    public static Map<UUID, BlockPos> cachedPlayersBeacons = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Long> playersToRemove = new HashMap<UUID, Long>();
    private static final int REMOVE_PLAYER_TIMEOUT = 6000;

    public static void init() {
        LifecycleEvent.SERVER_STOPPING.register(BeaconCache::clearCache);
        TickEvent.SERVER_LEVEL_POST.register(BeaconCache::onServerWorldTick);
        PlayerEvent.PLAYER_QUIT.register(BeaconCache::onPlayerQuit);
        PlayerEvent.PLAYER_JOIN.register(BeaconCache::onPlayerJoin);
    }

    private static void clearCache(MinecraftServer minecraftServer) {
        cachedPlayersBeacons.clear();
        playersToRemove.clear();
    }

    public static boolean IsPlayerOnRemoveQueue(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return false;
        }
        UUID playerUUID = serverPlayerEntity.getUUID();
        return playersToRemove.containsKey(playerUUID);
    }

    public static void addPlayerToRemoveQueue(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.getUUID();
        playersToRemove.put(playerUUID, serverPlayerEntity.level().getGameTime());
    }

    public static void removePlayerFromRemoveQueue(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.getUUID();
        playersToRemove.remove(playerUUID);
    }

    private static void onPlayerQuit(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.getUUID();
        playersToRemove.put(playerUUID, serverPlayerEntity.level().getGameTime());
    }

    private static void onPlayerJoin(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity == null) {
            return;
        }
        BlockPos cachedBeaconPos = cachedPlayersBeacons.getOrDefault(serverPlayerEntity.getUUID(), null);
        if (cachedBeaconPos == null) {
            return;
        }
        if (Validations.getBeaconSecondaryEffect(serverPlayerEntity.level(), cachedBeaconPos) != MobEffects.HASTE.value() || !Validations.isPlayerOnBeaconRange(serverPlayerEntity, cachedBeaconPos)) {
            return;
        }
        UUID playerUUID = serverPlayerEntity.getUUID();
        playersToRemove.remove(playerUUID);
    }

    private static void onServerWorldTick(ServerLevel serverWorld) {
        if (serverWorld == null) {
            return;
        }
        if (serverWorld.getGameTime() % 6000L == 0L) {
            BeaconCache.removePlayersOnCache(serverWorld);
        }
    }

    private static void removePlayersOnCache(ServerLevel serverWorld) {
        HashSet<UUID> queuedPlayersToRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, Long> entry : playersToRemove.entrySet()) {
            UUID playerUUID = entry.getKey();
            long joinTime = entry.getValue();
            if (serverWorld.getGameTime() - joinTime < 6000L) continue;
            cachedPlayersBeacons.remove(playerUUID);
            queuedPlayersToRemove.add(playerUUID);
        }
        for (UUID playerUUID : queuedPlayersToRemove) {
            playersToRemove.remove(playerUUID);
        }
    }
}

